import constants
from utils import file_utils
from utils.shell_args import SHELL_ARGS


def highlight_sentence_with_unk(sentence, vocab):
    words = [word if word in vocab else '__{}__'.format(word) for word in sentence.split(' ')]
    return ' '.join(words)


def main(prefix):
    vocab = file_utils.read_file_to_string('{}{}'.format(prefix, constants.SUFFIX_VOCAB_TARGET)).split('\n')
    vocab = {word: True for word in vocab}

    target_sentences = file_utils.read_file_to_string('{}{}'.format(prefix, constants.SUFFIX_TEST_TARGET)).split('\n')
    predicted_target_sentences = file_utils.read_file_to_string(
        '{}{}'.format(prefix, constants.SUFFIX_TEST_PREDICTED_TARGET)).split('\n')

    target_sentences = [highlight_sentence_with_unk(sentence, vocab) for sentence in target_sentences]
    predicted_target_sentences = [highlight_sentence_with_unk(sentence, vocab) for sentence in
                                  predicted_target_sentences]

    file_utils.write_string_to_file('{}{}.highlight_unk'.format(prefix, constants.SUFFIX_TEST_TARGET),
                                    '\n'.join(target_sentences))
    file_utils.write_string_to_file('{}{}.highlight_unk'.format(prefix, constants.SUFFIX_TEST_PREDICTED_TARGET),
                                    '\n'.join(predicted_target_sentences))


if __name__ == '__main__':
    main(SHELL_ARGS.prefix)
