import os
import re

from utils import file_utils
from utils.shell_args import SHELL_ARGS


def bleu(reference, prediction):
    ref_filename = 'tmp.ref'
    pred_filename = 'tmp.pred'
    file_utils.write_string_to_file(ref_filename, reference)
    file_utils.write_string_to_file(pred_filename, prediction)
    res = os.popen('%s %s < %s 2>&1' % (SHELL_ARGS.bleu_script, ref_filename, pred_filename))
    raw_bleu_output = res.read()
    res.close()
    os.remove(ref_filename)
    os.remove(pred_filename)

    match_result = re.match(r'[\s\S]*BLEU = (.*?), .*', raw_bleu_output)

    bleu_score = float(match_result.group(1))

    return bleu_score
