"""Constant values in the project."""

import os
from enum import unique, Enum

from utils.shell_args import SHELL_ARGS

ROOT_DIR = os.path.dirname(os.path.abspath(__file__))
STATIC_DIR = os.path.join(ROOT_DIR, 'static')

# filename
MODEL_FILENAME = os.path.join(STATIC_DIR, 'model/trained_model.ckpt')

# summary
SUMMARY_DIR = os.path.join(STATIC_DIR, 'summary')
SUMMARY_TRAIN_FILENAME = os.path.join(SUMMARY_DIR, 'train')
SUMMARY_EVAL_FILENAME = os.path.join(SUMMARY_DIR, 'eval')
SUMMARY_AVERAGE_TRAIN_FILENAME = os.path.join(SUMMARY_DIR, 'average_train')
SUMMARY_AVERAGE_EVAL_FILENAME = os.path.join(SUMMARY_DIR, 'average_eval')
SUMMARY_LR_FILENAME = os.path.join(SUMMARY_DIR, 'learning_rate')

# suffix
SUFFIX_TRAIN_SOURCE = '.train.source'
SUFFIX_TRAIN_TARGET = '.train.target'
SUFFIX_EVAL_SOURCE = '.eval.source'
SUFFIX_EVAL_TARGET = '.eval.target'
SUFFIX_VOCAB_SOURCE = '.vocab.source'
SUFFIX_VOCAB_TARGET = '.vocab.target'
SUFFIX_TEST_SOURCE = '.test.source'
SUFFIX_TEST_TARGET = '.test.target'
SUFFIX_TEST_PREDICTED_TARGET = '.test.predicted.target'


# special words
@unique
class SpecialWord(Enum):
    START = '<START>'
    EOS = '<EOS>'
    UNK = '<UNK>'
    PAD = '<PAD>'


SPECIAL_WORD_LEAF = '<leaf>'
SPECIAL_WORD_BR = '<br>'
SPECIAL_WORD_BLOCK = '<block>'
SPECIAL_WORD_ADD = '<add>'
SPECIAL_WORD_DELETE = '<delete>'
SPECIAL_WORD_SAME = '<same>'
SPECIAL_WORD_FILE_START = '<file>'
SPECIAL_WORD_FILE_END = '</file>'
SPECIAL_WORD_JAVA_FILE_START = '<java_file>'
SPECIAL_WORD_JAVA_FILE_END = '</java_file>'
SPECIAL_WORD_WORD_START = '<word>'
SPECIAL_WORD_WORD_END = '</word>'

# Hyper parameters for seq2seq
EMBEDDING_SIZE = 512
RNN_SIZE = 512
NUM_LAYERS = 4
BATCH_SIZE = SHELL_ARGS.batch_size
LEARNING_RATE = SHELL_ARGS.lr
CLIP_NORM = 5
EPOCHS_SUM = 1000
DROP_OUT = 0.3

BEAM_WIDTH = 3
FORGET_BIAS = 1.0

TEST_RATE = 0.12
EVAL_RATE = 0.15 + TEST_RATE

SOURCE_SEQ_LEN_MAX = 100
TARGET_SEQ_LEN_MAX = 30

# mongodb
DATABASE = {
    'HOST': 'localhost',
    'PORT': 27017,
    'DATABASE': 'github2'
}

DB_COLLECTIONS = {
    'BRIEF_REPOS': 'brief_repos'
}

REPO_STATUS = {
    'NO_DEAL': 0,
    'SUCCESS': 1,
    'ERROR': 2
}
