% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_vc.R
\name{write_vc}
\alias{write_vc}
\alias{write_vc.git_repository}
\title{Write a \code{data.frame}}
\usage{
write_vc(x, file, root = ".", sorting, strict = TRUE,
  optimize = TRUE, na = "NA", ...)

\method{write_vc}{git_repository}(x, file, root, sorting, strict = TRUE,
  optimize = TRUE, na = "NA", ..., stage = FALSE, force = FALSE)
}
\arguments{
\item{x}{the `data.frame}

\item{file}{the name of the file without file extension. Can include a
relative path. It is relative to the \code{root}.}

\item{root}{The root of a project. Can be a file path or a \code{git-repository}.
Defaults to the current working directory (".").}

\item{sorting}{a vector of column names defining which columns to use for
sorting \code{x} and in what order to use them. Only required when writing
new metadata.}

\item{strict}{What to do when the metadata changes. \code{strict = FALSE} will
overwrite the data with a warning listing the changes, \code{strict = TRUE} will
return an error and leave the data as is. Default to \code{TRUE}}

\item{optimize}{recode the data to get smaller text files. Defaults to TRUE}

\item{na}{the string to use for missing values in the data.}

\item{...}{additional parameters used in some methods}

\item{stage}{stage the changes after writing the data. Defaults to FALSE}

\item{force}{Add ignored files. Default is FALSE.}
}
\value{
a named vector with the file paths relative to \code{root}. The names
contain the hashes of the files.
}
\description{
This will create two files. The \code{".tsv"} file contains the raw data.
The \code{".yml"} contains the meta data on the columns in YAML format.
}
\examples{
## on file system

# create a directory
root <- tempfile("git2rdata-")
dir.create(root)

# write a dataframe to the directory
write_vc(iris[1:6, ], file = "iris", root = root, sorting = "Sepal.Length")
# check that a data file (.tsv) and a meta data file (.yml) are created
list.files(root, recursive = TRUE)
# read the data from the directory
read_vc("iris", root)

# store a new version
write_vc(iris[1:5, ], "iris", root)
list.files(root, recursive = TRUE)
# store a new version in case the meta data must change
write_vc(
  iris[1:6, -2], "iris", root, sorting = "Sepal.Length", strict = FALSE
)
list.files(root, recursive = TRUE)
# storing the first version again required another update of the meta data
write_vc(iris[1:6, ], "iris", root, sorting = "Sepal.Width", strict = FALSE)
list.files(root, recursive = TRUE)
# storing the data in verbose format leads to larger files
write_vc(
  iris[1:6, ], "iris2", root, sorting = "Sepal.Width", optimize = FALSE
)
list.files(root, recursive = TRUE)



## on git repo

# initialise a git repo using the git2r package
repo_path <- tempfile("git2rdata-repo-")
dir.create(repo_path)
repo <- git2r::init(repo_path)
git2r::config(repo, user.name = "Alice", user.email = "alice@example.org")

# store a dataframe in git repo
write_vc(iris[1:6, ], file = "iris", root = repo, sorting = "Sepal.Length")
status(repo)
# read a dataframe from a git repo
read_vc("iris", repo)

# store a new version of in the git repo
write_vc(iris[1:5, ], "iris", repo, stage = TRUE)
status(repo)

# store a version with altered meta data
write_vc(
  iris[1:6, -2], "iris", repo, sorting = "Sepal.Length", strict = FALSE
)
status(repo)

# store the original version again
write_vc(
  iris[1:6, ], "iris", repo, sorting = "Sepal.Width", strict = FALSE,
  stage = TRUE
)
status(repo)

# store a verbose version in separate files
write_vc(
  iris[1:6, ], "iris2", repo, sorting = "Sepal.Width", optimize = FALSE
)
status(repo)
}
\seealso{
Other storage: \code{\link{list_data}},
  \code{\link{prune_meta}}, \code{\link{read_vc}},
  \code{\link{relabel}}, \code{\link{rm_data}}
}
\concept{storage}
