% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune.R
\name{rm_data}
\alias{rm_data}
\alias{rm_data.git_repository}
\title{Remove data files}
\usage{
rm_data(root = ".", path = NULL, recursive = TRUE, ...)

\method{rm_data}{git_repository}(root, path = NULL, recursive = TRUE,
  ..., stage = FALSE, type = c("unmodified", "modified", "ignored",
  "all"))
}
\arguments{
\item{root}{The root of a project. Can be a file path or a \code{git-repository}.
Defaults to the current working directory (".").}

\item{path}{the directory in which to clean all the data files}

\item{recursive}{remove files in subdirectories too}

\item{...}{additional parameters used in some methods}

\item{stage}{stage the changes after removing the files. Defaults to FALSE.}

\item{type}{which classes of files should be removed. \code{unmodified} are files in the git history and unchanged since the last commit. \code{modified} are files in the git history and changed since the last commit. \code{ignored} refers to file listed in a \code{.gitignore} file. Selecting \code{modified} will remove both \code{unmodified} and \code{modified} data files. Selecting \code{ìgnored} will remove \code{unmodified}, \code{modified} and \code{ignored} data files. \code{all} refers to all visible data files, inclusing \code{untracked} files. The argument can be abbreviated to the first letter.}
}
\value{
returns invisibily a vector of removed files names. The paths are
relative to \code{root}.
}
\description{
Removes all data (\code{.tsv} files) from the \code{path} when they have accompanying metadata (\code{.yml} file). The metadata remains untouched. See the \href{https://inbo.github.io/git2rdata/articles/workflow.html}{workflow} vignette (\code{vignette("workflow", package = "git2rdata")}) for some examples on how to use this.
}
\examples{
## on file system

# create a directory
root <- tempfile("git2rdata-")
dir.create(root)

# store a dataframe
write_vc(iris[1:6, ], "iris", root, sorting = "Sepal.Length")
# list the available data and the files
list_data(root)
list.files(root, recursive = TRUE)

# remove all .tsv files with an associated .yml file
rm_data(root, path = ".")
# check the removal of the data
list.files(root, recursive = TRUE)
list_data(root)

# remove dangling meta data files
prune_meta(root, path = ".")
# check the removal of the meta data
list.files(root, recursive = TRUE)
list_data(root)


## on git repo

# initialise a git repo using git2r
repo_path <- tempfile("git2rdata-repo-")
dir.create(repo_path)
repo <- git2r::init(repo_path)
git2r::config(repo, user.name = "Alice", user.email = "alice@example.org")

# store a dataframe
write_vc(iris[1:6, ], "iris", repo, sorting = "Sepal.Length", stage = TRUE)
# check that the dataframe is stored
status(repo)
list_data(repo)

# commit the current version and check the git repo
commit(repo, "add iris data", session = TRUE)
status(repo)

# remove the data files from the repo
rm_data(repo, path = ".")
# check the removal
list_data(repo)
status(repo)

# remove dangling meta data
prune_meta(repo, path = ".")
# check the removal
list_data(repo)
status(repo)
}
\seealso{
Other storage: \code{\link{list_data}},
  \code{\link{prune_meta}}, \code{\link{read_vc}},
  \code{\link{relabel}}, \code{\link{write_vc}}
}
\concept{storage}
