% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabel.R
\name{relabel}
\alias{relabel}
\title{Relabel factor levels}
\usage{
relabel(file, root = ".", change)
}
\arguments{
\item{file}{the name of the file without file extension. Can include a
relative path. It is relative to the \code{root}.}

\item{root}{The root of a project. Can be a file path or a \code{git-repository}.
Defaults to the current working directory (".").}

\item{change}{either list or a data.frame. In case of a list is a named list
with named vectors. The name of list elements must match the names of the
variables. The names of the vector elements must match the existing factor
labels. The values represent the new factor labels. In case of a data.frame
it needs to have the variables \code{factor} (name of the factor), \code{old} (the old)
factor label and \code{new} (the new factor label). Other columns are ignored.}
}
\value{
invisible \code{NULL}
}
\description{
Imaging the situation where we have a dataframe with a factor variable and we
have stored it with \code{write_vc(optimize = TRUE)}. The raw data file contains
the factor indices and the metadata contains the link between the factor
index and the corresponding label.
}
\examples{

# setup a directory
root <- tempfile("git2rdata-relabel")
dir.create(root)

# create a dataframe and store it
ds <- ds <- data.frame(a = c("a1", "a2"), b = c("b2", "b1"))
write_vc(ds, "relabel", root, sorting = "b")

# define new labels as a list and apply them
new_labels <- list(
  a = list(a2 = "a3")
)
relabel("relabel", root, new_labels)

# define new labels as a dataframe and apply them
change <- data.frame(
  factor = c("a", "a", "b"),
  old = c("a3", "a1", "b2"),
  new = c("c2", "c1", "b3")
)
relabel("relabel", root, change)
}
\seealso{
Other storage: \code{\link{list_data}},
  \code{\link{prune_meta}}, \code{\link{read_vc}},
  \code{\link{rm_data}}, \code{\link{write_vc}}
}
\concept{storage}
