% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recent_commit.R
\name{recent_commit}
\alias{recent_commit}
\title{Most recent file change}
\usage{
recent_commit(file, root, data = FALSE)
}
\arguments{
\item{file}{the name of the file without file extension. Can include a
relative path. It is relative to the \code{root}.}

\item{root}{The root of a project. Can be a file path or a \code{git-repository}}

\item{data}{does \code{file} refers to a data object (TRUE) or to a file (FALSE).
Defaults to FALSE.}
}
\value{
a \code{data.frame} with \code{commit}, \code{author} and \code{when} for the most recent
commit in which the file was altered
}
\description{
Retrieve the most recent commit in which a file or data object was added or updated.
}
\examples{
# initialise a git repo using git2r
repo_path <- tempfile("git2rdata-repo")
dir.create(repo_path)
repo <- git2r::init(repo_path)
git2r::config(repo, user.name = "Alice", user.email = "alice@example.org")

# write and commit a first dataframe
write_vc(iris[1:6, ], "iris", repo, sorting = "Sepal.Length", stage = TRUE)
commit(repo, "important analysis", session = TRUE)
list.files(repo_path)
Sys.sleep(1.1) # required because git doesn't handle subsecond timings

# write and commit a second dataframe
write_vc(iris[7:12, ], "iris2", repo, sorting = "Sepal.Length", stage = TRUE)
commit(repo, "important analysis", session = TRUE)
list.files(repo_path)
Sys.sleep(1.1) # required because git doesn't handle subsecond timings

# write and commit a new version of the first dataframe
write_vc(iris[7:12, ], "iris", repo, stage = TRUE)
list.files(repo_path)
commit(repo, "important analysis", session = TRUE)

# find out in which commit a file was last changed

# "iris.tsv" was last updated in the third commit
recent_commit("iris.tsv", repo)
# "iris.yml" was last updated in the first commit
recent_commit("iris.yml", repo)
# "iris2.yml" was last updated in the second commit
recent_commit("iris2.yml", repo)
# the data object "iris" was last updated in the third commit
recent_commit("iris", repo, data = TRUE)

# remove a dataframe and commit it
file.remove(file.path(repo_path, "iris.tsv"))
prune_meta(repo, ".")
commit(repo, message = "remove iris", all = TRUE, session = TRUE)

# still points to the third commit as it is the latest commit in which the
# data was present
recent_commit("iris", repo, data = TRUE)
}
\seealso{
Other version_control: \code{\link{commit}},
  \code{\link{pull}}, \code{\link{push}},
  \code{\link{repository}}, \code{\link{status}}
}
\concept{version_control}
