% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\docType{methods}
\name{meta}
\alias{meta}
\alias{meta.character}
\alias{meta.factor}
\alias{meta.logical}
\alias{meta.POSIXct}
\alias{meta.Date}
\title{Optimize a vector for storage as plain text and add meta data}
\usage{
meta(x, ...)

\method{meta}{character}(x, na = "NA", ...)

\method{meta}{factor}(x, optimize = TRUE, na = "NA", index, ...)

\method{meta}{logical}(x, optimize = TRUE, ...)

\method{meta}{POSIXct}(x, optimize = TRUE, ...)

\method{meta}{Date}(x, optimize = TRUE, ...)
}
\arguments{
\item{x}{the vector}

\item{...}{further arguments to the methods}

\item{na}{the string to use for missing values in the data.}

\item{optimize}{recode the data to get smaller text files. Defaults to TRUE}

\item{index}{an optional named vector with existing factor indices. The names must match the existing factor levels. Unmatched levels from \code{x} will get new indices.}
}
\value{
the optimized vector \code{x} with \code{meta} attribute
}
\description{
\code{\link{write_vc}} applies this function automatically on your
data.frame.
}
\examples{
meta(c(NA, "'NA'", '"NA"', "abc\\tdef", "abc\\ndef"))
meta(1:3)
meta(seq(1, 3, length = 4))
meta(factor(c("b", NA, "NA"), levels = c("NA", "b", "c")))
meta(factor(c("b", NA, "a"), levels = c("a", "b", "c")), optimize = FALSE)
meta(factor(c("b", NA, "a"), levels = c("a", "b", "c"), ordered = TRUE))
meta(
  factor(c("b", NA, "a"), levels = c("a", "b", "c"), ordered = TRUE),
  optimize = FALSE
)
meta(c(FALSE, NA, TRUE))
meta(c(FALSE, NA, TRUE), optimize = FALSE)
meta(complex(real = c(1, NA, 2), imaginary = c(3, NA, -1)))
meta(as.POSIXct("2019-02-01 10:59:59", tz = "CET"))
meta(as.POSIXct("2019-02-01 10:59:59", tz = "CET"), optimize = FALSE)
meta(as.Date("2019-02-01"))
meta(as.Date("2019-02-01"), optimize = FALSE)
}
\concept{internal}
