% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_data.R
\name{list_data}
\alias{list_data}
\title{List available data files}
\usage{
list_data(root = ".", path = ".", recursive = TRUE)
}
\arguments{
\item{root}{the \code{root} of the repository. Either a path or a \code{git-repository}}

\item{path}{relative \code{path} from the \code{root}. Defaults to the \code{root}}

\item{recursive}{logical.  Should the listing recurse into directories?}
}
\value{
a character vector is dataframe names, including their relative path
}
\description{
List available data files
}
\examples{
## on file system

# create a directory
root <- tempfile("git2rdata-")
dir.create(root)

# store a dataframe
write_vc(iris[1:6, ], "iris", root, sorting = "Sepal.Length")
# list the available data and the files
list_data(root)
list.files(root, recursive = TRUE)

# remove all .tsv files with an associated .yml file
rm_data(root, path = ".")
# check the removal of the data
list.files(root, recursive = TRUE)
list_data(root)

# remove dangling meta data files
prune_meta(root, path = ".")
# check the removal of the meta data
list.files(root, recursive = TRUE)
list_data(root)


## on git repo

# initialise a git repo using git2r
repo_path <- tempfile("git2rdata-repo-")
dir.create(repo_path)
repo <- git2r::init(repo_path)
git2r::config(repo, user.name = "Alice", user.email = "alice@example.org")

# store a dataframe
write_vc(iris[1:6, ], "iris", repo, sorting = "Sepal.Length", stage = TRUE)
# check that the dataframe is stored
status(repo)
list_data(repo)

# commit the current version and check the git repo
commit(repo, "add iris data", session = TRUE)
status(repo)

# remove the data files from the repo
rm_data(repo, path = ".")
# check the removal
list_data(repo)
status(repo)

# remove dangling meta data
prune_meta(repo, path = ".")
# check the removal
list_data(repo)
status(repo)
}
\seealso{
Other storage: \code{\link{prune_meta}},
  \code{\link{read_vc}}, \code{\link{relabel}},
  \code{\link{rm_data}}, \code{\link{write_vc}}
}
\concept{storage}
