% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approxPot.R
\name{approxPot1D}
\alias{approxPot1D}
\title{Approximate potential in one dimension}
\usage{
approxPot1D(f, xs, V0 = "auto")
}
\arguments{
\item{f}{One-dimensional representing the flow (right hand side of differential equation)}

\item{xs}{Vector of positions to evaluate}

\item{V0}{(Optional) Value of V at first element of xs. When default, the global minimum is assigned 0}
}
\value{
The potential estimated at each point in xs
}
\description{
Approximate potential in one dimension
}
\examples{
# Flow
f = function(x) { sin(x) }

# Sampling points
xs <- seq(0, 2*pi, length.out = 1e3)

# Approximated potential
Vs <- approxPot1D(f, xs)
}
\seealso{
\code{\link{approxPot2D}, \link{deltaV}}
}
\author{
Pablo Rodríguez-Sánchez (\url{https://pabrod.github.io})
}
