//!
//! Interface of common functions shared by forward models.
//!
//! \file fwdmodel/fwd.hpp
//! \author Nahid Akbar
//! \date 2014
//! \license Affero General Public License version 3 or later
//! \copyright (c) 2014, NICTA
//!

#pragma once

#include "datatype/datatypes.hpp"
#include "world/interpolate.hpp"

namespace obsidian
{
  namespace fwd
  {
    //! Generate a cache object for a specific forward model. Cache objects
    //! contain repeatly used information that only needs to be computed once by
    //! the forward model.
    //!
    //! \param boundaryInterpolation The world model interpolation parameters.
    //! \param worldSpec The world model specification.
    //! \param spec The forward model specification.
    //! \returns Forward model cache object.
    //!
    template<ForwardModel f>
    typename Types<f>::Cache generateCache(const std::vector<world::InterpolatorSpec>& boundaryInterpolation, const WorldSpec& worldSpec,
                                           const typename Types<f>::Spec& spec);

    //! Run a particular forward model.
    //! 
    //! \param spec The forward model specification.
    //! \param cache The forward model cache generated by generateCache().
    //! \param world The world model parameters.
    //! \returns Forward model results.
    //!
    template<ForwardModel f>
    typename Types<f>::Results forwardModel(const typename Types<f>::Spec& spec, const typename Types<f>::Cache& cache,
                                            const WorldParams& world);

    namespace detail
    {
      //! Constant representing the imaginary number i.
      //!
      constexpr std::complex<double> I = std::complex<double>(0, 1);
    }
  }
}
