const fs = require('fs');
const argv = require('minimist')(process.argv.slice(2));
const repo_name = argv._[0];
const json = fs.readFileSync(argv._[1]);
const data = JSON.parse(json);

/*
* Prints a csv with the number of operations per toggle component
*
* Usage:
* node rqX-operations-per-type.js repo_name history.json
*/

const counts = {
  // 'Declaration': { ADDED: 0, MODIFIED: 0, DELETED: 0, count: 0 },
  'Router': { ADDED: 0, MODIFIED: 0, DELETED: 0, count: 0 },
  'Point': { ADDED: 0, MODIFIED: 0, DELETED: 0, count: 0 },
};

Object.keys(counts).forEach((type) => {
  const toggles = data[type];
  counts[type]['count'] =+ Object.values(toggles).length;
  Object.values(toggles).forEach((events) => {
    events.forEach((event) => {
      counts[type][event.operation] += 1;
    });
  });
});

const listsAsHeaders = (a, b, callback) => {
  return a
    .map((aItem) => b.map(bItem => callback(aItem, bItem)))
    .reduce((memo, item) => {
      return memo.concat(item);
    }, []).join(',')
};

const types = Object.keys(counts);
const operations = ['ADDED', 'MODIFIED', 'DELETED'];
const header = listsAsHeaders(types, operations, (type, op) => `${op}-${type}`);
const numbers = listsAsHeaders(types, operations, (type, op) => counts[type][op]);
const num_toggles_aprox = Object.keys(data['Router']).length;

console.log(`repo_name,${header},num_toggles_aprox`)
console.log(`${repo_name},${numbers},${num_toggles_aprox}`)
