const fs = require('fs');
const argv = require('minimist')(process.argv.slice(2));
const repo_name = argv._[0];
const json = fs.readFileSync(argv._[1]);
const data = JSON.parse(json);

/*
* Prints a csv appropriate for a survival analysis of a projects's history
*
* Usage:
* node rq3-survival.js repo_name history.json
*/

const survival = [];
const epochNow = parseInt(Date.now() / 1000, 10);

Object.keys(data).forEach((type) => {
  const toggles = data[type];
  Object.keys(toggles).forEach((toggleId) => {
    const events = toggles[toggleId];
    const firstEvent = events[0];
    const lastEvent = events[events.length - 1];
    const t1 = parseInt(firstEvent.commit.committerTs, 10);
    const t2 = lastEvent.operation === 'DELETED' ? parseInt(lastEvent.commit.committerTs, 10) : epochNow;
    survival.push({
      repo_name,
      toggle_id: toggleId,
      toggle_type: firstEvent.toggle.type,
      epoch_interval: t2 - t1,
      removed: (lastEvent.operation === 'DELETED' ? 1 : 0),
    });
  });
});

console.log(Object.keys(survival[0]).join(','));
survival.forEach((entry) => {
  console.log(Object.values(entry).join(','));
});
