library(survival)
library(readr)

data <- read_csv("analysis/merged/rq3-survival.csv")

secondsPerDay = 86400
kmsurvival = survfit(Surv(floor(data$epoch_interval/secondsPerDay), data$removed) ~ 1)
summary(kmsurvival)
plot(kmsurvival, main = paste("Kaplan-Meier estimate - All toggles"), xlab="Days", ylab="Survival Probability", col = 1:4)
boxplot(floor(data$epoch_interval/secondsPerDay))

kmsurvival_per_component = survfit(Surv(floor(data$epoch_interval/secondsPerDay), data$removed) ~ data$toggle_type)
summary(kmsurvival_per_component)
toggle_types = unique(data$toggle_type)
col = 1:length(toggle_types)
plot(kmsurvival_per_component, main = paste("Kaplan-Meier estimate - Per component"), xlab="Days", ylab="Survival Probability", col = col)
legend(x="topright", col = col, lwd=2, legend=toggle_types)
