library(readr)
library(beanplot)
library(vioplot)
library(effsize)

data <- read_csv('analysis/rqX-operations-per-type_round_7.csv')
summary(data$Removed_Routers)

wilcox.test(data$Removed_Routers,data$Removed_Points)
cliff.delta(data$Removed_Routers,data$Removed_Points)

# Export as pdf with 7inx6.02in (Portrait)
boxplot(data$commits)
title("Number of commits")

boxplot(data$toggles)
title("Number of toggles")

boxplot(data$Removed_Routers)
title("Removed Routers")
plot(density(data$Removed_Routers))
beanplot(data$Removed_Routers, data$Removed_Points, ylim=c(0, 1))
shapiro.test(data$Removed_Routers)

boxplot(data$Removed_Points)
title("Removed Points")
plot(density(data$Removed_Points))
beanplot(data$Removed_Points, ylim=c(0, 1))
shapiro.test(data$Removed_Points)

vioplot(data$Removed_Routers, data$Removed_Points, col=rgb(0.1,0.4,0.7), names=c("% Removed Routers", "% Removed Points"))