import unittest
import toggle_areas_collector as tac
import ast
from point import Point
from router import Router

class TestToggleAreasCollector(unittest.TestCase):

    def test_get_toggle_area_kwargs(self):
        collector = tac.ToggleAreasCollector('foo.py')
        expression = """
a = 3
if obj.flag_is_active(router, 'toggle-name'):
    pass
"""
        node = ast.parse(expression).body[1]
        kwargs = collector.get_toggle_area_kwargs(node)
        self.assertDictEqual(kwargs, {
            'file': 'foo.py',
            'start': {
                'line': 3,
                'column': 0
            },
            'end': {
                'line': 4,
                'column': 4
            },
            'ast': node
        })

    def test_collects_toggle_areas(self):
        collector = tac.ToggleAreasCollector('foo.py')
        expression = """
a = 3
if obj.flag_is_active(router, 'toggle-name'):
    pass
"""
        node = ast.parse(expression)
        collector.visit(node)
        toggles = collector.toggles
        self.assertEqual(len(toggles), 2)
        self.assertTrue(isinstance(toggles[0], Point))
        self.assertTrue(isinstance(toggles[1], Router))

if __name__ == '__main__':
    unittest.main()