import ast
from router import Router
from point import Point

# Collects the ToggleAreas from an AST node

class ToggleAreasCollector(ast.NodeVisitor):
    def __init__(self, filename):
        self.filename = filename
        self.toggles = []

    def get_range(self, line, column):
        return {
            'line': line,
            'column': column,
        }

    def get_area_ranges(self, node):
        ast.fix_missing_locations(node)

        lowest_node = node
        for descendant in ast.walk(node):
            if hasattr(descendant, 'lineno') and descendant.lineno > lowest_node.lineno:
                lowest_node = descendant

        return {
            'start': self.get_range(node.lineno, node.col_offset),
            'end': self.get_range(lowest_node.lineno, lowest_node.col_offset),
        }

    def get_toggle_area_kwargs(self, node):
        ranges = self.get_area_ranges(node)
        kwargs = {
            'file': self.filename,
            'start': ranges['start'],
            'end': ranges['end'],
            'ast': node
        }

        return kwargs

    def visit_Call(self, node):
        if Router.is_router(node):
            kwargs = self.get_toggle_area_kwargs(node)
            self.toggles.append(Router(**kwargs))

        self.generic_visit(node)

    def visit_If(self, node):
        if Point.is_point(node):
            kwargs = self.get_toggle_area_kwargs(node)
            self.toggles.append(Point(**kwargs))

        self.generic_visit(node)
