import hashlib
import astor
import json

ENCODING = 'utf-8'

class ToggleArea():
    def __init__(self, file, start, end, ast):
        self.file = file
        self.start = start
        self.end = end
        self.ast = ast

        self.type = self.__class__.__name__

        # unique across all usages
        self.id = self.id()

        # repeated in all instances across all usages
        self.common_id = self.common_id()

        # The hash is useful to compare toggles with a higher degree of granularity.
        # It is used instead of the common_id, despite its similarity (ast + no location
        # fingerprints), because the common_id can strip valuable parts of the ast that
        # could be needed for detailed comparisson purposes across toggles.
        self.hash = self.hash()

    def id(self):
        if self.type != 'ToggleArea':
            raise NotImplementedError('id() must be implemented')

    def common_id(self):
        if self.type != 'ToggleArea':
            raise NotImplementedError('common_id() must be implemented')

    def hash(self):
        hash = hashlib.sha256()
        hash.update(bytes(astor.to_source(self.ast, add_line_information=False), ENCODING))
        return hash.hexdigest()

    @classmethod
    def ast_as_string(self, ast):
        return json.dumps(ast, default=lambda o: o.__dict__)
