import unittest
from router import Router
import re
import ast

class TestRouter(unittest.TestCase):

    def get_ast(self, expression):
        return ast.parse(expression).body[0].value

    def assert_id(self, expression, toggle_name=r'[a-z0-9\-_]+'):
        router = Router('foo.py', None, None, self.get_ast(expression))
        self.assertTrue(re.search(r'^' + toggle_name + r'-[a-z0-9]{64}$', router.id), msg='{0} does not have the correct format id'.format(router.id))

    def assert_is_router(self, method):
        self.assertTrue(Router.is_router(self.get_ast(method)))

    def test_id_flag_is_active(self):
        toggle_name = 'toggle_as_variable'
        self.assert_id("obj.flag_is_active(request, '{0}')".format(toggle_name), toggle_name)

    def test_id_switch_is_active(self):
        toggle_name = 'toggle_as.ATTRIBUTE'
        self.assert_id("obj.switch_is_active('{0}')".format(toggle_name), toggle_name)

    def test_id_sample_is_active(self):
        self.assert_id("obj.sample_is_active('toggle-name')")

    def get_expression(self, method='flag_is_active', toggle_name="'toggle-name'"):
        if method == 'flag_is_active':
            return "obj.{0}(request, {1})".format(method, toggle_name)
        else:
            return "obj.{0}({1})".format(method, toggle_name)

    def test_same_common_id_when_different_files(self):
        router_one = Router('foo.py', None, None, self.get_ast(self.get_expression()))
        router_two = Router('bar.py', None, None, self.get_ast(self.get_expression()))
        self.assertEqual(router_one.common_id, router_two.common_id)

    def test_same_common_id_when_different_files(self):
        router_one = Router('foo.py', None, None, self.get_ast(self.get_expression()))
        router_two = Router('foo.py', None, None, self.get_ast(self.get_expression()))
        self.assertEqual(router_one.common_id, router_two.common_id)

    def test_is_router_flag_is_active(self):
        self.assert_is_router("obj.flag_is_active(request, 'toggle-name')")

    def test_is_router_switch_is_active(self):
        self.assert_is_router("obj.switch_is_active('toggle-name')")

    def test_is_router_sample_is_active(self):
        self.assert_is_router("obj.sample_is_active('toggle-name')")

    def test_is_router_flag_is_active_no_instance(self):
        self.assert_is_router("flag_is_active(request, 'toggle-name')")

    def test_is_router_switch_is_active_no_instance(self):
        self.assert_is_router("switch_is_active('toggle-name')")

    def test_is_router_sample_is_active_no_instance(self):
        self.assert_is_router("sample_is_active('toggle-name')")

if __name__ == '__main__':
    unittest.main()