import hashlib
import ast
import astor
import toggle_area

ENCODING = 'utf-8'

WAFFLE_ROUTERS = set([
    'flag_is_active',
    'switch_is_active',
    'sample_is_active'
])

WAFFLE_NAMES_ARG_POS = {
    'flag_is_active': 1,
    'switch_is_active': 0,
    'sample_is_active': 0,
}

class Router(toggle_area.ToggleArea):
    def __init__(self, file, start, end, ast):
        super(Router, self).__init__(file, start, end, ast)

    def id(self):
        hash = hashlib.sha256()
        hash.update(bytes(self.file, ENCODING))
        hash.update(bytes(Router.ast_as_string(self.ast), ENCODING))
        return '{name}-{hash}'.format(name=self.__get_name(), hash=hash.hexdigest())

    def common_id(self):
        hash = hashlib.sha256()
        hash.update(bytes(astor.to_source(self.ast, add_line_information=False), ENCODING))
        return '{name}-{hash}'.format(name=self.__get_name(), hash=hash.hexdigest())

    def __get_name(self):
        method_name = self.ast.func.attr if hasattr(self.ast.func, 'attr') else self.ast.func.id
        arg = self.ast.args[WAFFLE_NAMES_ARG_POS[method_name]]
        if isinstance(arg, ast.Str):
            return arg.s
        elif isinstance(arg, ast.Name):
            return arg.id
        elif isinstance(arg, ast.Attribute):
            return astor.to_source(arg, indent_with='').strip()

    @staticmethod
    def is_router(node):
        return \
            isinstance(node, ast.Call) and \
            (
                (
                    hasattr(node.func, 'attr') and \
                    node.func.attr in WAFFLE_ROUTERS
                ) or \
                (
                    hasattr(node.func, 'id') and \
                    node.func.id in WAFFLE_ROUTERS
                )
            )
