import sys
import ast
from lib2to3 import refactor
from lib2to3 import fixes
from lib2to3.pgen2.parse import ParseError

class SourceRefactoringToolg(refactor.RefactoringTool):
    def __init__(self, fixers, source):
        super(StdoutRefactoringTool, self).__init__(fixers)

    def log_error(self, msg, *args, **kwds):
        sys.stderr.write(msg)
        sys.stderr.flush()

def parse(source, filename):
    try:
        return ast.parse(source)
    except SyntaxError:
        # Maybe a Python2 syntax?
        py3_source = parse_from_py2(source, filename)
        return ast.parse(py3_source)

avail_fixes = set(refactor.get_fixers_from_package('lib2to3.fixes'))

def parse_from_py2(source, filename):
    refactor_tool = refactor.RefactoringTool(avail_fixes)
    concrete_st = refactor_tool.refactor_string(source, filename)
    # https://github.com/python/cpython/blob/e42b705188271da108de42b55d9344642170aa2b/Lib/lib2to3/refactor.py#L337
    return str(concrete_st)[:-1]
