import unittest
from point import Point
import re
import ast

class TestPoint(unittest.TestCase):

    def get_expression(self):
        return """
if foo and obj.flag_is_active(router, 'toggle-name') or bar:
    pass
"""

    def get_ast(self, expression):
        return ast.parse(expression).body[0]

    def assert_is_point(self, expression):
        self.assertTrue(Point.is_point(self.get_ast(expression)))

    def test_id(self):
        expression = self.get_expression()
        point = Point('foo.py', None, None, self.get_ast(expression))
        self.assertTrue(re.search(r'^[a-z0-9]{64}$', point.id), msg='{0} does not have the correct format id'.format(point.id))

    def test_same_common_id_when_different_files(self):
        point_one = Point('foo.py', None, None, self.get_ast(self.get_expression()))
        point_two = Point('bar.py', None, None, self.get_ast(self.get_expression()))
        self.assertEqual(point_one.common_id, point_two.common_id)

    def test_same_common_id_when_same_file(self):
        point_one = Point('foo.py', None, None, self.get_ast(self.get_expression()))
        point_two = Point('foo.py', None, None, self.get_ast(self.get_expression()))
        self.assertEqual(point_one.common_id, point_two.common_id)

    def test_is_point_when_lonely_test(self):
        expression = """
if obj.flag_is_active(router, 'toggle-name'):
    pass
"""
        self.assert_is_point(expression)

    def test_is_point_when_logical_operation(self):
        expression = self.get_expression()
        self.assert_is_point(expression)

    def test_is_point_when_unary_operation(self):
        expression = """
if not obj.flag_is_active(router, 'toggle-name'):
    pass
"""
        self.assert_is_point(expression)

if __name__ == '__main__':
    unittest.main()