import hashlib
import ast
import astor
import copy
import toggle_area
from router import Router

ENCODING = 'utf-8'

class Point(toggle_area.ToggleArea):
    def __init__(self, file, start, end, ast):
        super(Point, self).__init__(file, start, end, ast)

    def id(self):
        hash = hashlib.sha256()
        hash.update(bytes(self.file, ENCODING))
        hash.update(bytes(Point.ast_as_string(self.ast), ENCODING))
        return hash.hexdigest()

    def common_id(self):
        ifStmt = copy.copy(self.ast)
        
        # Can't delete these attributes, so lets reset
        ifStmt.body = []
        ifStmt.orelse = []

        hash = hashlib.sha256()
        hash.update(bytes(astor.to_source(ifStmt, add_line_information=False), ENCODING))
        return hash.hexdigest()

    @staticmethod
    def is_point(node):
        if not isinstance(node, ast.If):
            return False

        return Point.check_ifstmt_has_router(node.test)

    @staticmethod
    def check_ifstmt_has_router(node):
        if isinstance(node, ast.BoolOp):
            return (
                Point.check_ifstmt_has_router(node.values[0]) or
                Point.check_ifstmt_has_router(node.values[1])
            )
        elif isinstance(node, ast.UnaryOp):
            return Point.check_ifstmt_has_router(node.operand)
        else:
            return Router.is_router(node)
