import json
import toggle_areas_collector as tac
import os
import sys
import py_parser

def parse(filename, cwd):
    with open(os.path.join(cwd, filename), 'r') as file:
        try:
            # Remove null bytes so ast.parse does not complain
            node = py_parser.parse(cleanup(file.read()), filename)
        except UnicodeDecodeError as error:
            # Files not encoded in utf-8 (Python 3's default)
            return as_error('WARN (UnicodeDecodeError): {0}'.format(error), filename)
        except SyntaxError as error:
            return as_error('WARN (SyntaxError): {0}'.format(error.msg), filename)
        except TabError as error:
            return as_error('WARN (TabError): {0}'.format(error.msg), filename)
        except:
            e = sys.exc_info()[0]
            return as_error('WARN (UndefinedError): {0}'.format(e), filename)

        collector = tac.ToggleAreasCollector(filename)
        collector.visit(node)
        return as_toggles(collector.toggles)

def cleanup(source):
    # Avoid null bytes and make the parsers happy
    return source.strip('\x00')

def as_error(msg, filename):
    return json.dumps([
        {
            '__error__': {
                'msg': msg,
                'filepath': filename,
            }
        }
    ])

def as_toggles(toggles):
    return json.dumps(toggles, default=lambda o: o.__dict__)