import argparse
import sys
from file_parser import parse
from ipc_parser import ipc_parse

if __name__ == '__main__':
    parser = argparse.ArgumentParser('Extract the toggles of a Python file in a specified directory')
    parser.add_argument('--directory')
    parser.add_argument('--filepath')

    subparsers = parser.add_subparsers(title='subcommands', dest='ipc')
    ipc_parser = subparsers.add_parser('ipc', help='Extracts toggles through an IPC channel with another process via stdio')

    args = parser.parse_args()
    if args.directory:
        sys.stdout.write(parse(args.filepath, args.directory))
        sys.stdout.flush()
    elif args.ipc:
        ipc_parse()
