const parseProject = require('./project-parser');
const parseProjectHistory = require('./history-parser');
const parserFactory = require('./lib/parser-factory');

async function parser(filepath, { cwd, history, library, breakOnFirst }) {
  const parser = await parserFactory.build(library);

  let toggles;
  if (!history) {
    toggles = await parseProject(filepath, { cwd, parser, breakOnFirst });
  } else {
    toggles = await parseProjectHistory(filepath, { cwd, parser, breakOnFirst });
  }

  parser.end();
  return toggles;
}

module.exports = parser;
