#!/usr/bin/env node

const program = require('commander');
const parse = require('./parser');
const libraries = require('./lib/libraries');

program
  .description('Extract the toggles of a project')
  .arguments('<directory> <filepath> <library>')
  .option('--history', 'Extract across all commits of the project')
  .option('--break', 'Stop at first sign of toggles. Useful for exploratory runs')
  .action((directory, filepath, library) => {
    parse(filepath, { cwd: directory, history: program.history, library, breakOnFirst: program.break })
      .then(toggles => process.stdout.write(JSON.stringify(toggles)))
      .catch((error) => {
        console.error(error);
        if (error.name === 'GitCheckoutError') {
          process.exit(110);
        }

        // TODO: would not need to force the exit, something after adding --break support
        // with --history is staying alive.
        process.exit(1);
      });
  });

program
  .command('libraries')
  .description('List all supported toggling libraries')
  .action(() => {
    console.log(Object.keys(libraries).map(lib => `${lib} (${libraries[lib].language})`).join('\n'));
  });

program.parse(process.argv);
