import logging
import config
import psycopg2
import csv

def fetch_rows(cursor, sql_select):
    cursor.execute(sql_select)
    rows = cursor.fetchall()
    return rows

class State():
    cursor = None
    conn = None

    def __init__(self, csv_filename ):
        self.csv_filename = csv_filename
        self.init()
        self.projects = {}

    def init(self):
        # Singleton the cursor to the db
        if not State.cursor:
            logging.debug('Connecting to database...')
            self.conn = psycopg2.connect("host= '{host}' dbname= '{dbname}' user='{username}' port={port}".format_map(config.recepits_db))
            logging.info('Connected to database')

            State.cursor = self.conn.cursor()

        self.cursor = State.cursor

    def add(self, project):
        self.projects[project['repo_name']] = project

        try:
            self.cursor.execute(
                'INSERT INTO projects (repo_name, library, library_language, number_of_commits) VALUES (%s, %s, %s, %s)',
                [
                    project['repo_name'],
                    project['library'],
                    project['library_language'],
                    project['number_of_commits'],
                ]
            )
        except psycopg2.IntegrityError:
            self.conn.rollback()
        else:
            self.conn.commit()

    def load_projects(self):
        # Store the projects from the csv into the state
        with open(self.csv_filename, 'r') as file:
            reader = csv.DictReader(file)
            for project in reader:
                self.add(project)

        # Load the projects pending to be processed
        projects = fetch_rows(self.cursor, "SELECT repo_name FROM projects WHERE library = 'Waffle' AND processed = false AND has_toggles = true ORDER BY number_of_commits ASC;")
        for project in projects:
            yield self.projects[project[0]]

    def done(self, project, has_toggles = False):
        self.cursor.execute("UPDATE projects set processed = true, has_toggles = {0} where repo_name = '{1}';".format(has_toggles, project['repo_name']))
        self.conn.commit()