import logging
import subprocess
import os

class Extractor():
    def __init__(self, project, cleanup=True, dirseparator=''):
        self.project = project
        self.cleanup = cleanup
        self.dirseparator = dirseparator

        basedir = os.getenv('REPOS_STORE', '~/tmp')
        self.directory = '"' + os.path.join(basedir, self.project['repo_name'].replace('/', dirseparator)) + '"'

    def run_cmd(self, args, env=None):
        return subprocess.check_output(' '.join(args), shell=True, env=env)

    def clone(self):
        repo_url = 'https://github.com/{0}.git'.format(self.project['repo_name'])

        if self.cleanup:
            self.run_cmd(['rm -rf', self.directory, '&&', 'git clone', repo_url, self.directory])
        else:
            try:
                self.run_cmd(['git clone', repo_url, self.directory])
            except subprocess.CalledProcessError as error:
                # When not a "fatal: destination path '--REPO--' already exists and is not an empty directory."
                if error.returncode != 128:
                    raise error

    def run(self):
        self.clone()
        repodir = os.path.join(self.directory, self.project['repo_name'])
        # TODO: decouple from django-waffle
        logging.debug('Extracting %s', self.project['repo_name'])
        try:
            return self.run_cmd(['extractor', self.directory, '"*.py"', '--history', 'django-waffle'])
        except subprocess.CalledProcessError as error:
            # Impossible to checkout. Skip
            # There seems to be a bug in git when you cannot move to another place because git checkout -- file
            # will allways show there are pending modifications. Looks related to autoctrl and lineendings.
            # https://stackoverflow.com/a/2016426/638425
            if error.returncode != 110:
                    raise error

            return b''

