import argparse
import os
import logging
from extractor import Extractor
from state import State

FORMAT = '%(asctime)-15s %(message)s'
logging.basicConfig(level=logging.DEBUG, format=FORMAT)
no_toggles_json = '{"Declaration":{},"Router":{},"Point":{}}'
no_toggles_skip = ''

OWNER_REPO_SEPARATOR = '__'

if __name__ == '__main__':
    # TODO: help='Environment variables are passed to extractor commands. Use REPOS_STORE'
    parser = argparse.ArgumentParser('Extract the toggles from a list of projects and save results into a specified directory')
    parser.add_argument('projects_csv', help='A csv containing the projects to extract the toggles from')
    parser.add_argument('output_dir', help='The output directory where resulting files will be placed')
    parser.add_argument('--cleanup', action='store_true', help='Ignore the cached repositories')

    args = parser.parse_args()
    csv_filename = args.projects_csv
    outdir = args.output_dir
    cleanup = args.cleanup

    state = State(csv_filename)
    projects = state.load_projects()
    for project in projects:
        repo_name = project['repo_name']
        extractor = Extractor(project, cleanup, dirseparator=OWNER_REPO_SEPARATOR)
        toggles = extractor.run()

        filename = repo_name.replace('/', OWNER_REPO_SEPARATOR) + '.json'
        with open(os.path.join(outdir, filename), 'wb') as file:
            file.write(toggles)

        decoded_toggles = toggles.decode('utf-8')
        has_toggles = decoded_toggles != no_toggles_skip and decoded_toggles != no_toggles_json
        state.done(project, has_toggles)
