#include "define.inc"
!>  This module is intended to be used for runtime tests
!!  which interrogate what is functional/what compile time
!!  options were enabled/disabled, and also any enviroment variables
!!  which affect what happens at runtime.
!!
module runtime_tests

  implicit none

  private

  public :: compiler_pgi, verbosity, build_identifier
  public :: get_git_hash, get_git_modified, get_compiler_name
  public :: is_release, release

  logical, save :: verbosity_initialized = .false.
  integer, save :: verbosity_saved

contains


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  Tests for compilers
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  function compiler_pgi()
    logical :: compiler_pgi
    compiler_pgi = .false.
#if FCOMPILER == _PGI_
    compiler_pgi = .true.
#endif
  end function compiler_pgi

  function get_compiler_name()
    character(len=9) :: get_compiler_name
    get_compiler_name='unknown'
#if FCOMPILER == _PGI_
    get_compiler_name='pgi'
#elif FCOMPILER == _INTEL_
    get_compiler_name='intel'
#elif FCOMPILER == _GFORTRAN_
    get_compiler_name='gfortran'
#elif FCOMPILER == _XL_
    get_compiler_name='xl'
#elif FCOMPILER == _NAG_
    get_compiler_name='nag'
#elif FCOMPILER == _CRAY_
    get_compiler_name='cray'
#elif FCOMPILER == _G95_
    get_compiler_name='g95'
#elif FCOMPILER == _PATHSCALE_
    get_compiler_name='pathscale'
#elif FCOMPILER == _LAHEY_
    get_compiler_name='lahey'
#elif FCOMPILER == _ABSOFT_
    get_compiler_name='absoft'
#elif FCOMPILER == _ALPHA_
    get_compiler_name='alpha'
#elif FCOMPILER == _SUN_
    get_compiler_name='sun'
#endif
  end function get_compiler_name

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  Tests for git info
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  !>This function returns the git hash
  function get_git_hash(length_in)
    integer, optional, intent(in) :: length_in
    integer :: length = 40
    character(len=40) :: get_git_hash

    if( present(length_in) ) then
      if( length_in <= 40 ) then
        length = length_in
      end if
    end if

#ifndef GIT_HASH
#define GIT_HASH "unknown"
    length=7
#endif
    get_git_hash=GIT_HASH(1:length)
  end function get_git_hash

  !>This function returns true if the source code has
  !been modified relative to repo
  function get_git_modified()
    logical :: get_git_modified
#ifndef GIT_HASH
#define GIT_HASH "unknown"
#endif
    if(GIT_STATE.eq."clean")then
       get_git_modified=.false.
    else
       get_git_modified=.true.
    endif
  end function get_git_modified
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! System info
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  function get_gk_system()
    character(len=20) :: get_gk_system
#ifndef GK_SYSTEM
#define GK_SYSTEM "unknown"
#endif
    get_gk_system=GK_SYSTEM
  end function get_gk_system

  !> This function returns an identifier of the system and build:
  !! "system.compiler.githash".
  function build_identifier()
    character(len=50) :: build_identifier
    character(len=7) :: git_hash

    git_hash = get_git_hash(7)
    build_identifier = trim(get_gk_system())//"."//trim(get_compiler_name())//'.'//git_hash

    if(get_git_modified()) then
      build_identifier = build_identifier//'.modified'
    end if

  end function build_identifier

  function is_release()
    logical :: is_release
#ifdef RELEASE
    is_release = .true.
#else
    is_release = .false.
#endif
  end function is_release

  function release()
    character(len=10) :: release
#ifdef RELEASE
    release = RELEASE
#else
    release = ''
#endif
  end function release

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! Testing the runtime environment
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


  !> This function interrogates the environment variable
  !! GK_VERBOSITY and returns its integer value. This is used
  !! to control the level of debug output (not diagnostic/physics output).
  !! Normal levels range from 0 to 5, with output getting 
  !! heavier as the value increases. Values higher than 5 can be used for 
  !! specialised/very heavy output.
  function verbosity()
    integer :: verbosity
    character(len=10) :: verbosity_char

    if( .not. verbosity_initialized ) then
      verbosity_char = ''
      call get_environment_variable("GK_VERBOSITY", verbosity_char)
      read (verbosity_char,'(I10)') verbosity_saved
      verbosity_initialized = .true.
    end if
    verbosity = verbosity_saved

  end function verbosity
end module runtime_tests
