!> This module provides 10,000 fixed random numbers
!! used for initialising tests, so as always to give
!! the same result when starting from noise, regardless
!! of compiler/system. These should not be used for
!! production runs. 
module constant_random
  public :: init_constant_random
  public :: finish_constant_random
  public :: ranf
  private
  real, dimension(:), allocatable :: random_array
  integer :: counter
  contains
    function ranf()
      real :: ranf
      ranf = random_array(mod(counter,10000)+1)
      counter = counter + 1
    end function ranf
    subroutine init_constant_random
      allocate(random_array(10000))
      call set_random_array
      counter = 0
    end subroutine init_constant_random
    subroutine finish_constant_random
      deallocate(random_array)
    end subroutine finish_constant_random
    subroutine set_random_array
      ! numbers taken from random.org
      random_array(1:5000) = (/ 0.6475790490,  0.9498492965, &
0.1040643785,  0.1610729052,  &
0.3541695530,  0.3521916087,  &
0.5423830564,  0.5095201779,  &
0.4395777043,  0.1622603478,  &
0.2878692921,  0.0266536306,  &
0.1429550354,  0.8205499303,  &
0.5647197920,  0.3790503775,  &
0.1261086562,  0.5138770991,  &
0.6710296140,  0.6838839326,  &
0.2004929463,  0.7406352869,  &
0.8895214972,  0.1141370812,  &
0.6701423959,  0.8961483521,  &
0.4342476366,  0.6439434657,  &
0.8716331345,  0.1527541394,  &
0.0912984305,  0.5523289376,  &
0.1827942180,  0.3241552880,  &
0.6863152332,  0.3567736094,  &
0.4654198609,  0.1281173470,  &
0.0559217877,  0.8118306991,  &
0.9814343410,  0.5111042991,  &
0.2665301447,  0.5008356507,  &
0.6842084095,  0.3006182694,  &
0.9638296334,  0.1122492032,  &
0.0317973905,  0.9857487990,  &
0.7398573574,  0.6153318400,  &
0.8311592940,  0.0897687245,  &
0.6165050991,  0.1786380951,  &
0.9652666848,  0.7427734400,  &
0.6180888055,  0.3314906372,  &
0.1274273936,  0.1012130797,  &
0.1853725779,  0.6556806478,  &
0.8860271478,  0.3391802477,  &
0.1980178296,  0.8053925326,  &
0.1616074146,  0.3153087629,  &
0.2234175063,  0.7745763456,  &
0.6874799537,  0.8060900507,  &
0.9632701429,  0.9258418256,  &
0.5227596133,  0.4895227638,  &
0.8840716717,  0.2908226035,  &
0.3639533285,  0.7978854362,  &
0.4900587914,  0.6538123755,  &
0.7588358461,  0.1989083582,  &
0.7922246017,  0.3011118276,  &
0.9253000774,  0.2990251337,  &
0.5782173642,  0.6730943981,  &
0.4016409767,  0.5377021681,  &
0.2203431138,  0.7294827854,  &
0.2634081913,  0.6830533289,  &
0.1507662200,  0.3932377980,  &
0.3035876054,  0.5161995858,  &
0.7766872747,  0.8472263753,  &
0.7457059674,  0.6250778233,  &
0.2406039455,  0.3021516307,  &
0.0640950293,  0.1257853255,  &
0.6886844694,  0.2342878191,  &
0.4070715601,  0.5739324418,  &
0.2813128704,  0.5252564272,  &
0.5756639413,  0.6473225536,  &
0.9230967091,  0.1142863357,  &
0.3645991772,  0.7832587786,  &
0.0616769625,  0.5381163725,  &
0.4333205869,  0.3514053046,  &
0.1945629011,  0.4291065544,  &
0.7345766614,  0.2450825086,  &
0.0514360536,  0.2811080115,  &
0.7889450436,  0.2603297762,  &
0.9531105379,  0.4507365039,  &
0.4548676890,  0.6095045082,  &
0.8793840416,  0.5271190667,  &
0.2619988857,  0.3735548838,  &
0.7910981937,  0.3762364837,  &
0.5128313909,  0.2761697413,  &
0.6418296579,  0.5707688329,  &
0.0181916916,  0.0175540909,  &
0.3082589027,  0.1875135287,  &
0.7963069515,  0.8353496148,  &
0.3220305389,  0.6426212817,  &
0.5226318209,  0.8856623502,  &
0.5808788396,  0.0290671884,  &
0.2800005947,  0.1311490857,  &
0.6868424151,  0.3830744765,  &
0.6812332739,  0.5364997682,  &
0.7383085007,  0.7852052813,  &
0.3378383095,  0.4460043372,  &
0.9473528833,  0.3437589055,  &
0.6236060754,  0.4438664645,  &
0.7091243247,  0.7200699587,  &
0.4338121954,  0.2146871525,  &
0.1481794181,  0.1188114112,  &
0.3711737222,  0.5132845635,  &
0.9977962050,  0.4747212416,  &
0.5987333885,  0.7165968083,  &
0.4301771768,  0.0821919088,  &
0.3634573924,  0.5233086188,  &
0.4305786506,  0.6647766731,  &
0.6359877938,  0.9371499284,  &
0.5068721479,  0.8020724201,  &
0.0438351075,  0.0719039840,  &
0.5659108236,  0.0677717256,  &
0.9499409701,  0.6468610499,  &
0.3885238334,  0.6808520173,  &
0.7596664408,  0.1334318024,  &
0.4190055963,  0.9925493974,  &
0.7049642694,  0.3682003501,  &
0.4770560001,  0.9669523313,  &
0.7051730653,  0.7134967276,  &
0.5372092688,  0.7536332417,  &
0.4508564571,  0.5053977231,  &
0.6839077552,  0.6140763472,  &
0.9807120151,  0.2560226524,  &
0.6940482298,  0.9676180723,  &
0.0510261380,  0.0945721650,  &
0.6530659437,  0.2814350220,  &
0.0981958400,  0.1573881267,  &
0.8006935460,  0.3697993951,  &
0.8875792755,  0.0251275318,  &
0.9880248447,  0.3606268897,  &
0.6238417195,  0.4054132163,  &
0.0617409851,  0.1944081146,  &
0.6403074173,  0.7188058449,  &
0.3437062101,  0.7655935928,  &
0.3224509984,  0.7197655681,  &
0.8803959865,  0.5079486874,  &
0.5723162981,  0.0218574781,  &
0.0352832518,  0.5436696415,  &
0.9656667186,  0.0790515120,  &
0.2955191462,  0.1412112941,  &
0.3002538688,  0.1333494086,  &
0.3333695943,  0.7551332450,  &
0.1576307550,  0.4169120878,  &
0.1386985919,  0.1913192251,  &
0.6878942293,  0.6056801366,  &
0.5756262476,  0.6279610085,  &
0.6591186447,  0.1065293496,  &
0.8502629488,  0.1420818118,  &
0.3212630844,  0.9929444680,  &
0.3688443778,  0.6896108198,  &
0.8186136656,  0.5586060520,  &
0.1632004033,  0.5956496202,  &
0.9727597630,  0.7335287914,  &
0.9141771332,  0.9898929159,  &
0.0766607525,  0.6284058507,  &
0.1567494708,  0.9142190530,  &
0.6708301773,  0.6418147044,  &
0.5090280078,  0.1552405395,  &
0.4936804148,  0.6571952342,  &
0.9247028822,  0.6716417436,  &
0.7931742273,  0.3607900647,  &
0.0588656030,  0.1838927133,  &
0.2281256875,  0.8948639950,  &
0.0450050937,  0.8003852715,  &
0.6357775557,  0.6680956365,  &
0.9390468262,  0.1313005556,  &
0.1772633175,  0.0342236662,  &
0.0143358921,  0.1564197909,  &
0.7876858673,  0.7831110293,  &
0.4885341146,  0.3399099302,  &
0.1268402471,  0.0186406667,  &
0.4364695341,  0.5212834902,  &
0.9788549568,  0.6328800287,  &
0.4016548555,  0.2110994174,  &
0.2795084120,  0.0241611023,  &
0.9158761203,  0.3229395396,  &
0.9796721530,  0.4839929960,  &
0.8556214415,  0.7949998819,  &
0.0141687800,  0.0185986783,  &
0.5912089125,  0.4266111905,  &
0.4563469507,  0.5061532910,  &
0.7663325403,  0.0683413329,  &
0.1398556589,  0.5884829841,  &
0.7495489457,  0.8411386109,  &
0.7236798370,  0.0243140275,  &
0.4173664982,  0.1519709529,  &
0.1842024175,  0.9155725403,  &
0.8384056467,  0.4499661662,  &
0.8625647597,  0.9125806200,  &
0.4439262565,  0.8474362833,  &
0.9626859257,  0.5765501296,  &
0.3293858135,  0.9894055253,  &
0.1461324009,  0.0323433887,  &
0.1641154387,  0.2834018848,  &
0.4118270854,  0.1002336728,  &
0.2446612140,  0.6986170388,  &
0.0373773771,  0.3135123107,  &
0.4558537883,  0.0758623426,  &
0.0476811336,  0.4514839483,  &
0.0358105080,  0.9083111719,  &
0.6752956594,  0.7753936544,  &
0.5177091320,  0.9415145653,  &
0.2175396726,  0.8111996880,  &
0.2704937718,  0.9854957315,  &
0.8284286159,  0.7997532451,  &
0.8201054329,  0.1015326611,  &
0.5060894757,  0.3916157987,  &
0.4515361617,  0.8897622856,  &
0.2301763438,  0.4833599910,  &
0.2032638051,  0.9408772513,  &
0.4115017901,  0.2949125910,  &
0.9887162612,  0.4481218959,  &
0.9754388240,  0.7182749981,  &
0.3815523514,  0.4654749812,  &
0.1786044394,  0.4744762594,  &
0.3965219271,  0.6714237429,  &
0.3422086542,  0.0267145015,  &
0.9012144807,  0.8893630368,  &
0.3950451912,  0.1662344881,  &
0.0167594570,  0.2725117396,  &
0.9002386734,  0.0696921944,  &
0.0688751512,  0.0957295121,  &
0.8621232247,  0.3182527801,  &
0.8818425675,  0.2197261956,  &
0.4911674557,  0.3123705599,  &
0.5140477895,  0.0000007077,  &
0.7296329801,  0.5933598844,  &
0.3638942354,  0.6891018843,  &
0.4053730778,  0.1250399334,  &
0.9667626946,  0.2145160594,  &
0.1188887473,  0.8896319295,  &
0.0178415543,  0.7057716265,  &
0.7424770274,  0.1499161334,  &
0.9610000552,  0.0242300404,  &
0.0814754686,  0.9867010922,  &
0.1199584510,  0.9978881064,  &
0.4547619167,  0.9361351362,  &
0.8210392473,  0.7391981196,  &
0.2488640248,  0.2904562546,  &
0.4598955368,  0.4183462793,  &
0.7777268047,  0.3007938944,  &
0.0635249899,  0.6803726120,  &
0.0033753712,  0.9130316894,  &
0.8390764729,  0.5174558923,  &
0.3212267031,  0.2349386746,  &
0.8649636600,  0.3618125638,  &
0.7821675380,  0.2652563715,  &
0.7056090795,  0.3515143769,  &
0.1946947122,  0.3779278934,  &
0.9607082615,  0.0966297902,  &
0.6767713364,  0.1705966730,  &
0.3924556493,  0.2536063093,  &
0.2214824715,  0.0793006899,  &
0.2091277230,  0.0200343786,  &
0.2002649718,  0.3818192057,  &
0.3660762819,  0.2616132660,  &
0.7367000069,  0.2635270671,  &
0.9081017010,  0.1167954887,  &
0.2158756639,  0.2674537697,  &
0.4366513410,  0.7901824220,  &
0.0965085841,  0.8629947417,  &
0.9039372186,  0.1684101702,  &
0.7845380967,  0.5111292281,  &
0.2844686796,  0.7928557254,  &
0.4014043613,  0.5616750358,  &
0.1731555151,  0.9490700134,  &
0.6819303931,  0.7768212020,  &
0.9699823325,  0.0767631593,  &
0.3134591427,  0.0052440629,  &
0.6148138092,  0.2416406337,  &
0.0129076170,  0.7382779735,  &
0.5263797465,  0.1400662738,  &
0.2646083165,  0.5773564761,  &
0.3230938666,  0.7551198417,  &
0.6504480541,  0.3394219915,  &
0.6703694762,  0.1511437705,  &
0.3007128836,  0.5677984961,  &
0.4625779033,  0.1805474399,  &
0.0526362275,  0.3435656988,  &
0.8864999401,  0.4514230592,  &
0.4026193189,  0.5348852846,  &
0.8315167947,  0.1895745174,  &
0.8763951024,  0.7646016324,  &
0.7334040786,  0.2823302658,  &
0.9072650364,  0.7175561381,  &
0.0114786863,  0.3775405185,  &
0.4112435110,  0.4894439983,  &
0.0242875585,  0.8228138668,  &
0.0119658285,  0.8664453078,  &
0.7979505514,  0.4300974978,  &
0.0631856741,  0.3974431162,  &
0.6060874282,  0.9199005664,  &
0.5891902523,  0.9463926070,  &
0.0886134771,  0.1056991569,  &
0.2743151876,  0.8769553602,  &
0.5230132149,  0.3232784937,  &
0.5025158316,  0.0210419609,  &
0.3309184866,  0.7452576613,  &
0.0223106307,  0.6002036971,  &
0.4932082032,  0.5774359310,  &
0.5220422880,  0.9289278517,  &
0.6181983508,  0.1320459239,  &
0.4246066871,  0.1951612106,  &
0.2384118788,  0.2530249583,  &
0.4788503108,  0.8897703301,  &
0.8514649777,  0.6254425949,  &
0.5429568435,  0.1217836004,  &
0.2712802101,  0.6998576235,  &
0.9983390425,  0.8407292316,  &
0.6806532660,  0.2790883742,  &
0.7350662192,  0.0551908965,  &
0.7457049865,  0.4007359169,  &
0.1914901400,  0.5794339252,  &
0.7131952876,  0.0425710494,  &
0.8951304076,  0.4198841186,  &
0.4315976752,  0.6585019674,  &
0.7042086815,  0.4359902208,  &
0.8502196683,  0.0626444758,  &
0.8656458507,  0.6520385955,  &
0.7886951507,  0.5939430154,  &
0.3748166310,  0.1249595530,  &
0.0902000170,  0.6730304097,  &
0.8585595289,  0.7172764290,  &
0.8348752724,  0.1295627734,  &
0.8228782460,  0.0329036982,  &
0.0902457143,  0.8641297187,  &
0.2234352983,  0.6808493367,  &
0.4766286717,  0.4213662498,  &
0.6579483991,  0.2584102218,  &
0.6417065245,  0.2124925317,  &
0.4137357940,  0.5206556799,  &
0.5497526586,  0.1478898669,  &
0.7400009911,  0.0017683814,  &
0.5471946148,  0.4996159182,  &
0.2975432682,  0.4767283285,  &
0.5436274174,  0.4721800610,  &
0.7107268642,  0.3450786161,  &
0.5083241419,  0.1531422027,  &
0.0665859365,  0.1197032191,  &
0.8355037332,  0.5193419488,  &
0.8656107922,  0.1377655685,  &
0.3128710784,  0.6617365056,  &
0.3388465431,  0.1012225733,  &
0.7183019256,  0.5078454124,  &
0.4738333510,  0.5715683429,  &
0.0170936910,  0.1988115924,  &
0.3226034546,  0.4484465470,  &
0.6003324908,  0.9335909481,  &
0.1762765545,  0.8878283445,  &
0.4623920963,  0.4301578436,  &
0.9890849457,  0.5649094183,  &
0.3501080897,  0.5704501890,  &
0.3863507847,  0.0525297309,  &
0.8006837939,  0.3318523010,  &
0.8057074461,  0.8993241475,  &
0.8798390259,  0.6205848911,  &
0.2391756939,  0.6122960613,  &
0.4708160416,  0.3788427780,  &
0.1806931194,  0.2068883565,  &
0.5120439040,  0.4729291986,  &
0.9130350150,  0.8496030415,  &
0.2835222266,  0.4457294644,  &
0.8371420871,  0.1194112704,  &
0.4566265172,  0.7772308921,  &
0.1184743487,  0.2324305384,  &
0.9182792698,  0.1896583399,  &
0.0657457403,  0.6069679550,  &
0.5381871937,  0.7581708658,  &
0.5308454255,  0.6369356090,  &
0.3481968793,  0.6720977648,  &
0.8393648286,  0.2241936829,  &
0.5378279714,  0.7190957982,  &
0.3738122436,  0.0311278894,  &
0.4931698582,  0.3153146706,  &
0.9975345843,  0.6252362542,  &
0.8842870512,  0.1549626125,  &
0.9442453311,  0.9511656863,  &
0.8499957276,  0.5653674630,  &
0.3547476964,  0.5376266137,  &
0.5083005814,  0.0926648209,  &
0.7423299129,  0.9538326736,  &
0.8507656082,  0.3380973752,  &
0.6883104028,  0.1866095667,  &
0.2345661451,  0.6935978316,  &
0.6936903488,  0.2278549164,  &
0.1268668242,  0.9896148189,  &
0.1059719200,  0.7441748776,  &
0.5610856925,  0.6515746621,  &
0.0979151136,  0.6139142839,  &
0.0718477694,  0.6539960110,  &
0.2413301059,  0.6888510864,  &
0.4631250558,  0.2952186305,  &
0.2138084925,  0.6086387454,  &
0.2214129300,  0.0282561138,  &
0.8617781225,  0.9883771821,  &
0.3839814812,  0.9463619739,  &
0.4670381298,  0.7942160716,  &
0.9494199448,  0.7990765145,  &
0.0084502657,  0.1144511546,  &
0.2373065909,  0.9529418631,  &
0.3625649841,  0.0070206089,  &
0.6103212402,  0.4906078397,  &
0.9902352315,  0.5917971453,  &
0.0265558104,  0.0793306404,  &
0.3531563554,  0.0921532844,  &
0.5945881154,  0.2916468793,  &
0.3353454000,  0.9574353037,  &
0.6403007065,  0.2368087307,  &
0.7121389171,  0.6316373224,  &
0.9378827162,  0.4760504870,  &
0.6382341034,  0.2480726657,  &
0.9210316890,  0.4116328801,  &
0.2415285747,  0.5349300897,  &
0.9844078232,  0.0798339148,  &
0.3807241059,  0.5006085143,  &
0.3616771359,  0.4253854516,  &
0.4755893843,  0.0750768379,  &
0.4187864048,  0.7053591878,  &
0.5498145425,  0.8784284031,  &
0.7086165216,  0.6183301284,  &
0.3903585648,  0.4027763208,  &
0.6064805614,  0.9158982202,  &
0.9897666445,  0.9647249267,  &
0.2953633673,  0.7716977213,  &
0.2114155210,  0.3142245563,  &
0.7359432801,  0.9535298885,  &
0.9608219612,  0.2809302896,  &
0.5305255504,  0.4326639711,  &
0.8029019119,  0.8442764952,  &
0.4441211161,  0.4514512475,  &
0.9461865237,  0.2840123151,  &
0.8797651392,  0.3845094417,  &
0.2403025689,  0.8021800290,  &
0.5687784034,  0.2314068532,  &
0.0618685736,  0.6834679639,  &
0.7729538571,  0.4482913914,  &
0.7889759330,  0.8130667037,  &
0.5580270701,  0.3456788412,  &
0.2216633043,  0.1331286628,  &
0.5250400659,  0.3903535478,  &
0.2284346652,  0.6392794161,  &
0.0922176808,  0.0122056073,  &
0.8435559471,  0.3706760278,  &
0.1698678937,  0.0050884836,  &
0.0885487159,  0.4569444597,  &
0.3402770384,  0.5932443639,  &
0.3283788457,  0.4957770071,  &
0.5232399977,  0.6655203806,  &
0.0681299829,  0.8443727403,  &
0.1245374662,  0.6754199041,  &
0.8895956833,  0.1274969992,  &
0.5510488588,  0.6657730421,  &
0.6148053250,  0.4891716695,  &
0.3003545706,  0.3949600170,  &
0.5686456443,  0.1031365059,  &
0.6103965950,  0.2092000331,  &
0.8475491860,  0.7871973924,  &
0.6265505526,  0.9365758555,  &
0.5822322859,  0.3132011336,  &
0.0771532095,  0.9114414462,  &
0.0266018904,  0.1563618935,  &
0.4099791452,  0.3516616128,  &
0.0403185745,  0.4969425726,  &
0.8133126284,  0.4205885811,  &
0.9876968420,  0.4080468717,  &
0.2383837198,  0.4369079159,  &
0.8936106475,  0.2539090258,  &
0.5722105327,  0.2211775940,  &
0.8712748241,  0.6083982984,  &
0.2991345315,  0.2320893910,  &
0.9825942281,  0.6629749990,  &
0.5103190689,  0.9710690841,  &
0.1822491146,  0.2345566821,  &
0.0579004758,  0.8227326590,  &
0.5798235562,  0.7667933805,  &
0.5421505649,  0.6160447683,  &
0.4995464996,  0.6228309284,  &
0.4571039063,  0.4727785247,  &
0.1053248309,  0.1281876027,  &
0.6848411147,  0.6554366966,  &
0.2047553832,  0.3769814030,  &
0.4276297397,  0.6126015640,  &
0.5843828759,  0.3053072701,  &
0.6470858201,  0.8002558723,  &
0.4480976810,  0.2759898679,  &
0.0107365027,  0.7368605700,  &
0.6875762463,  0.4345280340,  &
0.9091955816,  0.0135016693,  &
0.6027142774,  0.4582988635,  &
0.7716998936,  0.5485908942,  &
0.8290524276,  0.8196838123,  &
0.6739384703,  0.3365202411,  &
0.4154143059,  0.2116966572,  &
0.6750312233,  0.6178882781,  &
0.1108168096,  0.3746453830,  &
0.4439062386,  0.8719802714,  &
0.7738516687,  0.8616244615,  &
0.0371993848,  0.4398585578,  &
0.5867202564,  0.4324557330,  &
0.1572026348,  0.6696998050,  &
0.2451708557,  0.7534283174,  &
0.4422677862,  0.4055934646,  &
0.1230868319,  0.4602943226,  &
0.8869185439,  0.2036563610,  &
0.5287848232,  0.8793266795,  &
0.7321397316,  0.3438609449,  &
0.1256806393,  0.0683413887,  &
0.6842109331,  0.8342757745,  &
0.3282082001,  0.2438828481,  &
0.8758553782,  0.7515893703,  &
0.4438258387,  0.4452430587,  &
0.2673641469,  0.1031254314,  &
0.2234951130,  0.1433672971,  &
0.1660626181,  0.6818553473,  &
0.2556636094,  0.3992326219,  &
0.5539243482,  0.4433410257,  &
0.1214535926,  0.0943724697,  &
0.2506071495,  0.3330341885,  &
0.5334314903,  0.8266788956,  &
0.4363227538,  0.7928138107,  &
0.3168902075,  0.2951149592,  &
0.5716478138,  0.3737921363,  &
0.6261807685,  0.8339187287,  &
0.5107895093,  0.7967620375,  &
0.1710095508,  0.1245200742,  &
0.0662929149,  0.7133265370,  &
0.7842908802,  0.7603946781,  &
0.3633990844,  0.2290225478,  &
0.4637060842,  0.1852864824,  &
0.8674611478,  0.4171797622,  &
0.9807713416,  0.6890764644,  &
0.0626594472,  0.7731346654,  &
0.0150975712,  0.7614268997,  &
0.5572408088,  0.7046376895,  &
0.8330658945,  0.7148408582,  &
0.4973033639,  0.4174259695,  &
0.2346856060,  0.8565916408,  &
0.5319377585,  0.1328479429,  &
0.8280544107,  0.5029388078,  &
0.2895223907,  0.0527912029,  &
0.7218248854,  0.9577979165,  &
0.1841842868,  0.4484566039,  &
0.5317876311,  0.8702534540,  &
0.0608034038,  0.2308548253,  &
0.5659195179,  0.5431267561,  &
0.4471032204,  0.8456074758,  &
0.2899251847,  0.2555921586,  &
0.2821813896,  0.8796934073,  &
0.8664010462,  0.1795329012,  &
0.9902155058,  0.7822438568,  &
0.6084516920,  0.1997188369,  &
0.2568604750,  0.2899400717,  &
0.2191576172,  0.5003066449,  &
0.2623919234,  0.5454867710,  &
0.5047899397,  0.1505689950,  &
0.2846083363,  0.6859182310,  &
0.7955168088,  0.1101078577,  &
0.0324084933,  0.7905129460,  &
0.0268025102,  0.2276910742,  &
0.3872159129,  0.5915385593,  &
0.6529369071,  0.1935529256,  &
0.2086009787,  0.8245211832,  &
0.8259976840,  0.6896187922,  &
0.3469789482,  0.4896071840,  &
0.0322685739,  0.7660792958,  &
0.2865551920,  0.8048279364,  &
0.4321267548,  0.9407857788,  &
0.3250163411,  0.9647703039,  &
0.6610265438,  0.6901101183,  &
0.3831234004,  0.7763260906,  &
0.7858971214,  0.0689311175,  &
0.5791736247,  0.9882189310,  &
0.8892918225,  0.7051861188,  &
0.0804112232,  0.9291643863,  &
0.2077188274,  0.1881456372,  &
0.1474309607,  0.2031641906,  &
0.5115520642,  0.9904140868,  &
0.9831770071,  0.0115289220,  &
0.0014188401,  0.6838180135,  &
0.5217796457,  0.3785445094,  &
0.5913877179,  0.8980793455,  &
0.3734545128,  0.4001341349,  &
0.3814386648,  0.4713035943,  &
0.3223670533,  0.5217188651,  &
0.9774925981,  0.0037755329,  &
0.5852276701,  0.6701617730,  &
0.5310872817,  0.4525668767,  &
0.3783719225,  0.8062415135,  &
0.0267270001,  0.7816264361,  &
0.2574474798,  0.9424838466,  &
0.6201241184,  0.7354241219,  &
0.3837640753,  0.7623627360,  &
0.1578813364,  0.2885830666,  &
0.9327959433,  0.1483652008,  &
0.6910621652,  0.4458271217,  &
0.3086283527,  0.4133078110,  &
0.0653303596,  0.3768679147,  &
0.5750918573,  0.6869627485,  &
0.3494667743,  0.1967205919,  &
0.6544098672,  0.9418888658,  &
0.8915495984,  0.8342687763,  &
0.9955038851,  0.9065377683,  &
0.8062990526,  0.3565717376,  &
0.0257889228,  0.8927284642,  &
0.3588552806,  0.1617567450,  &
0.7182757959,  0.9964789479,  &
0.9338886078,  0.4881512704,  &
0.3167755219,  0.0756326266,  &
0.4108614644,  0.0730633435,  &
0.5505628491,  0.7959671959,  &
0.4844601081,  0.8848528618,  &
0.4854442907,  0.3858214397,  &
0.9262974540,  0.9818389792,  &
0.4602183255,  0.5236619278,  &
0.1281388445,  0.2497302059,  &
0.0118024724,  0.9103100022,  &
0.8532012134,  0.9695040870,  &
0.9896848772,  0.0425067590,  &
0.9936630172,  0.6976727040,  &
0.7906292577,  0.0464851249,  &
0.5161263471,  0.9686983386,  &
0.4401053305,  0.7250816260,  &
0.0069086662,  0.6142555117,  &
0.0230357974,  0.6271980478,  &
0.6256349534,  0.6017230074,  &
0.5522300793,  0.5172459905,  &
0.7134521097,  0.4719251983,  &
0.2494377823,  0.6271870451,  &
0.2368126897,  0.5180387944,  &
0.6196486286,  0.0547294705,  &
0.8863185972,  0.1668099680,  &
0.2002370183,  0.2684491962,  &
0.1758778718,  0.2696298923,  &
0.8255121023,  0.7520006980,  &
0.0340099068,  0.3003331742,  &
0.3930423665,  0.7164854728,  &
0.0718766794,  0.9064310779,  &
0.0001290750,  0.0744378894,  &
0.8481717437,  0.7561792587,  &
0.6952482358,  0.7679533974,  &
0.4786546113,  0.8459230212,  &
0.7828569210,  0.9848703338,  &
0.1798282914,  0.0078424184,  &
0.4818052025,  0.6697756803,  &
0.6671050128,  0.8249774447,  &
0.5543451717,  0.9589498108,  &
0.9771704085,  0.3244788031,  &
0.3333614673,  0.2419518376,  &
0.7901472932,  0.8241995070,  &
0.9594796289,  0.4194170523,  &
0.4879095509,  0.0310433000,  &
0.8781345333,  0.8389449497,  &
0.0206424557,  0.7923946798,  &
0.4634921017,  0.9567617672,  &
0.3482566280,  0.7227529585,  &
0.6290069856,  0.1574710612,  &
0.3028971046,  0.3831228768,  &
0.7314294201,  0.9415815302,  &
0.9372350223,  0.7610778327,  &
0.6046368390,  0.5088269558,  &
0.7087631996,  0.1109964297,  &
0.6642141788,  0.4305424293,  &
0.6749262894,  0.6023043653,  &
0.8164480718,  0.4476515429,  &
0.9009743167,  0.9764108547,  &
0.9935765742,  0.1892143130,  &
0.5433544351,  0.7803075147,  &
0.3286320696,  0.4076726816,  &
0.0581929316,  0.1297234943,  &
0.5661831348,  0.6932581786,  &
0.2081684867,  0.9089322029,  &
0.1370698516,  0.9388454402,  &
0.6382994009,  0.0274883017,  &
0.0969441831,  0.9563101320,  &
0.9702704523,  0.0390956184,  &
0.2191490372,  0.3908363051,  &
0.7353292904,  0.7535459936,  &
0.6521749765,  0.5495043709,  &
0.8259015484,  0.1704380836,  &
0.1112544460,  0.8737198142,  &
0.5479970580,  0.9778857679,  &
0.5022188594,  0.5024134231,  &
0.2691928074,  0.6206786586,  &
0.3189510146,  0.2016102074,  &
0.0227711874,  0.5108133800,  &
0.3401950493,  0.4483292500,  &
0.2073617826,  0.2079042008,  &
0.2130081009,  0.4020865042,  &
0.8610383420,  0.9317012890,  &
0.5016311983,  0.8923526298,  &
0.5624374699,  0.6909716061,  &
0.9128184365,  0.0561843838,  &
0.1859381256,  0.1881469102,  &
0.2593270611,  0.8856669103,  &
0.9892347334,  0.8056258001,  &
0.4229474510,  0.5635324564,  &
0.1778489363,  0.8080529250,  &
0.5490519791,  0.1775359016,  &
0.7220674796,  0.5760672174,  &
0.6699186502,  0.4940195853,  &
0.8012081168,  0.3632654622,  &
0.6137471223,  0.9504301981,  &
0.1482460563,  0.3772839511,  &
0.5471131176,  0.2116138875,  &
0.5368781338,  0.2576602292,  &
0.7102195285,  0.3209961412,  &
0.0521446371,  0.4256706537,  &
0.1845998324,  0.2805643845,  &
0.7766032148,  0.6173759363,  &
0.5823986703,  0.0364514616,  &
0.2647412880,  0.6254211985,  &
0.2987652577,  0.9653603610,  &
0.8229272189,  0.8054883743,  &
0.7989667902,  0.5138928529,  &
0.2972721499,  0.5620249246,  &
0.6092049564,  0.1169047165,  &
0.7892669172,  0.9530648374,  &
0.9803161706,  0.5056619104,  &
0.7988004958,  0.6210857666,  &
0.5222058029,  0.2309292689,  &
0.6444879061,  0.6512490662,  &
0.7218593371,  0.9538387113,  &
0.7374998043,  0.5620343832,  &
0.6789714538,  0.1747422477,  &
0.2691392703,  0.3973975203,  &
0.4965198130,  0.3267270680,  &
0.9461302820,  0.6306296045,  &
0.8656674827,  0.3344445587,  &
0.3744418029,  0.6424412398,  &
0.4788385359,  0.0692395174,  &
0.7601474124,  0.3651120860,  &
0.4993969908,  0.7677268834,  &
0.5029157993,  0.4165285926,  &
0.2084932578,  0.9838534651,  &
0.2871188728,  0.9344896408,  &
0.5581471783,  0.6944823343,  &
0.2108475133,  0.0703709391,  &
0.7429455480,  0.2504718713,  &
0.2093395160,  0.0453385261,  &
0.2280989626,  0.0868868065,  &
0.5515849099,  0.9969233854,  &
0.9302014047,  0.5210223083,  &
0.5982778599,  0.1922027054,  &
0.0751492487,  0.7902459004,  &
0.9686826636,  0.9154705203,  &
0.1601094578,  0.4282129904,  &
0.3444817853,  0.8240457004,  &
0.0710075315,  0.5527424582,  &
0.5518420782,  0.2282921255,  &
0.2426849988,  0.2629642522,  &
0.4909927818,  0.4424458592,  &
0.2448330049,  0.8241485056,  &
0.7296651534,  0.5944644764,  &
0.0211048397,  0.0191346329,  &
0.9949067874,  0.3490535559,  &
0.5630975918,  0.6243130605,  &
0.5159528559,  0.8751916886,  &
0.2596586902,  0.0068745217,  &
0.0758395121,  0.6320214731,  &
0.9230986782,  0.2854784165,  &
0.1531171552,  0.2337051438,  &
0.9550767616,  0.1652026909,  &
0.2284953060,  0.7808456263,  &
0.7691887240,  0.9417067996,  &
0.5943461295,  0.3986548165,  &
0.8721518774,  0.8988868808,  &
0.3622070574,  0.3211388408,  &
0.6878357258,  0.5125839764,  &
0.2261943908,  0.3077517459,  &
0.7425180832,  0.5894343391,  &
0.3067399687,  0.8479538809,  &
0.2863697752,  0.2833331214,  &
0.9318201817,  0.8355581055,  &
0.9948543182,  0.6203965284,  &
0.1599053894,  0.4450926814,  &
0.9634977018,  0.5712527465,  &
0.9552282850,  0.0120022087,  &
0.9792862326,  0.0635446695,  &
0.9477516612,  0.5187109388,  &
0.8126083305,  0.8528950333,  &
0.9971465177,  0.1073777362,  &
0.3027083952,  0.2057135881,  &
0.1533631698,  0.0323819547,  &
0.5592867105,  0.7511644971,  &
0.3907013130,  0.8777884774,  &
0.5619248755,  0.3134744454,  &
0.4361290128,  0.4297238418,  &
0.1693135382,  0.7719780570,  &
0.0293048430,  0.3933238480,  &
0.7284712963,  0.2834138297,  &
0.6255938872,  0.9665519816,  &
0.1310691881,  0.7254933627,  &
0.5912728412,  0.7871861072,  &
0.5616070525,  0.8573002325,  &
0.8798303402,  0.8699248391,  &
0.4892833509,  0.0584399795,  &
0.2931453287,  0.2934069573,  &
0.0856756493,  0.5237731288,  &
0.3788851569,  0.2146274589,  &
0.3211784759,  0.5976958134,  &
0.8734191926,  0.4637410217,  &
0.3957131277,  0.2586038630,  &
0.9870084202,  0.6671985303,  &
0.7488891690,  0.4274170552,  &
0.6762626378,  0.8613311565,  &
0.5874023163,  0.2496495479,  &
0.1091088548,  0.3538207279,  &
0.9547764611,  0.3081549889,  &
0.5918241080,  0.8828145196,  &
0.4743923735,  0.6955521453,  &
0.5491474754,  0.0818461664,  &
0.0432210582,  0.5489057731,  &
0.4123155204,  0.8046178064,  &
0.0492514252,  0.8898542342,  &
0.8417832436,  0.6358878360,  &
0.0049960110,  0.8060974376,  &
0.9494553222,  0.9460297835,  &
0.0664930723,  0.3970528961,  &
0.0468754794,  0.0769501138,  &
0.1189740369,  0.0098528810,  &
0.4218373453,  0.2621283012,  &
0.8711419333,  0.4938550555,  &
0.7594927996,  0.5460054251,  &
0.0945923673,  0.1690403353,  &
0.8372261049,  0.9572978287,  &
0.3698226084,  0.6094067153,  &
0.5901808510,  0.3738531139,  &
0.8346524788,  0.0897315342,  &
0.9492987500,  0.9992718528,  &
0.8346094066,  0.8128938366,  &
0.4400530895,  0.4627490169,  &
0.5013552680,  0.8577428553,  &
0.4894763351,  0.6390124348,  &
0.1973116732,  0.1337603767,  &
0.4441727318,  0.1897299293,  &
0.5336785147,  0.7040583401,  &
0.2842665868,  0.7513703162,  &
0.6518352262,  0.7244221945,  &
0.0768510103,  0.7450284062,  &
0.2673198377,  0.4933450587,  &
0.5425469690,  0.6890308506,  &
0.6726590730,  0.3359870945,  &
0.8049076497,  0.4503283998,  &
0.4299604354,  0.4682321405,  &
0.0966310997,  0.3344310294,  &
0.0075009952,  0.2674731171,  &
0.2133074235,  0.8238426463,  &
0.6283786110,  0.5755638626,  &
0.3644463736,  0.0860320257,  &
0.3861827798,  0.3192072678,  &
0.1578647085,  0.7711907435,  &
0.6031430998,  0.4952398802,  &
0.8924222703,  0.2853299460,  &
0.0979466711,  0.6903187283,  &
0.9101529289,  0.4148263836,  &
0.4576841687,  0.9934503256,  &
0.0770352715,  0.6902284404,  &
0.6743072691,  0.8646591121,  &
0.6658465734,  0.8557195745,  &
0.3143660783,  0.3806008804,  &
0.1770644937,  0.8238005636,  &
0.3031171689,  0.6874993099,  &
0.3193365935,  0.2485636486,  &
0.2616317157,  0.3194574962,  &
0.4128150362,  0.3852052800,  &
0.2205757560,  0.1798737971,  &
0.9063613568,  0.2970083617,  &
0.3044153970,  0.7359119728,  &
0.0866245504,  0.0358990109,  &
0.3537666694,  0.4782522767,  &
0.7386402946,  0.5746953715,  &
0.9945661525,  0.2980470195,  &
0.7847725738,  0.8613929872,  &
0.6677599170,  0.8663912930,  &
0.7422980927,  0.0140907873,  &
0.3621357569,  0.1536644933,  &
0.2957175884,  0.4236815298,  &
0.9768130846,  0.9119450924,  &
0.0487951317,  0.6559942486,  &
0.9632449501,  0.9993836879,  &
0.4132617191,  0.5962559646,  &
0.9165786793,  0.9243587747,  &
0.5819440472,  0.1990382450,  &
0.2995967070,  0.1458155815,  &
0.4163535761,  0.6512839769,  &
0.0807103421,  0.6157253341,  &
0.5296683717,  0.8446512489,  &
0.9305875697,  0.6752535056,  &
0.3044472817,  0.8071078978,  &
0.0111080207,  0.9206393490,  &
0.8051948464,  0.8581565009,  &
0.1421528170,  0.4092081936,  &
0.5932276210,  0.0880325161,  &
0.6933552407,  0.5772543686,  &
0.4899177047,  0.5404645407,  &
0.3226967160,  0.9356859783,  &
0.1355574832,  0.5469832639,  &
0.1877168451,  0.1115761425,  &
0.6356525376,  0.7145870532,  &
0.7396114021,  0.0594860244,  &
0.2548049064,  0.7749690076,  &
0.4257534470,  0.2569290833,  &
0.2495681675,  0.9042240621,  &
0.2010729632,  0.2192612295,  &
0.4947958641,  0.7518422586,  &
0.3556886606,  0.9410460517,  &
0.7864557448,  0.1860415753,  &
0.9668513726,  0.5211438630,  &
0.5962099129,  0.2697500717,  &
0.5428721106,  0.7145470441,  &
0.2243782367,  0.5439307261,  &
0.5987608813,  0.0346032285,  &
0.2715476297,  0.2991561296,  &
0.5940875918,  0.7512902867,  &
0.6803664451,  0.8674931621,  &
0.5018349993,  0.0880255241,  &
0.2343027023,  0.2665557393,  &
0.0638091277,  0.0585132734,  &
0.1589578692,  0.1851533867,  &
0.1004198835,  0.2786819831,  &
0.8014401500,  0.2096254314,  &
0.4759812045,  0.5210995657,  &
0.2553653824,  0.5211494556,  &
0.6892165594,  0.9021373969,  &
0.3610745958,  0.1867689251,  &
0.2875256202,  0.2689747129,  &
0.9741533369,  0.2663473015,  &
0.0069435663,  0.4536438821,  &
0.0060996834,  0.4737541041,  &
0.5780250521,  0.6786925900,  &
0.9808425984,  0.6868923439,  &
0.1940874258,  0.1273962356,  &
0.9477434550,  0.3572909543,  &
0.8229867056,  0.3238535987,  &
0.6396605813,  0.9982295046,  &
0.4331585824,  0.7505739963,  &
0.9924412414,  0.5258688771,  &
0.0892497497,  0.4518094008,  &
0.7690720063,  0.9397794411,  &
0.3848702151,  0.7005686554,  &
0.9578939587,  0.8149773031,  &
0.2850601552,  0.0166718533,  &
0.9024416521,  0.1325015011,  &
0.0578719294,  0.0609081139,  &
0.2750382026,  0.3039948921,  &
0.5671863223,  0.2246818925,  &
0.1307201242,  0.0862554543,  &
0.7044630961,  0.3551313061,  &
0.4988317771,  0.7097030886,  &
0.0759911709,  0.1951369840,  &
0.3823622710,  0.9614642525,  &
0.3505172865,  0.8482103198,  &
0.1294370275,  0.1721917387,  &
0.1982597105,  0.7456931986,  &
0.5155212366,  0.0749793958,  &
0.8077515057,  0.0333354453,  &
0.8690729818,  0.9082839650,  &
0.6098380451,  0.1032635588,  &
0.1194509762,  0.8642058202,  &
0.7038665378,  0.6491321791,  &
0.5155385018,  0.1086583762,  &
0.3970393874,  0.0246410445,  &
0.7136875602,  0.7755569284,  &
0.6571992014,  0.9553710057,  &
0.6231537056,  0.3547687783,  &
0.9601978448,  0.3414136740,  &
0.7521875455,  0.9795372575,  &
0.9649989773,  0.8973895385,  &
0.2709372588,  0.6060297634,  &
0.3974660062,  0.4353338705,  &
0.5872109508,  0.2154353860,  &
0.9809018649,  0.1994894277,  &
0.4026671453,  0.1921225036,  &
0.0647382810,  0.2173823697,  &
0.1074350804,  0.1832058449,  &
0.0414017539,  0.6494379514,  &
0.1428012835,  0.1881213588,  &
0.8778132847,  0.5910560798,  &
0.1333453386,  0.2816342729,  &
0.2097909473,  0.4535334936,  &
0.2386243035,  0.0787920916,  &
0.2891664316,  0.8002392085,  &
0.3492612482,  0.9082567555,  &
0.5088321248,  0.7379596152,  &
0.7259372067,  0.0896654051,  &
0.9750163047,  0.6275416536,  &
0.9995963489,  0.2349110360,  &
0.7669079720,  0.3701094398,  &
0.7603039192,  0.7857485130,  &
0.7289858825,  0.7905679683,  &
0.0600195523,  0.8369805838,  &
0.8325505481,  0.3746947284,  &
0.1878460764,  0.5228176348,  &
0.2290501660,  0.3504852698,  &
0.5400236973,  0.6021739369,  &
0.7524067360,  0.5828871300,  &
0.9293115147,  0.3773327193,  &
0.0476049722,  0.2458910082,  &
0.9144632060,  0.6712951462,  &
0.3103684539,  0.6722523792,  &
0.3813414604,  0.9933492384,  &
0.0281968785,  0.1207158892,  &
0.8862961130,  0.8283888010,  &
0.9949761789,  0.9850171567,  &
0.2623508849,  0.1155960398,  &
0.5217155114,  0.2747690815,  &
0.4114631072,  0.4307684887,  &
0.1837170494,  0.7856607438,  &
0.5561248286,  0.6575648717,  &
0.1534307925,  0.1080905467,  &
0.9837665761,  0.1246289559,  &
0.1025295585,  0.6759851466,  &
0.2553900785,  0.1277876353,  &
0.6791109524,  0.6630623331,  &
0.6318115916,  0.6980068744,  &
0.3641986742,  0.5983848708,  &
0.1904892485,  0.3170863315,  &
0.6564927964,  0.8717375009,  &
0.1503018854,  0.6630491602,  &
0.3792843277,  0.8443734427,  &
0.7862119805,  0.6455855965,  &
0.2804415199,  0.5154681544,  &
0.4185276837,  0.4792947777,  &
0.2492087205,  0.9902534406,  &
0.5810751818,  0.7889353824,  &
0.4727227374,  0.4945678434,  &
0.2290353557,  0.1660473068,  &
0.3478005465,  0.4242406929,  &
0.0654600671,  0.6280810962,  &
0.0101564901,  0.7136148547,  &
0.3754055235,  0.2662121805,  &
0.2088759973,  0.6591679095,  &
0.8464762828,  0.9250052013,  &
0.3745531261,  0.4278785885,  &
0.2190712618,  0.4439678251,  &
0.8925409211,  0.6270073103,  &
0.1485974395,  0.5083532762,  &
0.3503219052,  0.8232008480,  &
0.3922595147,  0.2198664471,  &
0.4295126515,  0.9766607472,  &
0.2377768574,  0.9130231444,  &
0.6196629936,  0.6234710260,  &
0.7113458972,  0.9423116854,  &
0.1798358849,  0.0719338733,  &
0.8250413894,  0.1267149493,  &
0.4744883371,  0.9595653634,  &
0.6241432144,  0.3364568890,  &
0.5255542347,  0.5663457183,  &
0.6783555811,  0.1561357801,  &
0.1337625159,  0.6396076806,  &
0.9383514866,  0.8375397185,  &
0.6033676581,  0.9885502233,  &
0.4014557755,  0.5795835038,  &
0.8285500105,  0.2735915794,  &
0.2253671610,  0.9322360193,  &
0.8466774596,  0.0932013542,  &
0.5068590076,  0.8218975280,  &
0.7977980693,  0.0946230994,  &
0.2482467017,  0.1122321515,  &
0.4213612232,  0.5257637799,  &
0.8913034216,  0.7266179452,  &
0.7744598221,  0.1901224192,  &
0.9564824311,  0.6749718915,  &
0.5147266356,  0.8629942709,  &
0.1076082012,  0.9528880873,  &
0.7914051559,  0.6600636444,  &
0.3809956807,  0.7173987142,  &
0.7872309452,  0.7140245511,  &
0.2263979296,  0.8642513026,  &
0.1529955837,  0.3359657349,  &
0.5739871590,  0.8306778552,  &
0.1169180801,  0.9981728998,  &
0.2118655078,  0.3659351060,  &
0.0626529246,  0.4223879564,  &
0.5517852815,  0.6422401686,  &
0.0138312123,  0.6779118572,  &
0.7628153708,  0.0212040601,  &
0.9307495165,  0.8650819490,  &
0.1109614413,  0.8926729155,  &
0.6508161610,  0.7833649133,  &
0.0830300916,  0.1692328796,  &
0.2556417077,  0.4449034017,  &
0.3838368063,  0.4538524979,  &
0.2041247362,  0.0972166936,  &
0.3314407120,  0.9061820599,  &
0.4067102514,  0.8314315751,  &
0.1777708385,  0.4351114989,  &
0.2231755739,  0.4969021700,  &
0.3818423208,  0.9694500013,  &
0.6951521350,  0.0139280889,  &
0.9543612956,  0.4713236382,  &
0.3506763349,  0.0438369133,  &
0.0023996839,  0.3825636567,  &
0.0848086865,  0.1464422147,  &
0.5516448099,  0.0289394439,  &
0.7363162126,  0.9591055462,  &
0.3490119152,  0.2095076051,  &
0.8052981746,  0.5849937238,  &
0.3608508228,  0.1230340504,  &
0.4113177351,  0.5813123266,  &
0.2553485220,  0.6714952729,  &
0.8198786584,  0.3338533193,  &
0.3494956456,  0.5036038066,  &
0.0325683818,  0.7727016292,  &
0.5379319180,  0.9457381091,  &
0.6366105257,  0.2479921374,  &
0.7919037106,  0.9581378392,  &
0.4216090202,  0.8770108199,  &
0.7431615754,  0.3612942094,  &
0.0483324322,  0.8576330478,  &
0.5275173871,  0.1384579263,  &
0.9557437071,  0.5355993569,  &
0.7290334266,  0.7267860976,  &
0.6432391717,  0.5727917842,  &
0.5356113960,  0.6130555765,  &
0.5137514058,  0.0700176984,  &
0.6154260493,  0.9364073958,  &
0.4441423597,  0.4058791003,  &
0.5268224216,  0.2596628768,  &
0.2865085298,  0.0578876672,  &
0.0925099005,  0.8249159051,  &
0.7349837448,  0.0336459779,  &
0.8745157300,  0.8797735525,  &
0.8618902442,  0.5330072236,  &
0.3627256238,  0.2283044851,  &
0.0597147902,  0.6710527213,  &
0.0655191106,  0.0288639630,  &
0.6672104352,  0.2968614834,  &
0.7480469458,  0.4759310321,  &
0.7180372364,  0.4643778141,  &
0.6344861241,  0.9750973924,  &
0.4014858757,  0.2991252835,  &
0.5427760815,  0.4540211854,  &
0.1352875267,  0.3292011068,  &
0.3674410960,  0.1525029569,  &
0.7882451570,  0.2308590685,  &
0.4864622024,  0.8501238130,  &
0.9387185151,  0.1640398885,  &
0.4277642943,  0.8215539124,  &
0.0894001491,  0.0584925275,  &
0.6257577195,  0.8182442467,  &
0.5538311608,  0.0695420142,  &
0.4780491834,  0.1806223101,  &
0.0958354806,  0.9360537056,  &
0.8138047382,  0.8305662942,  &
0.3060440208,  0.2489940988,  &
0.8850039500,  0.8233318674,  &
0.0784159850,  0.0876416257,  &
0.5240942259,  0.0621304179,  &
0.6798792890,  0.2887645637,  &
0.6006558739,  0.6322847103,  &
0.2703253138,  0.2106985206,  &
0.9815530122,  0.0646125031,  &
0.9888869073,  0.8758941574,  &
0.6559425738,  0.3723477745,  &
0.0308009424,  0.6799072038,  &
0.2415395933,  0.1935741961,  &
0.6344742201,  0.6909894478,  &
0.4273525918,  0.0847456301,  &
0.2631417133,  0.4382754807,  &
0.0605064447,  0.3202891500,  &
0.1654019070,  0.9230929913,  &
0.8583231044,  0.6846929932,  &
0.0550598099,  0.7187872466,  &
0.4958584166,  0.1300659130,  &
0.2471500620,  0.4781020491,  &
0.5278517052,  0.3073334618,  &
0.1730152174,  0.3020305185,  &
0.9953899463,  0.5530543643,  &
0.6797022960,  0.1402938204,  &
0.9059752792,  0.0768794745,  &
0.8375353360,  0.8097141235,  &
0.5967909319,  0.0597484985,  &
0.6034527006,  0.0663517232,  &
0.8539615373,  0.1965249977,  &
0.0276738519,  0.7073481927,  &
0.8363047264,  0.3283545545,  &
0.4095055948,  0.2775617297,  &
0.1366366612,  0.9333816781,  &
0.3980761962,  0.7405998601,  &
0.3898654531,  0.9302789394,  &
0.3620321356,  0.5798905912,  &
0.8758892226,  0.1864653778,  &
0.9213880951,  0.2302298144,  &
0.3679046090,  0.8164468815,  &
0.9727375431,  0.0530798792,  &
0.7914157621,  0.9609471132,  &
0.5661673142,  0.7725588236,  &
0.4188193299,  0.0499407787,  &
0.9509816660,  0.1542632635,  &
0.2846754276,  0.7277619265,  &
0.1987971112,  0.4616266614,  &
0.7086648698,  0.1375357569,  &
0.8722901437,  0.0385831258,  &
0.0597261037,  0.5285537962,  &
0.0704950516,  0.9082527575,  &
0.8023558615,  0.5633179147,  &
0.0445516778,  0.8832067311,  &
0.4845912231,  0.7923782504,  &
0.3219326976,  0.7298990338,  &
0.8037323089,  0.9900093800,  &
0.7258725209,  0.5416285499,  &
0.6561263300,  0.2280357669,  &
0.6651927293,  0.6087053223,  &
0.1877343795,  0.7490628099,  &
0.4417273508,  0.6963998730,  &
0.8693471117,  0.6348846495,  &
0.0722341133,  0.0564293026,  &
0.3059651690,  0.1674385804,  &
0.4626436321,  0.1238472706,  &
0.4833892740,  0.4332162498,  &
0.1706622388,  0.8292589732,  &
0.0418464229,  0.6432928927,  &
0.0013448407,  0.0717544659,  &
0.3269871548,  0.2507947243,  &
0.0709565666,  0.8177461519,  &
0.3516175220,  0.6823282602,  &
0.4903629220,  0.8506284726,  &
0.6920556598,  0.4789432719,  &
0.3360511655,  0.8050549947,  &
0.6529514955,  0.3551709758,  &
0.2642458840,  0.9265292158,  &
0.2003075747,  0.6822288763,  &
0.8262519159,  0.9438907784,  &
0.1517670653,  0.9379107445,  &
0.9469288938,  0.8544761533,  &
0.5991766448,  0.6598245580,  &
0.4704329833,  0.4839902450,  &
0.3777687265,  0.3311797735,  &
0.4506297045,  0.1587078438,  &
0.1961085411,  0.3420860766,  &
0.9678704689,  0.5354253856,  &
0.4323768251,  0.5504417862,  &
0.6487548583,  0.9788586158,  &
0.3856578749,  0.4677711114,  &
0.2670164679,  0.7980775174,  &
0.0149988253,  0.3939936612,  &
0.3439068869,  0.2296003943,  &
0.4113656153,  0.8393936438,  &
0.0434189234,  0.9708949889,  &
0.2862783081,  0.6959989480,  &
0.8519051828,  0.1038486456,  &
0.3960581350,  0.0166591842,  &
0.2936985817,  0.4685791909,  &
0.5323687960,  0.2608561028,  &
0.9064683103,  0.8840301087,  &
0.9477875466,  0.5915958676,  &
0.4038985050,  0.3440352849,  &
0.0764466873,  0.1440529551,  &
0.5394177337,  0.9705129351,  &
0.6733726470,  0.0686856925,  &
0.5092905391,  0.2018217415,  &
0.2318990022,  0.5150281090,  &
0.5572772295,  0.5111182417,  &
0.0070727537,  0.4742232139,  &
0.5225099145,  0.2888472027,  &
0.3267233018,  0.4588207047,  &
0.3259427496,  0.0820821913,  &
0.6929168723,  0.3636509482,  &
0.5942331077,  0.3485347755,  &
0.5996006481,  0.3346027839,  &
0.3046075036,  0.8507344418,  &
0.0144455723,  0.9618702830,  &
0.5292628789,  0.8933081328,  &
0.2478967356,  0.9813234709,  &
0.7100531462,  0.9445321806,  &
0.9334192682,  0.5232927150,  &
0.3946353791,  0.2657662149,  &
0.0421349582,  0.0938533204,  &
0.1160243167,  0.7685473571,  &
0.9606080269,  0.4906419723,  &
0.3498326097,  0.7586729836,  &
0.2453492384,  0.9237205767,  &
0.2722185657,  0.7165400251,  &
0.2615502356,  0.9947377997,  &
0.3401271862,  0.6533355035,  &
0.3488888171,  0.8152653182,  &
0.0933331567,  0.6192375884,  &
0.9233003739,  0.4499083593,  &
0.6172567999,  0.5469534038,  &
0.1587854362,  0.0031256093,  &
0.5891954082,  0.9521186936,  &
0.3000354175,  0.2110092813,  &
0.8220771998,  0.0839379011,  &
0.1592122155,  0.6459304716,  &
0.9942285096,  0.4116277052,  &
0.8622935047,  0.3003586583,  &
0.3650312518,  0.7639567853,  &
0.9269958678,  0.2184918420,  &
0.2684503753,  0.0287031714,  &
0.6012021720,  0.9788147976,  &
0.2042095433,  0.5187730400,  &
0.5291892741,  0.8946583082,  &
0.0003180523,  0.6942570717,  &
0.4003172743,  0.7218784025,  &
0.2138459966,  0.1836930704,  &
0.9016003388,  0.5520685460,  &
0.1535608026,  0.9351124602,  &
0.4965789312,  0.4252250761,  &
0.9942019202,  0.4948391260,  &
0.4213334827,  0.3493700048,  &
0.9245162623,  0.0655138226,  &
0.9700262523,  0.5809700697,  &
0.0530294477,  0.1258333325,  &
0.3608488012,  0.5385916949,  &
0.7229726481,  0.1765062731,  &
0.1443401623,  0.8197980114,  &
0.2343519391,  0.5707289268,  &
0.0824893285,  0.1528605314,  &
0.0433244053,  0.9719438935,  &
0.9340036507,  0.9243653866,  &
0.6254750829,  0.4024664355,  &
0.4688461033,  0.8878870074,  &
0.3434652643,  0.9455223279,  &
0.4433488445,  0.7923373238,  &
0.1625594025,  0.6512029178,  &
0.1454243378,  0.5281290813,  &
0.4266991841,  0.2911390136,  &
0.9652701205,  0.0182130203,  &
0.4718848823,  0.6055136952,  &
0.8908071217,  0.5851390311,  &
0.3978481692,  0.3233645913,  &
0.5485068336,  0.8113956068,  &
0.0345113346,  0.1388536591,  &
0.5411316092,  0.5683734308,  &
0.2229938860,  0.0778680367,  &
0.4637023356,  0.4095953343,  &
0.2453462680,  0.9214598819,  &
0.9893888145,  0.1614149899,  &
0.8428901877,  0.1445432385,  &
0.7663191578,  0.0555098421,  &
0.7349137840,  0.2446621731,  &
0.2138582959,  0.1647959359,  &
0.2570372056,  0.4353906236,  &
0.6687078972,  0.0575766354,  &
0.9298547549,  0.7515594550,  &
0.1398198062,  0.1546951490,  &
0.7448383936,  0.9728805668,  &
0.5910384947,  0.9303101235,  &
0.9231143573,  0.6385516924,  &
0.4427253897,  0.3607950206,  &
0.0147467988,  0.8787233904,  &
0.8674628691,  0.9172629665,  &
0.6523736536,  0.3899049642,  &
0.8130026087,  0.4144347500,  &
0.3634405060,  0.4040804501,  &
0.4403688022,  0.3481460072,  &
0.0893653253,  0.6925709712,  &
0.2634311969,  0.3245243263,  &
0.6663324554,  0.6138668529,  &
0.4351850883,  0.1552650822,  &
0.9816545980,  0.0855354345,  &
0.9108708881,  0.9038379704,  &
0.5122895319,  0.2832728155,  &
0.5776623210,  0.3390188195,  &
0.2527038726,  0.9638227245,  &
0.3081182602,  0.5674843713,  &
0.1841296416,  0.2224705102,  &
0.6849127395,  0.4513546328,  &
0.6113025126,  0.0255719736,  &
0.1918598285,  0.4376617706,  &
0.4889150072,  0.5918210780,  &
0.5039565254,  0.5802682097,  &
0.3369890611,  0.0719460451,  &
0.4309948342,  0.9413014668,  &
0.1203414676,  0.7388663989,  &
0.0907852951,  0.9345138926,  &
0.5814601474,  0.5693728613,  &
0.5435273191,  0.0937520329,  &
0.7803974276,  0.4068585304,  &
0.2284069988,  0.3450100129,  &
0.5759416727,  0.6760255408,  &
0.2020164599,  0.4501517770,  &
0.8756994449,  0.2644408115,  &
0.3780254444,  0.8125553753,  &
0.7997086975,  0.7545231268,  &
0.1596286818,  0.9961735261,  &
0.9874672230,  0.4872824164,  &
0.6914234929,  0.9614389042,  &
0.3584594404,  0.9290507178,  &
0.6005980391,  0.0828215709,  &
0.6143807097,  0.2162499119,  &
0.1224602235,  0.0496977619,  &
0.0701778596,  0.5059661470,  &
0.3306521947,  0.0615202570,  &
0.7906479413,  0.9802368601,  &
0.2530597976,  0.8000990545,  &
0.6896673826,  0.2548341619,  &
0.9263447463,  0.7116362085,  &
0.5445573236,  0.0054231108,  &
0.3914533428,  0.6422042990,  &
0.4779759641,  0.7800457340,  &
0.9210942662,  0.0135423693,  &
0.7183721970,  0.5115127030,  &
0.6825666873,  0.8691116806,  &
0.0297751768,  0.8893804279,  &
0.6334192327,  0.6508947969,  &
0.9248015172,  0.8706056481,  &
0.0379729847,  0.0933471950,  &
0.4813382119,  0.7760149210,  &
0.5261827499,  0.2474870674,  &
0.9461387945,  0.4714416999,  &
0.5474849905,  0.6076232948,  &
0.6911684639,  0.1113479997,  &
0.7017561739,  0.1935424645,  &
0.4837469332,  0.9875511751,  &
0.2245545463,  0.5847011685,  &
0.2704823250,  0.6039582120,  &
0.4007197547,  0.0292711153,  &
0.0736542569,  0.1740071665,  &
0.6549684280,  0.5004162825,  &
0.3274127110,  0.4629922566,  &
0.9278094261,  0.7536289177,  &
0.3622628152,  0.0943463097,  &
0.1036400022,  0.9204013257,  &
0.1653990539,  0.0005154704,  &
0.0695538271,  0.2620739186,  &
0.9288677102,  0.1256623352,  &
0.1958548744,  0.4514225418,  &
0.2449581585,  0.7519648857,  &
0.1110162503,  0.7269006580,  &
0.6207215211,  0.9866433462,  &
0.8582342574,  0.8235347101,  &
0.8307051713,  0.5897129249,  &
0.2016478917,  0.8792583302,  &
0.5867170186,  0.8065443717,  &
0.9386179807,  0.3957391580,  &
0.1574439442,  0.2539416032,  &
0.4321601922,  0.2329158999,  &
0.8086195773,  0.4843159524,  &
0.6715774659,  0.2058334365,  &
0.3853322874,  0.2028657418,  &
0.6552479689,  0.2900559445,  &
0.2063837403,  0.8201346532,  &
0.6465094633,  0.7406554478,  &
0.5501923091,  0.2676187732,  &
0.4569516917,  0.4814276279,  &
0.6833443297,  0.1404601720,  &
0.1158468413,  0.0650894805,  &
0.4626587659,  0.6593672457,  &
0.7864492788,  0.1957600511,  &
0.1214909673,  0.8161035117,  &
0.4104038755,  0.3247368822,  &
0.6280818010,  0.2031318181,  &
0.1492857135,  0.8211318318,  &
0.2572223741,  0.7411241506,  &
0.1486042212,  0.0205971582,  &
0.6178780096,  0.2644336475,  &
0.3116980993,  0.0812898954,  &
0.6080797939,  0.4647976230,  &
0.4763082278,  0.5970963366,  &
0.2432933189,  0.7737737374,  &
0.7822077868,  0.4828712048,  &
0.7640959159,  0.3621850537,  &
0.3064433444,  0.3350485900,  &
0.0485448045,  0.2408325401,  &
0.5834444313,  0.5230718560,  &
0.8291417508,  0.5588983990,  &
0.8205087309,  0.5943919146,  &
0.1885745845,  0.8187576101,  &
0.4037309229,  0.5055460777,  &
0.5849896212,  0.3374159998,  &
0.2739283361,  0.0859963658,  &
0.7540351368,  0.7020387927,  &
0.9648018785,  0.0391832413,  &
0.1570953564,  0.4757810160,  &
0.0045939245,  0.6790915157,  &
0.5497629419,  0.0426060287,  &
0.2430152741,  0.9682119785,  &
0.0668103057,  0.9916907787,  &
0.8778915607,  0.0229433512,  &
0.2147530501,  0.1773813178,  &
0.3371729589,  0.2611253678,  &
0.9189651309,  0.1130731726,  &
0.8531170872,  0.7069297207,  &
0.6927110894,  0.1733933107,  &
0.1123776837,  0.0391713978,  &
0.4205619402,  0.0643639845,  &
0.5977964875,  0.5805776738,  &
0.3538955829,  0.6227541170,  &
0.4076538304,  0.4239532138,  &
0.8771746900,  0.9325298177,  &
0.1861022625,  0.0202474179,  &
0.1186763262,  0.3967468271,  &
0.5602857207,  0.1834864156,  &
0.4122601044,  0.3028008789,  &
0.5299998446,  0.6475259260,  &
0.3065279297,  0.2998118673,  &
0.3915477511,  0.5474374107,  &
0.8007862217,  0.3835782156,  &
0.8948622612,  0.3110781285,  &
0.3944518204,  0.4415046625,  &
0.9013987369,  0.2811193554,  &
0.9574703945,  0.2224327240,  &
0.4113726682,  0.5667490535,  &
0.5958672135,  0.5091850658,  &
0.3085551632,  0.5745785595,  &
0.6567266507,  0.2821516720,  &
0.5956618066,  0.2085442409,  &
0.2203241721,  0.3461117817,  &
0.8471779086,  0.4579467400,  &
0.2863816429,  0.8097868803,  &
0.3068576908,  0.2200009845,  &
0.7760424384,  0.4364099562,  &
0.6137637180,  0.2019991290,  &
0.3663469534,  0.5082230111,  &
0.7186003706,  0.0161719692,  &
0.1290860577,  0.3289735942,  &
0.5057335877,  0.5291534708,  &
0.9870376637,  0.5696649889,  &
0.8193807162,  0.9630442939,  &
0.9698398401,  0.7352374274,  &
0.5620223425,  0.5166571412,  &
0.0132118957,  0.9990802305,  &
0.1531140208,  0.7700705820,  &
0.1343074236,  0.3530401560,  &
0.8772720542,  0.9147052369,  &
0.0312554032,  0.1822270309,  &
0.6058689759,  0.9147735759,  &
0.8729725892,  0.0545684307,  &
0.4344222855,  0.3103844453,  &
0.2775120047,  0.8802666636,  &
0.3621714701,  0.9420998603,  &
0.1773576169,  0.0782814376,  &
0.3519090091,  0.3106342665,  &
0.4512528882,  0.5284374520,  &
0.4419271633,  0.0059171045,  &
0.1092837013,  0.9860967684,  &
0.8650487744,  0.7595432971,  &
0.6121765961,  0.2678824822,  &
0.9624044147,  0.5718940699,  &
0.6409191488,  0.6989438572,  &
0.7880269353,  0.2564175459,  &
0.2345455112,  0.8554245669,  &
0.5856358492,  0.1641182881,  &
0.3974649700,  0.1868828363,  &
0.2162789145,  0.8283912437,  &
0.2605478958,  0.9585093756,  &
0.1623106142,  0.0858613780,  &
0.3527157820,  0.0889353528,  &
0.5976893756,  0.9558085684,  &
0.2528947809,  0.6388485651,  &
0.7221792519,  0.3724355063,  &
0.3696322489,  0.4310337534,  &
0.7763044385,  0.5378016841,  &
0.5204216450,  0.6968692710,  &
0.6738465279,  0.7927022214,  &
0.3353527306,  0.4128022380,  &
0.9588478130,  0.3535593832,  &
0.4707414168,  0.4508658965,  &
0.9069508894,  0.1113174875,  &
0.8226254800,  0.0953078653,  &
0.5497483840,  0.7600879798,  &
0.5896247680,  0.7484037209,  &
0.6679580426,  0.3168532591,  &
0.3499687857,  0.6533276821,  &
0.1986037510,  0.1337141770,  &
0.7984264050,  0.0886756451,  &
0.7154863243,  0.6509090298,  &
0.5248079777,  0.1148186335,  &
0.9245482225,  0.6098089182,  &
0.2307239217,  0.3881387375,  &
0.7561923065,  0.2680516460,  &
0.7660025131,  0.1874996016,  &
0.1084567835,  0.1329322653,  &
0.2935989716,  0.4420400825,  &
0.0103669479,  0.9255711107,  &
0.7266191641,  0.4372600824,  &
0.7023667022,  0.7001683547,  &
0.3381068187,  0.9738802103,  &
0.7116367896,  0.9682506444,  &
0.9484328689,  0.1352720837,  &
0.1303148760,  0.5469060228,  &
0.1482766189,  0.4562062270,  &
0.0919565553,  0.5411585547,  &
0.6731973319,  0.9354180441,  &
0.8603411560,  0.5562987002,  &
0.7396198437,  0.4708414640,  &
0.5919584915,  0.4511539570,  &
0.5875039486,  0.3298959094,  &
0.0332747139,  0.5074338499,  &
0.9219505116,  0.8905791596,  &
0.6837699368,  0.7649771339,  &
0.5165034424,  0.1557456107,  &
0.8431384891,  0.7825032012,  &
0.5729913611,  0.5832125469,  &
0.3395070414,  0.1848975600,  &
0.4335499935,  0.3747323970,  &
0.6420234555,  0.1356877435,  &
0.1885227956,  0.0498484948,  &
0.2330477309,  0.3505102657,  &
0.9758251865,  0.2790583982,  &
0.1991841711,  0.4450688694,  &
0.3552950258,  0.4952118083,  &
0.7008762291,  0.7695693003,  &
0.6901138097,  0.6382056332,  &
0.7943913067,  0.1382344853,  &
0.8439510393,  0.1593193167,  &
0.1029712702,  0.9033237629,  &
0.4709004547,  0.9938177592,  &
0.7169462793,  0.5207797283,  &
0.7075643438,  0.6347492561,  &
0.4934694053,  0.2096489097,  &
0.9567383426,  0.1456493138,  &
0.1901131403,  0.8215668664,  &
0.5531778868,  0.1788145558,  &
0.0561106893,  0.4196103243,  &
0.1232798879,  0.0470833802,  &
0.3119255622,  0.6540598616,  &
0.4275133941,  0.0256013338,  &
0.9894814290,  0.5253957990,  &
0.9578200890,  0.0601062479,  &
0.7304306184,  0.1528326459,  &
0.4035859079,  0.4195263906,  &
0.8355932929,  0.9805661294,  &
0.2209671273,  0.5711265752,  &
0.0911009698,  0.6558298760,  &
0.9687019702,  0.8594356206,  &
0.2277101417,  0.2200589816,  &
0.9134652877,  0.7015187323,  &
0.5611890141,  0.8555405116,  &
0.0648113823,  0.6456312872,  &
0.3043279935,  0.8360991936,  &
0.4282510281,  0.4480395968,  &
0.5329851552,  0.0251449552,  &
0.2915807971,  0.6253695764,  &
0.7211812598,  0.6065581082,  &
0.9637706437,  0.1094227304,  &
0.3369578568,  0.0801883777,  &
0.5973517589,  0.4554668883,  &
0.4746853771,  0.6760881220,  &
0.8883413327,  0.0476690400,  &
0.7112004946,  0.5555499352,  &
0.8754456104,  0.5424903097,  &
0.1915635447,  0.2451601052,  &
0.3169892505,  0.3915992329,  &
0.5302781837,  0.7987271386,  &
0.0246516272,  0.8433113982,  &
0.5441536953,  0.2297403744,  &
0.2687568308,  0.4060495785,  &
0.6490353138,  0.5173250238,  &
0.2357209467,  0.6017452079,  &
0.7343238600,  0.5245178518,  &
0.5231768924,  0.6568996938,  &
0.8429083049,  0.6333319734,  &
0.5864063433,  0.1002084000,  &
0.0579747495,  0.8224042521,  &
0.9140362652,  0.6531642294,  &
0.9081920958,  0.1500433485,  &
0.8028820597,  0.6740599293,  &
0.3145379772,  0.9474972619,  &
0.5609343585,  0.7044014733,  &
0.7861671037,  0.2426067131,  &
0.4481286652,  0.9286170484,  &
0.7227919461,  0.2366701082,  &
0.5997737929,  0.9429213740,  &
0.2604726221,  0.1789683493,  &
0.8850659209,  0.0417291147,  &
0.4556355496,  0.6205817943,  &
0.6239785765,  0.2251144618,  &
0.3569384504,  0.1588695731,  &
0.4949723790,  0.6854610742,  &
0.4153171369,  0.3376601756,  &
0.5057463729,  0.4571216714,  &
0.9188605515,  0.5680015753,  &
0.7306059905,  0.3713331328,  &
0.2274160300,  0.7911215368,  &
0.3397135578,  0.3506441776,  &
0.0715194659,  0.8568812280,  &
0.5641354335,  0.5131905425,  &
0.9278798515,  0.7548865941,  &
0.6214840777,  0.2806565524,  &
0.3447473816,  0.0756702486,  &
0.1149554084,  0.6588543028,  &
0.5296204981,  0.8498697429,  &
0.4746890998,  0.4904763947,  &
0.7643683262,  0.0089391425,  &
0.4423840642,  0.0893168419,  &
0.5393083894,  0.9722599249,  &
0.9888929840,  0.5155568187,  &
0.7211642103,  0.2044245134,  &
0.5908144996,  0.8471084504,  &
0.6477533424,  0.2777746178,  &
0.0574343144,  0.6409286945,  &
0.5543797423,  0.8608911707,  &
0.7774641453,  0.6835059661,  &
0.7099710836,  0.1231860858,  &
0.2344104597,  0.3936412362,  &
0.8060694917,  0.5774357177,  &
0.1001678937,  0.6728025465,  &
0.8097902891,  0.7654628847,  &
0.1167347523,  0.5969417084,  &
0.7659848939,  0.6227989180,  &
0.1385322186,  0.7582252080,  &
0.8009137637,  0.8020269774,  &
0.3899012151,  0.8267103214,  &
0.4889115461,  0.5478608758,  &
0.6742995135,  0.5880321114,  &
0.8030718317,  0.0026569985,  &
0.5264138389,  0.9701596315,  &
0.9310652443,  0.0360029077,  &
0.2284509916,  0.2956225401,  &
0.1585889776,  0.8958248430,  &
0.8065535016,  0.3222243640,  &
0.5154208802,  0.8304724503,  &
0.6652196539,  0.6723112880,  &
0.4776560375,  0.4874427578,  &
0.4976114338,  0.7510333302,  &
0.4426794369,  0.4250927440,  &
0.0051373269,  0.1031618682,  &
0.8549893342,  0.2549288578,  &
0.3760866235,  0.0892734121,  &
0.8438897444,  0.1328722754,  &
0.8124633938,  0.2043112546,  &
0.3921705391,  0.3761576724,  &
0.4866576188,  0.6943692999,  &
0.3179196553,  0.4411901468,  &
0.9372455169,  0.9366985198,  &
0.5624268116,  0.8555441556,  &
0.8436626909,  0.9511757216,  &
0.0100070564,  0.8974449571,  &
0.9081675759,  0.8753890170,  &
0.6022743842,  0.0772117351,  &
0.0939211244,  0.9534167148,  &
0.6739718898,  0.5036018036,  &
0.7483194369,  0.5312069397,  &
0.7328459572,  0.8562540330,  &
0.6626855509,  0.8037700263,  &
0.3871500846,  0.9326369039,  &
0.1424532608,  0.9165448059,  &
0.4294610288,  0.6434107209,  &
0.7168348527,  0.1767637708,  &
0.6803438633,  0.3292464480,  &
0.6688918283,  0.6537278368,  &
0.2695128294,  0.0373355777,  &
0.4564936564,  0.6797667986,  &
0.6040626513,  0.9601062331,  &
0.9441919237,  0.8683312204,  &
0.1748444142,  0.7009709951,  &
0.4097058891,  0.3705138785,  &
0.1418010485,  0.5648096345,  &
0.6641498165,  0.3402426585,  &
0.8309586194,  0.3979470666,  &
0.8359914076,  0.1726685117,  &
0.4818482041,  0.0325154639,  &
0.5775308296,  0.7837214126,  &
0.1870550754,  0.2049430536,  &
0.8615974448,  0.2191561211,  &
0.8475300880,  0.5596185156,  &
0.6843085877,  0.9147853509,  &
0.7568827774,  0.9704550689,  &
0.2697652877,  0.9864497487,  &
0.3040305061,  0.0310366485,  &
0.4707865615,  0.5345383874,  &
0.3939327099,  0.3096527189,  &
0.8409889444,  0.6220259584,  &
0.7284079998,  0.8226309653,  &
0.8235086674,  0.5506047713,  &
0.5146940997,  0.5222909138,  &
0.9218732622,  0.5641678911,  &
0.7516868941,  0.2085694821,  &
0.0961907570,  0.0343010915,  &
0.8494443093,  0.3618846506,  &
0.7771604009,  0.0035088907,  &
0.7054577533,  0.8788535368,  &
0.2665432007,  0.6863494610,  &
0.4373797833,  0.7651365331,  &
0.9160217356,  0.4783291890,  &
0.0260778558,  0.9259793309,  &
0.1286804180,  0.2283600510,  &
0.5045194992,  0.9460871200,  &
0.2162933079,  0.1392498568,  &
0.2625216889,  0.8599170900,  &
0.9977794670,  0.4386702138,  &
0.5866141899,  0.0730503195,  &
0.8982268732,  0.8809233013,  &
0.4207387683,  0.7674985984,  &
0.5935705364,  0.3346371749,  &
0.5744472634,  0.2230599886,  &
0.3474735456,  0.1638499725,  &
0.6065439985,  0.1016348518,  &
0.7658578199,  0.8367117226,  &
0.6201587992,  0.6313423849,  &
0.9202218800,  0.5840142076,  &
0.3933143385,  0.9602797885,  &
0.0875909366,  0.0170337050,  &
0.9743781022,  0.0013361810,  &
0.7209207661,  0.7372384762,  &
0.2069891940,  0.8095756155,  &
0.8868086297,  0.3144731356,  &
0.5285749158,  0.4701446754,  &
0.2112556622,  0.3454876455,  &
0.9624197120,  0.8530371681,  &
0.3242124549,  0.1361352317,  &
0.2954520790,  0.4132829823,  &
0.7200763734,  0.3581702292,  &
0.9300854913,  0.6883384816,  &
0.5792793942,  0.9003822135,  &
0.6081179936,  0.7209210563,  &
0.0825504209,  0.8997017745,  &
0.3304123953,  0.6611856066,  &
0.2368588206,  0.3756318061,  &
0.7299925504,  0.5268266975,  &
0.8248794048,  0.0031424812,  &
0.1128142029,  0.8477879151,  &
0.7081479601,  0.2822795219,  &
0.8778607461,  0.7788076754,  &
0.6612248595,  0.6808584107,  &
0.9363100972,  0.5470840206,  &
0.5569517437,  0.3997528101,  &
0.0936625111,  0.9576497305,  &
0.8239759939,  0.4707249434,  &
0.5412958186,  0.5681424064,  &
0.7939659544,  0.9732866710,  &
0.2833012943,  0.5262879898,  &
0.1795582008,  0.0161706894,  &
0.7355094427,  0.9879857771,  &
0.3970668580,  0.9241344537,  &
0.4062184275,  0.0298024316,  &
0.1685885539,  0.4289531806,  &
0.8151341121,  0.9967885122,  &
0.3657321823,  0.5750340960,  &
0.9947419856,  0.6453255238,  &
0.9492379441,  0.0142372150,  &
0.0645086236,  0.7403255008,  &
0.8834131069,  0.2204744490,  &
0.6361645096,  0.2620641848,  &
0.1095042816,  0.7620356959,  &
0.4395924025,  0.5435186288,  &
0.3779124924,  0.6531429537,  &
0.2400113897,  0.2378257770,  &
0.2216095415,  0.5868557781,  &
0.4282173221,  0.2848813095,  &
0.6339928162,  0.6349251505,  &
0.4706088050,  0.2766025315,  &
0.9863133907,  0.4989088493,  &
0.9690827657,  0.7443480095,  &
0.4175440149,  0.2743606435,  &
0.2895464956,  0.1595841994,  &
0.3401495551,  0.7501674914,  &
0.6841482948,  0.4847969684,  &
0.7227120796,  0.2586683689,  &
0.5057930948,  0.8989953952,  &
0.9035820393,  0.1774768680,  &
0.9742209261,  0.0500562084,  &
0.1245400319,  0.6253273914,  &
0.1454328038,  0.7608469814,  &
0.3267509805,  0.7721011691,  &
0.8818257236,  0.7396616464,  &
0.0843436706,  0.4102732132,  &
0.5171111801,  0.4360063704,  &
0.8955431699,  0.8113923389,  &
0.8899929946,  0.8531216535,  &
0.6175712541,  0.7536209966,  &
0.3824235267,  0.0891276675,  &
0.6013358583,  0.5331201774,  &
0.9499323548,  0.7839275954,  &
0.5397620888,  0.2038829145,  &
0.5899967349,  0.7875574113,  &
0.2265725012,  0.8929752025,  &
0.8643217438,  0.2066288325,  &
0.2510921640,  0.4998519276,  &
0.7156679123,  0.9471345203,  &
0.6408790408,  0.5469385710,  &
0.0309661088,  0.4245182721,  &
0.0968727635,  0.4595366902,  &
0.7015540135,  0.5059285589,  &
0.8005658789,  0.9804029146,  &
0.6149927505,  0.1545007185,  &
0.4593428947,  0.9142786933,  &
0.9161839644,  0.2040402992,  &
0.9776063061,  0.4349518655,  &
0.3019313283,  0.0950285124,  &
0.3763633875,  0.2843723183,  &
0.8818511887,  0.8846608437,  &
0.8615746190,  0.7018235132,  &
0.7903867156,  0.9049513295,  &
0.7110704007,  0.2259590553,  &
0.6575223956,  0.6008953649,  &
0.5729566466,  0.5056321491,  &
0.1515949702,  0.5989861444,  &
0.9748229711,  0.5455234512,  &
0.8208826543,  0.1465425290,  &
0.3624490964,  0.7338693376,  &
0.2731657693,  0.0295890425,  &
0.6137579324,  0.2315881959,  &
0.0703994332,  0.7614165581,  &
0.5254777346,  0.7994831229,  &
0.7899136537,  0.3261168271,  &
0.1932419724,  0.3917434008,  &
0.1218680694,  0.8123053872,  &
0.1138164587,  0.7058901835,  &
0.3928165724,  0.1585089472,  &
0.4246061685,  0.8190380708,  &
0.1257041036,  0.7182127856,  &
0.8411593237,  0.6757299595,  &
0.6238437542,  0.2037865962,  &
0.9173166004,  0.1082536618,  &
0.4522225091,  0.0034168998,  &
0.0476491664,  0.6879983919,  &
0.3044632483,  0.4206470664,  &
0.0293926356,  0.3450408710,  &
0.1797132284,  0.2202551767,  &
0.2212089539,  0.9520888024,  &
0.4378908801,  0.1006440538,  &
0.7753773517,  0.9574736355,  &
0.8637393896,  0.7166576500,  &
0.2147837359,  0.4860994128,  &
0.5509990010,  0.4765367529,  &
0.6218844657,  0.4404498084,  &
0.5309800349,  0.1685329945,  &
0.0475014428,  0.7323676710,  &
0.0579082131,  0.4041358960,  &
0.7446556316,  0.5349576171,  &
0.1270158305,  0.3088666659,  &
0.8972115022,  0.0059950945,  &
0.6994525754,  0.2143761538,  &
0.0489974912,  0.9893281007,  &
0.6765279321,  0.6528392027,  &
0.5968301235,  0.5788462587,  &
0.7736969660,  0.1565262038,  &
0.8845885394,  0.8670610380,  &
0.1842703026,  0.2789279308,  &
0.3134905356,  0.1944834881,  &
0.0001072916,  0.2520991404,  &
0.5764524582,  0.8059315357,  &
0.3282156430,  0.9963398661,  &
0.3196220790,  0.8075006153,  &
0.0269651983,  0.3460331495,  &
0.5114214210,  0.5803431997,  &
0.6934765317,  0.3190304864,  &
0.9171528707,  0.6082729245,  &
0.0969604141,  0.3712898824,  &
0.9337005166,  0.2608573800,  &
0.9296265949,  0.8889390204,  &
0.7856141387,  0.2839115422,  &
0.9367413226,  0.0339615131,  &
0.3335943430,  0.3976538802,  &
0.1149006249,  0.5257795542,  &
0.7731124259,  0.4239352356,  &
0.0427365799,  0.8893131476,  &
0.2189301909,  0.9303525097,  &
0.5216603255,  0.6037838443,  &
0.2368408201,  0.9068722778,  &
0.1441708087,  0.4871742467,  &
0.5041704313,  0.5065370676,  &
0.2212163686,  0.4769306555,  &
0.2291543341,  0.8524363922,  &
0.4593645499,  0.2853514085,  &
0.5526192462,  0.8453660570,  &
0.0979202726,  0.1059973792,  &
0.5860212919,  0.4388555329,  &
0.7263948534,  0.1121722499,  &
0.1355796845,  0.6796261196,  &
0.0497002837,  0.6409321851,  &
0.7225080337,  0.7520627358,  &
0.3533495093,  0.3693197026,  &
0.7337022280,  0.4236647874,  &
0.4210352293,  0.3556986811,  &
0.9370564466,  0.3804810989,  &
0.3464589979,  0.0342186636,  &
0.2947618081,  0.9143285809,  &
0.9889470426,  0.9024022349,  &
0.3129795928,  0.7716041012,  &
0.8135214290,  0.4125789622,  &
0.5367808351,  0.7778784584,  &
0.1083681444,  0.8014158236,  &
0.1077888520,  0.3197011117,  &
0.4546592384,  0.3572388626,  &
0.2976087855,  0.9916915568,  &
0.7088814254,  0.7981020805,  &
0.1072158239,  0.8771570996,  &
0.3030134623,  0.3689866255,  &
0.0560061849,  0.7881748821,  &
0.0015393483,  0.1274966906,  &
0.3432181932,  0.1109955460,  &
0.4174968119,  0.9457099045,  &
0.7497394511,  0.7460714936,  &
0.4550033749,  0.0075897016,  &
0.7040321271,  0.1399886252,  &
0.6607459973,  0.0927728668,  &
0.1012598509,  0.1277311208,  &
0.4938554013,  0.5707905748,  &
0.1235033488,  0.1430614219,  &
0.7073309784,  0.7263358996,  &
0.6572808676,  0.6335973683,  &
0.0017728858,  0.7536501424,  &
0.6939915549,  0.1937760689,  &
0.4546524524,  0.4369210487,  &
0.9033301092,  0.2854440655,  &
0.0419344064,  0.1857644296,  &
0.6179980654,  0.0649913974,  &
0.5762551525,  0.3682865591,  &
0.9295975660,  0.0180718934,  &
0.3083195671,  0.3660569128,  &
0.3027459285,  0.9028224427,  &
0.3286992878,  0.2792184480,  &
0.1456493509,  0.7420617048,  &
0.6578542757,  0.8495768129,  &
0.6732390318,  0.0958906896,  &
0.4899941965,  0.9788116655,  &
0.3313905886,  0.4898732109,  &
0.6082252711,  0.0113129843,  &
0.4108630813,  0.3741410535,  &
0.6372124125,  0.3749138974,  &
0.4675503979,  0.4756963279,  &
0.7014503996,  0.7051781688,  &
0.2248571162,  0.8174151056,  &
0.5083211911,  0.6380588389,  &
0.2361561276,  0.9458918750,  &
0.1789911313,  0.7022244164,  &
0.8409994334,  0.0672031215,  &
0.2510092853,  0.6736545121,  &
0.4629627685,  0.4423306209,  &
0.8284632356,  0.8805239144,  &
0.7004899254,  0.7177161595,  &
0.4746335176,  0.7973210970,  &
0.8774982104,  0.3066049590,  &
0.1059365108,  0.7912258167,  &
0.3344268294,  0.1110194726,  &
0.9080958729,  0.1059695002,  &
0.8534481431,  0.0816093274,  &
0.8237248470,  0.9894220769,  &
0.6261896098,  0.5526733121,  &
0.8047766755,  0.3487730777,  &
0.4935222340,  0.0541876126,  &
0.6536031013,  0.8986536385,  &
0.4149012613,  0.8621723390,  &
0.8406132723,  0.2731284281,  &
0.6781036638,  0.4294952724,  &
0.2493789208,  0.7140322178,  &
0.0886912906,  0.1101097801,  &
0.7992365011,  0.7512496337,  &
0.4506898558,  0.9836539133,  &
0.1231097456,  0.3348422117,  &
0.4061897765,  0.8945268386,  &
0.4466547922,  0.7970759418,  &
0.3677440572,  0.4234324791,  &
0.6338482247,  0.7487938083,  &
0.6515348782,  0.2155451188,  &
0.5671276399,  0.5074592065,  &
0.9659870711,  0.7415896901,  &
0.7249141950,  0.5566748324,  &
0.0122855071,  0.9728104895,  &
0.6538501668,  0.0421790889,  &
0.7352000993,  0.2652651487,  &
0.7215049878,  0.6526275766,  &
0.9268527201,  0.5712755159,  &
0.3096896854,  0.0459333531,  &
0.2893926009,  0.0194848492,  &
0.1976716195,  0.1241667231,  &
0.2349866082,  0.0294913891,  &
0.8123156109,  0.5156430117,  &
0.5554665772,  0.7825595795,  &
0.5182852654,  0.6745305889,  &
0.2648099610,  0.5144789094,  &
0.4768411203,  0.2402150999,  &
0.6027367866,  0.3462398716,  &
0.0835253079,  0.6766072149,  &
0.4669405180,  0.5206410868,  &
0.1925814069,  0.4448926436,  &
0.5944928610,  0.1028675196,  &
0.3266197036,  0.2306676627,  &
0.2134808302,  0.0437886849,  &
0.0398344621,  0.8584563776,  &
0.7962840195,  0.2613243180,  &
0.7548348921,  0.9928609833,  &
0.1206918002,  0.9324951641,  &
0.6543390990,  0.6269251342,  &
0.1319427639,  0.3814222153,  &
0.9121090714,  0.1270156262,  &
0.7564358678,  0.9254294046,  &
0.5043876229,  0.8334246042,  &
0.4749866572,  0.9790675027,  &
0.9932753148,  0.5251720260,  &
0.7228507990,  0.0066764649,  &
0.4153948865,  0.3293569080,  &
0.1625197110,  0.9455383138,  &
0.2739328180,  0.0876302381,  &
0.6668653458,  0.3126100285,  &
0.1178336343,  0.3943730590,  &
0.0947464586,  0.3529388274,  &
0.2713061899,  0.0713525000,  &
0.6114037591,  0.2362005715,  &
0.6657415090,  0.0667147326,  &
0.9883755140,  0.8392270870,  &
0.6907289328,  0.0870904181,  &
0.2728969937,  0.0400918937,  &
0.6215536706,  0.9686934820,  &
0.6884870322,  0.8167456568,  &
0.3049923816,  0.1179689952,  &
0.0031052793,  0.8465565884,  &
0.7713147565,  0.5734432728,  &
0.6602420556,  0.2405887386,  &
0.7053204772,  0.5629107480,  &
0.3116513916,  0.6502611962,  &
0.0257129234,  0.1729031492,  &
0.3973836612,  0.1235640965,  &
0.1385316293,  0.4993027783,  &
0.1553022800,  0.8351421284,  &
0.7740483204,  0.6251862858,  &
0.8388766567,  0.9716027842,  &
0.1414758927,  0.3737889479,  &
0.6427148624,  0.5097606375,  &
0.3077798285,  0.9744767445,  &
0.9209914157,  0.6831949763,  &
0.3971415972,  0.6280744030,  &
0.0079734431,  0.0209812761,  &
0.4783477878,  0.0957153374,  &
0.7801650161,  0.8895274376,  &
0.5446576325,  0.0703068860,  &
0.4939002849,  0.8652817236,  &
0.8755224887,  0.7780860923,  &
0.6716688772,  0.1128529552,  &
0.0803784459,  0.8495733360,  &
0.0046072290,  0.5944590527,  &
0.9341956731,  0.6740436959,  &
0.2174369203,  0.6005777140,  &
0.3324607428,  0.4796498184,  &
0.8670702301,  0.6092319692,  &
0.7629151895,  0.7612645363,  &
0.6512570337,  0.3999714327,  &
0.9507061498,  0.1580372478,  &
0.9522032312,  0.4298972093,  &
0.9663374602,  0.4806108165,  &
0.9100200790,  0.7679105190,  &
0.5733974848,  0.6736713252,  &
0.9928892651,  0.9491114984,  &
0.3159853913,  0.3823641409,  &
0.3271449013,  0.7713790558,  &
0.0688196002,  0.4848412901,  &
0.3647693843,  0.9087987916,  &
0.1713931321,  0.5698140177,  &
0.1712249021,  0.3649542711,  &
0.6952753777,  0.2957866034,  &
0.1087861752,  0.0465193629,  &
0.8441683234,  0.5853966042,  &
0.6234608148,  0.7087506713,  &
0.0933081357,  0.6697880458,  &
0.3718095607,  0.3905806135,  &
0.8456798599,  0.5625304009,  &
0.1804642305,  0.4240076980,  &
0.5182768686,  0.7476032951,  &
0.9141044980,  0.8007207825,  &
0.5809939047,  0.3488284326,  &
0.6619077714,  0.5131369212,  &
0.7177887599,  0.3270688768,  &
0.0326304397,  0.4310183060,  &
0.0282125156,  0.4877935678,  &
0.0429581545,  0.8463797282,  &
0.1342768387,  0.5640304922,  &
0.6718226124,  0.0083371621,  &
0.7258205744,  0.4046630777,  &
0.4920000524,  0.0698398326,  &
0.2969945047,  0.7543433697,  &
0.8797765307,  0.8734134936,  &
0.4975768153,  0.7296109300,  &
0.6390997100,  0.7059372356,  &
0.7956256357,  0.0711428605,  &
0.2259922384,  0.8205791023,  &
0.3408086605,  0.7967743488,  &
0.7326628070,  0.9323468607,  &
0.4555214486,  0.6485123509,  &
0.6570578729,  0.0937787425,  &
0.0874251148,  0.2839254074,  &
0.8122852278,  0.2302706388,  &
0.4919638926,  0.0536065756,  &
0.5783648989,  0.2461041358,  &
0.5859208590,  0.3252520560,  &
0.1422660179,  0.7725027659,  &
0.9946960333,  0.9939436987,  &
0.1497278935,  0.6089904052,  &
0.6939765639,  0.4740318257,  &
0.7782653650,  0.5867293785,  &
0.0276189707,  0.8849927678,  &
0.6139397177,  0.1994827019,  &
0.5518504513,  0.7043680663,  &
0.0998659539,  0.9808482021,  &
0.0125039091,  0.7459193035,  &
0.9500090800,  0.4206320888,  &
0.4056246958,  0.6646937072,  &
0.4853221187,  0.7456285571,  &
0.0330645395,  0.9101666366,  &
0.1134807842,  0.8399074147,  &
0.6374511982,  0.8167080862,  &
0.5444138689,  0.8773711864,  &
0.2937712698,  0.1577459961,  &
0.9324040734,  0.6743692205,  &
0.0204537436,  0.1088636184,  &
0.3583562505,  0.7449245721,  &
0.0998812253,  0.0383567154,  &
0.4477148114,  0.1284247609,  &
0.6308531396,  0.9408595308,  &
0.8144818166,  0.3673928556,  &
0.3941473007,  0.5125496936,  &
0.7978548660,  0.6914653405,  &
0.7788155320,  0.9073426386,  &
0.9343839516,  0.9870460222,  &
0.2415784108,  0.5997082758,  &
0.3100330061,  0.3947402686,  &
0.3667292047,  0.3810479239,  &
0.8270434420,  0.4167978097,  &
0.8606746090,  0.8819721352,  &
0.2464533255,  0.5013533700,  &
0.9238287648,  0.3819791015,  &
0.8893564279,  0.6555993664,  &
0.4873665228,  0.9392180683,  &
0.8676767705,  0.7649886394,  &
0.2625004836,  0.9862773510,  &
0.3358814190,  0.3451832870,  &
0.2234136933,  0.8645819339,  &
0.3017776104,  0.8776372300,  &
0.6479492690,  0.2532863623,  &
0.4246860525,  0.6666767458,  &
0.2510768414,  0.2530247636,  &
0.3465708563,  0.2605235708,  &
0.8314541687,  0.8030979222,  &
0.4213711118,  0.0806990046,  &
0.2064966212,  0.2436000790,  &
0.5723103024,  0.5169160984,  &
0.4597977135,  0.0673267599,  &
0.0104978665,  0.6198641001,  &
0.5240566375,  0.8813723223,  &
0.6366855222,  0.0801888281,  &
0.1281490499,  0.1428784809,  &
0.1194543974,  0.7056188901,  &
0.6078169649,  0.7191171080,  &
0.8759886073,  0.2939499416,  &
0.1036604155,  0.0119566463,  &
0.0790430376,  0.8200065834,  &
0.6673202492,  0.4028397744,  &
0.9544413490,  0.8156747880,  &
0.3946660415,  0.0419262909,  &
0.5087017516,  0.4129040164,  &
0.7480045250,  0.9116029983,  &
0.7418378046,  0.0555360550,  &
0.1180467185,  0.6901289952,  &
0.8979635714,  0.9804194021,  &
0.6534177439,  0.7380852082,  &
0.6817327643,  0.4163115078,  &
0.8028266139,  0.2982279491,  &
0.4115968420,  0.3456371923,  &
0.2342733035,  0.4849281077,  &
0.7992760792,  0.3582212253,  &
0.9924859610,  0.2909836787,  &
0.3616129120,  0.9776333512,  &
0.5438015003,  0.4368062883,  &
0.7178394433,  0.5218802544,  &
0.4724969931,  0.8870552720,  &
0.1747939651,  0.0641543965,  &
0.3487500479,  0.0875692264,  &
0.7687201169,  0.1292953543,  &
0.0874833298,  0.3915526956,  &
0.7550537845,  0.6977442041,  &
0.0089752252,  0.2195813346,  &
0.0472152171,  0.9869424226,  &
0.6161231435,  0.2083041714,  &
0.2247570679,  0.0511745781,  &
0.5359774502,  0.2363434491,  &
0.4067201962,  0.5500336155,  &
0.2004402074,  0.1811239865,  &
0.7497906625,  0.8635950539,  &
0.2185656822,  0.8384186814,  &
0.6332496538,  0.5893281849,  &
0.5512342575,  0.6896015225,  &
0.9756987317,  0.9255939210,  &
0.5455190517,  0.9152281717,  &
0.1654870053,  0.0324803213,  &
0.5563197539,  0.2289405892,  &
0.6028248014,  0.0338817933,  &
0.1268637261,  0.6944936718,  &
0.0188933753,  0.4687111231,  &
0.8422926542,  0.8208126294,  &
0.0127340143,  0.9659772006,  &
0.3789557062,  0.8468829721,  &
0.9753204866,  0.5613151525,  &
0.4587899961,  0.2734826512,  &
0.9884978309,  0.4125540622,  &
0.7327554370,  0.8648235969,  &
0.4429483761,  0.6367005601,  &
0.5396580782,  0.1069407957,  &
0.5878929754,  0.0905778840,  &
0.1269066014,  0.0963519783,  &
0.7629799184,  0.6167927348,  &
0.6065598175,  0.5158207231,  &
0.6384614638,  0.3187438215,  &
0.5926091469,  0.7289990609,  &
0.2614517154,  0.8776223885,  &
0.6162077129,  0.5601895445,  &
0.1506529643,  0.1323143076,  &
0.3773302402,  0.0996418418,  &
0.2528699694,  0.0585019391,  &
0.1979883817,  0.6869831034,  &
0.0329050058,  0.0619257338,  &
0.8214870770,  0.5600903540,  &
0.1927023378,  0.8046661066,  &
0.5018675908,  0.8083116220,  &
0.7091833296,  0.9281812957,  &
0.9147789822,  0.5481432808,  &
0.3325022491,  0.4056749167,  &
0.8010044117,  0.7323877362,  &
0.1046328216,  0.6115899297,  &
0.8114511142,  0.4988771923,  &
0.5456160407,  0.1238166201,  &
0.7203934701,  0.5225027452,  &
0.5882366763,  0.8965455823,  &
0.5769132071,  0.7369337888,  &
0.0617568314,  0.4506498706,  &
0.4729800660,  0.6115556666,  &
0.8079576965,  0.4747310019,  &
0.4452934885,  0.0739005370,  &
0.9702414279,  0.8629962423,  &
0.2578611764,  0.9187594634,  &
0.6132014041,  0.3885720073,  &
0.1092032737,  0.1409455317,  &
0.3268169971,  0.7222188373,  &
0.2752087836,  0.8696907113,  &
0.0272143571,  0.8128515848,  &
0.1105111204,  0.7638352629,  &
0.9245717272,  0.9656634175,  &
0.4101463345,  0.5097427835,  &
0.8542105314,  0.9609493828,  &
0.5272138228,  0.4200674996,  &
0.1679184239,  0.5439921410,  &
0.7575166538,  0.8339041933,  &
0.2072770406,  0.1320336016,  &
0.6301641603,  0.2138680145,  &
0.2669013057,  0.6043669827,  &
0.8075423737,  0.0579647097,  &
0.5762220282,  0.1886689225,  &
0.9062952789,  0.6784191673,  &
0.0854833594,  0.3510353597,  &
0.2121497349,  0.0111340736,  &
0.4236638769,  0.5069700878,  &
0.2629502282,  0.9638324986,  &
0.7395758420,  0.0314673197,  &
0.2178661973,  0.1972744027,  &
0.1298541505,  0.4799544479,  &
0.4406313110,  0.5024155248,  &
0.1159572696,  0.3968188917,  &
0.9624793132,  0.1398104429,  &
0.5517347339,  0.1800973779,  &
0.6402420188,  0.0280087350,  &
0.9923203216,  0.6974626963,  &
0.1068804597,  0.1344392265,  &
0.0040469559,  0.0750458328,  &
0.1353135453,  0.9452658421,  &
0.4272200639,  0.8681194273,  &
0.3623615481,  0.4114570245,  &
0.5347640405,  0.8785456849,  &
0.1544651046,  0.6194592831,  &
0.6984263320,  0.6479261310,  &
0.5653231503,  0.2570955367,  &
0.3961097811,  0.0103145971,  &
0.6892821843,  0.0158362186,  &
0.0181770814,  0.0397639855,  &
0.6363836991,  0.4732877829,  &
0.1566263362,  0.7078675771,  &
0.2301920375,  0.6761900397,  &
0.0921947877,  0.7988179829,  &
0.4644396704,  0.9460097115,  &
0.6377391272,  0.5892107437,  &
0.6659996628,  0.5105619380,  &
0.3401117683,  0.5483781326,  &
0.1733456992,  0.2225824988,  &
0.8412266830,  0.3865055292,  &
0.8296818114,  0.3557218802,  &
0.0938364419,  0.7648821497,  &
0.9183364470,  0.6952985739,  &
0.2599273101,  0.3329955696,  &
0.4991669747,  0.7760993921,  &
0.3160204688,  0.0017791938,  &
0.3721190079,  0.3612415849,  &
0.2224417818,  0.2239241538,  &
0.6527987231,  0.1966134591,  &
0.0614161349,  0.7713577356,  &
0.7145900760,  0.7725616347,  &
0.3669135827,  0.8240687202,  &
0.5401918823,  0.3525856208,  &
0.3119653348,  0.7435605503,  &
0.7336888475,  0.7829338606,  &
0.9709099089,  0.3670923193,  &
0.2096716546,  0.6667279085,  &
0.4662963446,  0.6515942241,  &
0.8263895356,  0.5170601941,  &
0.8828001445,  0.8306398176,  &
0.4790901645,  0.3619437471,  &
0.7419264057,  0.9464962689,  &
0.0297565822,  0.9080688221,  &
0.1896526895,  0.7783409747,  &
0.5603715900,  0.7856399819,  &
0.8786339392,  0.5536214230,  &
0.6844942622,  0.8343158359,  &
0.7061951859,  0.8381670358,  &
0.9046352593,  0.0125050931,  &
0.1852315042,  0.2410380834,  &
0.7174867299,  0.4353414028,  &
0.0734356805,  0.3517905732,  &
0.1765381070,  0.5461050765,  &
0.0958602689,  0.2227831975,  &
0.7800737799,  0.4124436652,  &
0.2911401782,  0.6562101153,  &
0.8676313085,  0.3830067039,  &
0.1133134941,  0.2833634782,  &
0.6099359903,  0.9343954929,  &
0.2616857777,  0.5460774561,  &
0.1690914801,  0.6267970372,  &
0.9696577289,  0.4216084930,  &
0.2330704397,  0.3574090513,  &
0.3398952586,  0.0205318908,  &
0.2650088909,  0.3263281193,  &
0.9133907122,  0.1294836354,  &
0.6680903363,  0.9518628674,  &
0.6229519386,  0.1860238965,  &
0.5602505948,  0.0243907743,  &
0.7875114176,  0.6508424321,  &
0.2330918569,  0.1300401990,  &
0.7852528681,  0.4561830540,  &
0.5501466744,  0.2516157841,  &
0.1477198134,  0.0244811145,  &
0.1522461272,  0.1497911809,  &
0.7548885136,  0.6743089338,  &
0.0004421456,  0.4341811503,  &
0.1091316036,  0.9715156268,  &
0.2876177271,  0.7877748977,  &
0.7454943501,  0.9586400265,  &
0.5275591702,  0.4490265049,  &
0.4363712601,  0.6161526526,  &
0.5759970816,  0.4661262179,  &
0.2694594055,  0.0874022067,  &
0.4995825434,  0.8059574423,  &
0.8670121490,  0.4601404108,  &
0.2575734020,  0.1992695982,  &
0.6539310619,  0.5297923204,  &
0.5638123835,  0.5000007341,  &
0.2893947756,  0.7971234120,  &
0.7767499612,  0.0909481696,  &
0.6992753894,  0.8506927707,  &
0.2048989505,  0.5779747054,  &
0.6571932988,  0.3265453470,  &
0.8295631630,  0.9806657416,  &
0.0326296647,  0.4530016836,  &
0.3260959443,  0.9658808076,  &
0.1845694483,  0.3726865895,  &
0.0954355394,  0.1862413794,  &
0.9299045009,  0.3231344285,  &
0.4343361380,  0.8602576304,  &
0.8572428431,  0.5569317278,  &
0.6308073469,  0.4960696886,  &
0.1072279028,  0.2593546245,  &
0.3377344330,  0.9560176677,  &
0.0011016589,  0.5468584115,  &
0.5591039407,  0.6745378761,  &
0.5461641321,  0.5833354939,  &
0.0668380785,  0.0253754969,  &
0.1205944865,  0.8883084234,  &
0.9769182032,  0.4643041555,  &
0.9398345942,  0.7766809087,  &
0.7391262887,  0.7365684798,  &
0.3860495701,  0.2512049109,  &
0.2249845489,  0.0150519134,  &
0.7935453835,  0.5140810223,  &
0.3691431179,  0.2985118949,  &
0.3156455922,  0.3559129832,  &
0.2106942494,  0.3511704287,  &
0.0754286280,  0.0225364475,  &
0.8934125964,  0.8922227829,  &
0.2311603954,  0.9176519666,  &
0.3541109664,  0.8868380148,  &
0.0862199213,  0.8228052702,  &
0.6131240321,  0.6316777755,  &
0.2840409050,  0.6980437107,  &
0.3306999242,  0.1061131891,  &
0.9820674530,  0.3216111285,  &
0.9918050093,  0.0675418373,  &
0.3606509585,  0.3872263417,  &
0.6039421501,  0.3989259256,  &
0.5274135284,  0.9842137897,  &
0.3326160171,  0.6361331792,  &
0.3579915626,  0.8919686405,  &
0.9283592639,  0.2599734880,  &
0.3517242166,  0.4925911402,  &
0.8790006844,  0.2176867610,  &
0.8226131077,  0.0540677655,  &
0.4787219155,  0.6295602528,  &
0.5421733592,  0.0417727575,  &
0.5265606652,  0.5085158210,  &
0.5301350635,  0.4652613819,  &
0.6263593909,  0.7249807181,  &
0.7520066674,  0.9400206117,  &
0.4161060228,  0.6554825230,  &
0.6785972009,  0.1460696523,  &
0.9055119747,  0.3990386051,  &
0.9454812627,  0.7553825940,  &
0.6611497910,  0.7713130417,  &
0.7713503023,  0.8169814259,  &
0.0012532533,  0.0737852476,  &
0.8664645058,  0.4842738420,  &
0.0331991255,  0.7560245392,  &
0.1680087159,  0.7567762255,  &
0.0376528173,  0.2335344754,  &
0.9537132166,  0.8484006579,  &
0.4142728744,  0.9481223667,  &
0.0357323562,  0.7382194933,  &
0.4373559174,  0.8210110544,  &
0.8852398008,  0.6931684838,  &
0.9744351637,  0.8416729359,  &
0.8135710961,  0.8236174095,  &
0.8584155640,  0.9281676634,  &
0.6527424596,  0.1186467475,  &
0.1382835064,  0.9444440068,  &
0.0179061874,  0.9997911974 /)

      random_array(5001:10000) = (/ 0.5462664593,  0.4169194343,  &
0.4548542431,  0.7071950475,  &
0.0529973717,  0.5768664384,  &
0.5116044513,  0.3475810639,  &
0.7711814723,  0.8321805110,  &
0.0643256561,  0.7312060721,  &
0.7558547324,  0.2840457242,  &
0.8032330220,  0.9503369741,  &
0.0213496477,  0.4694641064,  &
0.4923230206,  0.2011185571,  &
0.5725100566,  0.8852609047,  &
0.4671333522,  0.3969005225,  &
0.0485916098,  0.7087322546,  &
0.7541749523,  0.7449721168,  &
0.1340392755,  0.4975772513,  &
0.1209091635,  0.5427169023,  &
0.0684864957,  0.1711165265,  &
0.4803489928,  0.2027575523,  &
0.7937884245,  0.8585336434,  &
0.8600517539,  0.3372167711,  &
0.4722610411,  0.6092669861,  &
0.1128834184,  0.7540959125,  &
0.2839948656,  0.3546119497,  &
0.4519549632,  0.4654408051,  &
0.5499495288,  0.5865744114,  &
0.8683710834,  0.5622978179,  &
0.2314326774,  0.9446831154,  &
0.7649163245,  0.6903998018,  &
0.0503566952,  0.1873224169,  &
0.8557237126,  0.8474184430,  &
0.6627146218,  0.9295169666,  &
0.3803138404,  0.6335470606,  &
0.4554986271,  0.6461034752,  &
0.7710388736,  0.1603233040,  &
0.3861629533,  0.3570171346,  &
0.8415855634,  0.1370351309,  &
0.2081703238,  0.5064080219,  &
0.9989401959,  0.5622428039,  &
0.2800351847,  0.1119948192,  &
0.7232460699,  0.1800848597,  &
0.1620485798,  0.0113621998,  &
0.8214736455,  0.7559766991,  &
0.8743624890,  0.7361744431,  &
0.9663639344,  0.0346815570,  &
0.1407588258,  0.8806591190,  &
0.6669522718,  0.4619243737,  &
0.6577015261,  0.4524518676,  &
0.4872087529,  0.8762067141,  &
0.7676364674,  0.8131455342,  &
0.2361709236,  0.3829665540,  &
0.0844158277,  0.9390052560,  &
0.2400651069,  0.5759182630,  &
0.2300399846,  0.4708261755,  &
0.8429763800,  0.0331614661,  &
0.5355018525,  0.5052762286,  &
0.4053442200,  0.0648299043,  &
0.4694808358,  0.8085087117,  &
0.1598710195,  0.9052110981,  &
0.8132092517,  0.9446119444,  &
0.3993094005,  0.5554015956,  &
0.3589803650,  0.7771534556,  &
0.1174193802,  0.2785825562,  &
0.9059194416,  0.3784490959,  &
0.0992010021,  0.4644488361,  &
0.1132614724,  0.9773494217,  &
0.8224998013,  0.7195595074,  &
0.8455992608,  0.1014390208,  &
0.2435388445,  0.2284450607,  &
0.3306894726,  0.6517830213,  &
0.2004523088,  0.6851177067,  &
0.1774006139,  0.4950903565,  &
0.2603256291,  0.6917109999,  &
0.1956178751,  0.1752156392,  &
0.9281629644,  0.6676579682,  &
0.7217853815,  0.1417559857,  &
0.7421871466,  0.7676485906,  &
0.8653098413,  0.2105666101,  &
0.9335315784,  0.9283155749,  &
0.6272577805,  0.9914367590,  &
0.7392212392,  0.4134490019,  &
0.1753812417,  0.8224520330,  &
0.6979603017,  0.3319732641,  &
0.6991423275,  0.4673644282,  &
0.4332398113,  0.9410133409,  &
0.0324291960,  0.2370707960,  &
0.3097977679,  0.7634440270,  &
0.8832988306,  0.5222405734,  &
0.4252678914,  0.6628192756,  &
0.2407735830,  0.7769255803,  &
0.7569307315,  0.5436732871,  &
0.5185577533,  0.1711397699,  &
0.8456275521,  0.3980495573,  &
0.8213068570,  0.1987501577,  &
0.3089434244,  0.5346958186,  &
0.8958239773,  0.9228361195,  &
0.9061173009,  0.0276851582,  &
0.6594446150,  0.3523567313,  &
0.4372627576,  0.6926221556,  &
0.6137009621,  0.7554927503,  &
0.7335610128,  0.0706263748,  &
0.9984752652,  0.3428266788,  &
0.7211467166,  0.8651161856,  &
0.8264143860,  0.1401393841,  &
0.5534565105,  0.9185512196,  &
0.6182630473,  0.6711477593,  &
0.2464888566,  0.5103221606,  &
0.9655233911,  0.8780007847,  &
0.1285890115,  0.8286791816,  &
0.2881151502,  0.2569508615,  &
0.3796080524,  0.4646961337,  &
0.3405933145,  0.4817110404,  &
0.1754651234,  0.5538569876,  &
0.8576082402,  0.5159524294,  &
0.1243041043,  0.3604062329,  &
0.6524426165,  0.5325710720,  &
0.9874358070,  0.8589533223,  &
0.3485804059,  0.3885672547,  &
0.5451669435,  0.2530382068,  &
0.5913556375,  0.8833825034,  &
0.1240499459,  0.3885131527,  &
0.6657187426,  0.9311612153,  &
0.3444750965,  0.0467142187,  &
0.8768131845,  0.4778403332,  &
0.0488025079,  0.2786258247,  &
0.2407220685,  0.7080745662,  &
0.6140761493,  0.4882606008,  &
0.7426224456,  0.7934435818,  &
0.9062765350,  0.7782996003,  &
0.7330153219,  0.3313192819,  &
0.5941098064,  0.4381184550,  &
0.9300533566,  0.7112706974,  &
0.2182882020,  0.0120392895,  &
0.2576213525,  0.0761274309,  &
0.1926942932,  0.3587670751,  &
0.8932210899,  0.5503528626,  &
0.1761975865,  0.2186242944,  &
0.7496450397,  0.8107625962,  &
0.7099978655,  0.4464775725,  &
0.3792302437,  0.1254164477,  &
0.5594195438,  0.0464579789,  &
0.7680310872,  0.1499296476,  &
0.2880837917,  0.9296853260,  &
0.0607061360,  0.1005288638,  &
0.0767848980,  0.4866756472,  &
0.1280865505,  0.5620766619,  &
0.9998748803,  0.3581301546,  &
0.7795487582,  0.0444075004,  &
0.4259315082,  0.5981331657,  &
0.3658055970,  0.6058144701,  &
0.0978427393,  0.0129336172,  &
0.2872403479,  0.9403972124,  &
0.8728381201,  0.8463657066,  &
0.0721059770,  0.1175355245,  &
0.8243009756,  0.4519670036,  &
0.8701450335,  0.9239198597,  &
0.7929766168,  0.7170685476,  &
0.2353563855,  0.2763783010,  &
0.4666166822,  0.9906767356,  &
0.5339176316,  0.2266828759,  &
0.8622533128,  0.7398777709,  &
0.6803323224,  0.0904116436,  &
0.8284727950,  0.8418621090,  &
0.1855906692,  0.1163536393,  &
0.3558385188,  0.6701667596,  &
0.4426603184,  0.4440960590,  &
0.0109351892,  0.6892361646,  &
0.4823538773,  0.8085415738,  &
0.6786976325,  0.6596826653,  &
0.2838076103,  0.7272878643,  &
0.8818485372,  0.3176889646,  &
0.7720419364,  0.0955030283,  &
0.0173820766,  0.8143333888,  &
0.8656991673,  0.4579976385,  &
0.9009926225,  0.5542842428,  &
0.2456884823,  0.9805584287,  &
0.7459394951,  0.2821791758,  &
0.8775130766,  0.1368104807,  &
0.3240752014,  0.4287274578,  &
0.1530263517,  0.5034260496,  &
0.6821071832,  0.8798239862,  &
0.5526504225,  0.3835375258,  &
0.9810505281,  0.7861727585,  &
0.7378750775,  0.0565066140,  &
0.3731055937,  0.2932811108,  &
0.1727760007,  0.1470566941,  &
0.7783634585,  0.3236077450,  &
0.2361736475,  0.9417846721,  &
0.2820310708,  0.4484741233,  &
0.6650418589,  0.5356018485,  &
0.8104439622,  0.6692137890,  &
0.5218199435,  0.3416688524,  &
0.2023326849,  0.0921578727,  &
0.6970649674,  0.8941933770,  &
0.6760290941,  0.9130448678,  &
0.6250049566,  0.5567285748,  &
0.8508985589,  0.2988348534,  &
0.6777128408,  0.7923612799,  &
0.4250134538,  0.0222974992,  &
0.6989660319,  0.0803723638,  &
0.4276112792,  0.0261180345,  &
0.9007224666,  0.2142308411,  &
0.5742530453,  0.8032480170,  &
0.2080829033,  0.9513606795,  &
0.2770846940,  0.7887979432,  &
0.6087999979,  0.8890470031,  &
0.7592378147,  0.3040998485,  &
0.1347152751,  0.3151795872,  &
0.5433948547,  0.7807472061,  &
0.8690463762,  0.5273577329,  &
0.2839811841,  0.7581999326,  &
0.8704242056,  0.5234749392,  &
0.4741115402,  0.8641050576,  &
0.3610664436,  0.3391477337,  &
0.1564711291,  0.2424470881,  &
0.7734471428,  0.1837336952,  &
0.6401923439,  0.3446430182,  &
0.4333275480,  0.6224230084,  &
0.8023475948,  0.9391391820,  &
0.3232684418,  0.0152832947,  &
0.6310560876,  0.0863139763,  &
0.3654328270,  0.8566790067,  &
0.9189175346,  0.6215992264,  &
0.7302079383,  0.2794584733,  &
0.1253414650,  0.4642009580,  &
0.5856337344,  0.2105317798,  &
0.4276125816,  0.8645651091,  &
0.3621057449,  0.7119821783,  &
0.2636411290,  0.0026558681,  &
0.5285407308,  0.7760572478,  &
0.2146411844,  0.4083727665,  &
0.6327446670,  0.7166603503,  &
0.5159479481,  0.2918447793,  &
0.4826448319,  0.2796509937,  &
0.6486676323,  0.5134194051,  &
0.1425518672,  0.4855238119,  &
0.5536820079,  0.6107315486,  &
0.4111062509,  0.3481775968,  &
0.8135007392,  0.3983383237,  &
0.1576102948,  0.5618895116,  &
0.7065679195,  0.4149944620,  &
0.6515144533,  0.4601964103,  &
0.3184990563,  0.5948518024,  &
0.2653337622,  0.7019569301,  &
0.2895088852,  0.0086554139,  &
0.3873389826,  0.6258729873,  &
0.2377517836,  0.0077736557,  &
0.6579052218,  0.8655573851,  &
0.7853469647,  0.8026491020,  &
0.2253078019,  0.0776706332,  &
0.3236731221,  0.3379560157,  &
0.0545755252,  0.7885033455,  &
0.3814363758,  0.9004391307,  &
0.9137844817,  0.1103093340,  &
0.2818524900,  0.6979562289,  &
0.0102327422,  0.2328310830,  &
0.7179407339,  0.3844421931,  &
0.3644155210,  0.8618468525,  &
0.4115212527,  0.8503183383,  &
0.5004496847,  0.3586056145,  &
0.7249337135,  0.4607557771,  &
0.6044458473,  0.6204412271,  &
0.3567440201,  0.0628939220,  &
0.4589201558,  0.9996261299,  &
0.5295941889,  0.0946215970,  &
0.3565624490,  0.9660200209,  &
0.7323496240,  0.9002969623,  &
0.8696630030,  0.0412272184,  &
0.2828279399,  0.7196340571,  &
0.1345031587,  0.9483062611,  &
0.0999449400,  0.3421624626,  &
0.6296978159,  0.7791849369,  &
0.3652935401,  0.9247096754,  &
0.3983179858,  0.4518739116,  &
0.8708249768,  0.2703394768,  &
0.2480622700,  0.4498270819,  &
0.1633342871,  0.2489519512,  &
0.9704372001,  0.1699359493,  &
0.3487407060,  0.7388417877,  &
0.9549447779,  0.7952069677,  &
0.0333119165,  0.5503943444,  &
0.3559030880,  0.8091039148,  &
0.4378293193,  0.6608505195,  &
0.4530436641,  0.3960344796,  &
0.2159842760,  0.9481113693,  &
0.7633354451,  0.7527633880,  &
0.2102968616,  0.6977164227,  &
0.5371611968,  0.6925531412,  &
0.5334959750,  0.6142153687,  &
0.6003886382,  0.3676760121,  &
0.7711985582,  0.7462509614,  &
0.3924696651,  0.2060863494,  &
0.2194966364,  0.6484006296,  &
0.7456903688,  0.5008493425,  &
0.8723206359,  0.9105679169,  &
0.9178575829,  0.2544912458,  &
0.8767997666,  0.7899474636,  &
0.1816203460,  0.5472879243,  &
0.0708503358,  0.7765812074,  &
0.6393792690,  0.6686854768,  &
0.2388981312,  0.7253414797,  &
0.9817429197,  0.1703093278,  &
0.4262291938,  0.7804150987,  &
0.2698128377,  0.3824119687,  &
0.7703501760,  0.5039573197,  &
0.4715474080,  0.7383566985,  &
0.0658868458,  0.6400087496,  &
0.8813921787,  0.9521690674,  &
0.4045267150,  0.9423372284,  &
0.9982745659,  0.6757219232,  &
0.3163985504,  0.7366812852,  &
0.7331392680,  0.7084930288,  &
0.1034524832,  0.8340497299,  &
0.4407134832,  0.0159834997,  &
0.2106075242,  0.0774995758,  &
0.2961069678,  0.6606703044,  &
0.7568426124,  0.5840055546,  &
0.8215740393,  0.5970046999,  &
0.3354420115,  0.9699355717,  &
0.4803781316,  0.2551345157,  &
0.0917405368,  0.5799793412,  &
0.2004857038,  0.0660181247,  &
0.2602993893,  0.6592226192,  &
0.0873145607,  0.5929224555,  &
0.0652897461,  0.7414081053,  &
0.2812824277,  0.1604872404,  &
0.1381831682,  0.4651947390,  &
0.6381419862,  0.7560053053,  &
0.8578972892,  0.0132126407,  &
0.7729487500,  0.0147619877,  &
0.9113196264,  0.3190499214,  &
0.8330910853,  0.7287969578,  &
0.7290534793,  0.3369191061,  &
0.5389500682,  0.4319629994,  &
0.5672568116,  0.3993783489,  &
0.4362822434,  0.9362629096,  &
0.1575104921,  0.3437207351,  &
0.2170648403,  0.8774542723,  &
0.4880893857,  0.6906639843,  &
0.9937414270,  0.4741335534,  &
0.0753274641,  0.7495042488,  &
0.1038853975,  0.0279688152,  &
0.7571245071,  0.7189275999,  &
0.4486087735,  0.7585323456,  &
0.1393576398,  0.4812472542,  &
0.2805621008,  0.0967761954,  &
0.3931257194,  0.6586658850,  &
0.8780812755,  0.9434753659,  &
0.0266405289,  0.6270767709,  &
0.8196301500,  0.2949760598,  &
0.9898550431,  0.6833682386,  &
0.8790952607,  0.6432355569,  &
0.6408227593,  0.3132044434,  &
0.8882405249,  0.8529996756,  &
0.0179801034,  0.3301534480,  &
0.6091200676,  0.4803541587,  &
0.1674181445,  0.9691397185,  &
0.0050841895,  0.5449319212,  &
0.9936412317,  0.2069823158,  &
0.5326941494,  0.6074879579,  &
0.1041078934,  0.6503255343,  &
0.9433503218,  0.1577863909,  &
0.2274161068,  0.5886640518,  &
0.0449063406,  0.3896042052,  &
0.1394223538,  0.2675174593,  &
0.8553930164,  0.2386580856,  &
0.3430989745,  0.0510530995,  &
0.7240721848,  0.0932173224,  &
0.6787220753,  0.6823988933,  &
0.4917707428,  0.6926370478,  &
0.5685045752,  0.2790841153,  &
0.5530640008,  0.7775647301,  &
0.7979159340,  0.9666449894,  &
0.8742121982,  0.2263846326,  &
0.4188072019,  0.3020705805,  &
0.6532020668,  0.6726174868,  &
0.2037231223,  0.9083006087,  &
0.9221302952,  0.4414201655,  &
0.8860552568,  0.0350711496,  &
0.2348757165,  0.8534883292,  &
0.9399882873,  0.1500455422,  &
0.6418840188,  0.5755800133,  &
0.5659797966,  0.4885369345,  &
0.8163818085,  0.1455519484,  &
0.4821555958,  0.4163117028,  &
0.2754533226,  0.4346026990,  &
0.2819940489,  0.5033719921,  &
0.8886306193,  0.7720207036,  &
0.0541981822,  0.5019659970,  &
0.3589485513,  0.9896404897,  &
0.4611809123,  0.6880370190,  &
0.9102686538,  0.1311584710,  &
0.9213024243,  0.6339859679,  &
0.2544581510,  0.9590558967,  &
0.9157227790,  0.4094793337,  &
0.8586494254,  0.2792523891,  &
0.5131684516,  0.0480586465,  &
0.3611081921,  0.2286024729,  &
0.7003068183,  0.7282889455,  &
0.8058865315,  0.1099281095,  &
0.0504989786,  0.1553972879,  &
0.5044158386,  0.8064365067,  &
0.8637834991,  0.5149573297,  &
0.5251089487,  0.0497512933,  &
0.7147666576,  0.0004795317,  &
0.4188516759,  0.1318920944,  &
0.4528372792,  0.1620358544,  &
0.9324982751,  0.8908186127,  &
0.8498895002,  0.7806050239,  &
0.3702828284,  0.5525432897,  &
0.2163949492,  0.0404657116,  &
0.7763511306,  0.3538085476,  &
0.5366847185,  0.6304881663,  &
0.2307689454,  0.7608484033,  &
0.3792202803,  0.0609219124,  &
0.4384722738,  0.5775024190,  &
0.5876581060,  0.5477095419,  &
0.2003755761,  0.2461106896,  &
0.1173294498,  0.7872869981,  &
0.4192833738,  0.4277982826,  &
0.3942466994,  0.2902483465,  &
0.8754970608,  0.7715848971,  &
0.3054134763,  0.1625532494,  &
0.9408918641,  0.7311713760,  &
0.4092225298,  0.2437272812,  &
0.8523995770,  0.5827714915,  &
0.5938239723,  0.4561778039,  &
0.7759084190,  0.9447031836,  &
0.3143669320,  0.7386181287,  &
0.4627379108,  0.3936227441,  &
0.0524926171,  0.4235703156,  &
0.8396383929,  0.8919616053,  &
0.6171628825,  0.6764462013,  &
0.2682919249,  0.8889481181,  &
0.8704585924,  0.9539754190,  &
0.1694240727,  0.0284449849,  &
0.0060538482,  0.5171487430,  &
0.9464208181,  0.3081457639,  &
0.7978400718,  0.3557226972,  &
0.3266825131,  0.0330334566,  &
0.9632022886,  0.5913037240,  &
0.8166720312,  0.3856921595,  &
0.5309905985,  0.0489278803,  &
0.0873958662,  0.6851141896,  &
0.7631388101,  0.1548610548,  &
0.3661269151,  0.1154486889,  &
0.8947074745,  0.9327940156,  &
0.0810276856,  0.0713613919,  &
0.1035350030,  0.7124795717,  &
0.5427241320,  0.5547469146,  &
0.0095248254,  0.1405166050,  &
0.7309298794,  0.1885209340,  &
0.4682580617,  0.1216789804,  &
0.6875106499,  0.6970022625,  &
0.4100575081,  0.2909268222,  &
0.7028756257,  0.4982724895,  &
0.4549295745,  0.0541117279,  &
0.3407648232,  0.7647039780,  &
0.5420095215,  0.2881441730,  &
0.3506911565,  0.1738136933,  &
0.4959740594,  0.7728772840,  &
0.7148104386,  0.6263665286,  &
0.3768522718,  0.5579474685,  &
0.7811408740,  0.0690002401,  &
0.3758217045,  0.7171065729,  &
0.7988537060,  0.1090675618,  &
0.8264195748,  0.8083053241,  &
0.4114688511,  0.2205669999,  &
0.8109416125,  0.1441042488,  &
0.8828573769,  0.8477003290,  &
0.4134094781,  0.7437567782,  &
0.4681626179,  0.3405267179,  &
0.3549425247,  0.2734426176,  &
0.2988940220,  0.9692851926,  &
0.7518197006,  0.7150593928,  &
0.7351694929,  0.5301267601,  &
0.8539230526,  0.8492580509,  &
0.6841977779,  0.9113463707,  &
0.2840491938,  0.6854498777,  &
0.3040680505,  0.7471157394,  &
0.2284471063,  0.6894490046,  &
0.7609167752,  0.5451783464,  &
0.1196197263,  0.3282941467,  &
0.1346603151,  0.4234364325,  &
0.2518932664,  0.5833544041,  &
0.6971322433,  0.1562098182,  &
0.8249662608,  0.2676332611,  &
0.5471109574,  0.4788536452,  &
0.6985080846,  0.3889535378,  &
0.6143774447,  0.2201700570,  &
0.8636954806,  0.9933025094,  &
0.4823951321,  0.0441846959,  &
0.2223864683,  0.6675380751,  &
0.6964302632,  0.9326061083,  &
0.6089812586,  0.0734563482,  &
0.6715949346,  0.5800662394,  &
0.1935953850,  0.3229801760,  &
0.3447578135,  0.0218032511,  &
0.8815895601,  0.0882080045,  &
0.3289999149,  0.9639239670,  &
0.9813011434,  0.2780184122,  &
0.8099215282,  0.4844840683,  &
0.8323246713,  0.4087376213,  &
0.4924624907,  0.0771437419,  &
0.3648899315,  0.1395128642,  &
0.7929431772,  0.2781292274,  &
0.3978251805,  0.3005258488,  &
0.7573229136,  0.8115101282,  &
0.2648097991,  0.5093043911,  &
0.7644824883,  0.5960170684,  &
0.8840690178,  0.9269122656,  &
0.7963307765,  0.5182631706,  &
0.7286871326,  0.9022315418,  &
0.2907775221,  0.5306841097,  &
0.8787165337,  0.1450508296,  &
0.0917763016,  0.8390986216,  &
0.0495137529,  0.3287518474,  &
0.2880148538,  0.1855999171,  &
0.2332529883,  0.7439513203,  &
0.5790819495,  0.2485930090,  &
0.7331843491,  0.4881673264,  &
0.1597955877,  0.4535973551,  &
0.4160619456,  0.8296082149,  &
0.0004150051,  0.4817966712,  &
0.3779737794,  0.5802902401,  &
0.4497068204,  0.7631738915,  &
0.7743366822,  0.8788696823,  &
0.4391374459,  0.3740158852,  &
0.2810468127,  0.1431399479,  &
0.7612963883,  0.4675376588,  &
0.7567051279,  0.6980114031,  &
0.5922125941,  0.9808469181,  &
0.0805274203,  0.9103453359,  &
0.4179173217,  0.1020245021,  &
0.6383171127,  0.8996607493,  &
0.1849917034,  0.8163541530,  &
0.6870546485,  0.3529900852,  &
0.7377019400,  0.2046412468,  &
0.7412737726,  0.4472837624,  &
0.8307484062,  0.5413220703,  &
0.5064455599,  0.3599920852,  &
0.8690457798,  0.0041813024,  &
0.8241527435,  0.5454926428,  &
0.5721869814,  0.6644002431,  &
0.0362524287,  0.4491401971,  &
0.3741616230,  0.7318714427,  &
0.3010219524,  0.7045312840,  &
0.5884396073,  0.9007024015,  &
0.3527945530,  0.0734975700,  &
0.5084620482,  0.8911431642,  &
0.8815767692,  0.5228276350,  &
0.9415881533,  0.1661450706,  &
0.1166820771,  0.8333473353,  &
0.7451800079,  0.8724030531,  &
0.5805799812,  0.7863051048,  &
0.5875511815,  0.0876862297,  &
0.8420048025,  0.9241078626,  &
0.6370434048,  0.7358274280,  &
0.6390387212,  0.1332747412,  &
0.2293455238,  0.2977841498,  &
0.2273594966,  0.6234961100,  &
0.6816188300,  0.0516366930,  &
0.8963277294,  0.5225204377,  &
0.5630681197,  0.0224998177,  &
0.2991516329,  0.9781174000,  &
0.5882628903,  0.0342628237,  &
0.2233651069,  0.7730116985,  &
0.5771872375,  0.6915142734,  &
0.4260138969,  0.8472323130,  &
0.9935575490,  0.9451069855,  &
0.5670354839,  0.2052986757,  &
0.1783854935,  0.8666495389,  &
0.3555762139,  0.5120085375,  &
0.2552753466,  0.6495419195,  &
0.9291140350,  0.5365285449,  &
0.6063202299,  0.0385589503,  &
0.6029640979,  0.5162161310,  &
0.1101731246,  0.6579324353,  &
0.6267886414,  0.9177869041,  &
0.9922591137,  0.0524849997,  &
0.8362245694,  0.7210773311,  &
0.5932305662,  0.2281785018,  &
0.3889856005,  0.2023405217,  &
0.3398254880,  0.7085595124,  &
0.9260052544,  0.0010208693,  &
0.5613285830,  0.9098410241,  &
0.0716518109,  0.5928209776,  &
0.2259991844,  0.5862046774,  &
0.2890134624,  0.8950462881,  &
0.5121295311,  0.2939788821,  &
0.4359056357,  0.7131948781,  &
0.5832241004,  0.8567934252,  &
0.9398022008,  0.5546393266,  &
0.4110902120,  0.7318940154,  &
0.1016343244,  0.8564542008,  &
0.6973616117,  0.6235871074,  &
0.9561074685,  0.0505067234,  &
0.6548242648,  0.1198505481,  &
0.6868117106,  0.4206994462,  &
0.5588818246,  0.4003266563,  &
0.8912744061,  0.8665920236,  &
0.4725849745,  0.2997830010,  &
0.8348119641,  0.5599881467,  &
0.4121734338,  0.2592220607,  &
0.8499146618,  0.8615391691,  &
0.8763116594,  0.0679751452,  &
0.5572811310,  0.0147152930,  &
0.8529157539,  0.6025190799,  &
0.9329045646,  0.7725973684,  &
0.1853159206,  0.2122204304,  &
0.3018077412,  0.1194514553,  &
0.7467957968,  0.6485970251,  &
0.0712936189,  0.9897097817,  &
0.8712026261,  0.9421732394,  &
0.0512763198,  0.3461800825,  &
0.5607504286,  0.1878724148,  &
0.8256096605,  0.2126295059,  &
0.0036781457,  0.1918469840,  &
0.3189078117,  0.3522058522,  &
0.3543623953,  0.9922310736,  &
0.1780762877,  0.9526692732,  &
0.6008131838,  0.9893651349,  &
0.1582772906,  0.8162123553,  &
0.0730324875,  0.4370934784,  &
0.1641490187,  0.9829980355,  &
0.7914634215,  0.1286051871,  &
0.9662018782,  0.0298256928,  &
0.0654798640,  0.1465714065,  &
0.0317266134,  0.6185493327,  &
0.2590918941,  0.2398208548,  &
0.3770280370,  0.2746712945,  &
0.2198398795,  0.8697456461,  &
0.1107822445,  0.3197236508,  &
0.3328382305,  0.6584538640,  &
0.7350454298,  0.7584491196,  &
0.8387382517,  0.5301047608,  &
0.8165313530,  0.7885468949,  &
0.3596261932,  0.2160400363,  &
0.0620802589,  0.7203798854,  &
0.3715297662,  0.4252701304,  &
0.2566747567,  0.3623995985,  &
0.8743147985,  0.4287287515,  &
0.2550852910,  0.9551583167,  &
0.8011070134,  0.6327312502,  &
0.3739005339,  0.4441644472,  &
0.1268643410,  0.3222596924,  &
0.8212325024,  0.4820108031,  &
0.2327206521,  0.3533811780,  &
0.6891828624,  0.4523033291,  &
0.6941967463,  0.9562764344,  &
0.8022016475,  0.2445432060,  &
0.5001849300,  0.3792478057,  &
0.0494267354,  0.9147935372,  &
0.1697707257,  0.1246828482,  &
0.2028657410,  0.6537856573,  &
0.6703417885,  0.2333911114,  &
0.9545939468,  0.4555097740,  &
0.7839812311,  0.5224598606,  &
0.6056948771,  0.1885492234,  &
0.7260910415,  0.6684940137,  &
0.3183029450,  0.9877755815,  &
0.5111004380,  0.4800854015,  &
0.5973843015,  0.7866798361,  &
0.9415544074,  0.2671181258,  &
0.0013511743,  0.2828041852,  &
0.6285351575,  0.4557509802,  &
0.2745920621,  0.0226626326,  &
0.4763441485,  0.9828575047,  &
0.2279302754,  0.7541948140,  &
0.8035070481,  0.3347867371,  &
0.8442459009,  0.9832566301,  &
0.8216847299,  0.7749783561,  &
0.3430495579,  0.5596867671,  &
0.3862350173,  0.5811482026,  &
0.1300656945,  0.9569429284,  &
0.9785709779,  0.8480022991,  &
0.4602517907,  0.8654863901,  &
0.0413621000,  0.5031099691,  &
0.5637967352,  0.7169250736,  &
0.9620871375,  0.4228661225,  &
0.9975726329,  0.6216877295,  &
0.9099695352,  0.6874893478,  &
0.6500811584,  0.7527434580,  &
0.5472167720,  0.4084950523,  &
0.8209306878,  0.3039928255,  &
0.3867996063,  0.9012443929,  &
0.2434641367,  0.4468419525,  &
0.3727586072,  0.3014648521,  &
0.1974265396,  0.6037934367,  &
0.6368752473,  0.4676528421,  &
0.5855847510,  0.5401873119,  &
0.2780589030,  0.6680038979,  &
0.1416230432,  0.7925545668,  &
0.2364498959,  0.4445537405,  &
0.9159254641,  0.2624343863,  &
0.5141296962,  0.2838867100,  &
0.6551955629,  0.0366718892,  &
0.8281290755,  0.6627504528,  &
0.0465346337,  0.1065287467,  &
0.0256196858,  0.6139705186,  &
0.8020089162,  0.4424646346,  &
0.9386397694,  0.4017556598,  &
0.6346480345,  0.2231828932,  &
0.7331172427,  0.2590236236,  &
0.3042323701,  0.9205301058,  &
0.6847267521,  0.2470921984,  &
0.7236299726,  0.9390908120,  &
0.9641626932,  0.9264054858,  &
0.3255597310,  0.7970366808,  &
0.5279146382,  0.0178448598,  &
0.4688495477,  0.1414768010,  &
0.2995852075,  0.6973441079,  &
0.4264120166,  0.9601636052,  &
0.7210991330,  0.4747615798,  &
0.1592597135,  0.0335099684,  &
0.5341770555,  0.8029026032,  &
0.1685571698,  0.9082285251,  &
0.9550337716,  0.9307231609,  &
0.3341137019,  0.0094743040,  &
0.1725161474,  0.1140661670,  &
0.0757767981,  0.9447312965,  &
0.9215795540,  0.8151109930,  &
0.2804725221,  0.8323398758,  &
0.0793648066,  0.2193816403,  &
0.3297728064,  0.4388245770,  &
0.5366368662,  0.9228554763,  &
0.0356638486,  0.9099960462,  &
0.3566032960,  0.8442179666,  &
0.4847913857,  0.6355118685,  &
0.3105649675,  0.0945151921,  &
0.3590776116,  0.7360961604,  &
0.5685346052,  0.6087446668,  &
0.0193409601,  0.8022966327,  &
0.6925520757,  0.3185331672,  &
0.7477614129,  0.5981742583,  &
0.3040316452,  0.3568941164,  &
0.7420184718,  0.0082964161,  &
0.8613654726,  0.0190253869,  &
0.1742215213,  0.2082515326,  &
0.0667423175,  0.7557320931,  &
0.6638825236,  0.5547139884,  &
0.3554170995,  0.9119823765,  &
0.0241083787,  0.1095310395,  &
0.8071069112,  0.6205918951,  &
0.4948274186,  0.4528855464,  &
0.0445456314,  0.3336549408,  &
0.7916459396,  0.6587481652,  &
0.6827820831,  0.6696836424,  &
0.6484294697,  0.0074229240,  &
0.2842037357,  0.4202302286,  &
0.6468426725,  0.2214613669,  &
0.0456859398,  0.4060126154,  &
0.9944455663,  0.7473316897,  &
0.5196206581,  0.0619276327,  &
0.3947128285,  0.0062542617,  &
0.0390393620,  0.3991951438,  &
0.9931088326,  0.6682814091,  &
0.9156127952,  0.6598578472,  &
0.6580778718,  0.5514344379,  &
0.2625754301,  0.0872963040,  &
0.7641660784,  0.2669384492,  &
0.8011901726,  0.6887169744,  &
0.3379102655,  0.7472459650,  &
0.1296967854,  0.5793036754,  &
0.4130519082,  0.6550784199,  &
0.3214960465,  0.6045809421,  &
0.1095528466,  0.1756216562,  &
0.3407616054,  0.2123718152,  &
0.2782231894,  0.9976035418,  &
0.0028406247,  0.9806773200,  &
0.2006960729,  0.7410091334,  &
0.6545351172,  0.6052399684,  &
0.9884929889,  0.5775669223,  &
0.1248980910,  0.5563371149,  &
0.7439066126,  0.2452700807,  &
0.9079577870,  0.1952096384,  &
0.6221454980,  0.6535900693,  &
0.2209814875,  0.4786750654,  &
0.6100531963,  0.1031801428,  &
0.3218663876,  0.6496574258,  &
0.8494740220,  0.7345986899,  &
0.4976395177,  0.7505451994,  &
0.2219671951,  0.8612942904,  &
0.0018194111,  0.7697277777,  &
0.6589048765,  0.4631391084,  &
0.1369589994,  0.8036857541,  &
0.2275486768,  0.2911344495,  &
0.7833565352,  0.9419912952,  &
0.1299538954,  0.0825367019,  &
0.9091563155,  0.4625923983,  &
0.4421611008,  0.6138710487,  &
0.4581067505,  0.0400348730,  &
0.6012767177,  0.8629028295,  &
0.3528177444,  0.2167939114,  &
0.3103216355,  0.8350385416,  &
0.9020044734,  0.1083077403,  &
0.6067474125,  0.1321286750,  &
0.5529868410,  0.5888613590,  &
0.0330972434,  0.4848899058,  &
0.8774125257,  0.2773237414,  &
0.2652688032,  0.7124587465,  &
0.0090697278,  0.9165816715,  &
0.3537478109,  0.5378546263,  &
0.0629478551,  0.1628424403,  &
0.7998559235,  0.2156786469,  &
0.7188638083,  0.3712608142,  &
0.8680263973,  0.5618650726,  &
0.7423256200,  0.4041939676,  &
0.4758196773,  0.0821613420,  &
0.2345661115,  0.0854658912,  &
0.1425442586,  0.7847246511,  &
0.6692896063,  0.3859377549,  &
0.1309322929,  0.9109922282,  &
0.6698460059,  0.4583405804,  &
0.7462478105,  0.5983703286,  &
0.9823867749,  0.4123235018,  &
0.7804971354,  0.5855859853,  &
0.1640121288,  0.2975234731,  &
0.4416831339,  0.9120258608,  &
0.7716254815,  0.1349285062,  &
0.9691753978,  0.7903828071,  &
0.3554826251,  0.3791948243,  &
0.6322897305,  0.9364936202,  &
0.7592249995,  0.6141072605,  &
0.2755558912,  0.8729092931,  &
0.7429812144,  0.4547951412,  &
0.7455356205,  0.6635210210,  &
0.9798414409,  0.5648566740,  &
0.9500307954,  0.2518112858,  &
0.0121903102,  0.9839760878,  &
0.8704461707,  0.5154316782,  &
0.9883246029,  0.0832293105,  &
0.8451119834,  0.9895106040,  &
0.0106067603,  0.4103811007,  &
0.7167523165,  0.4675103138,  &
0.9607421906,  0.0350323348,  &
0.2382385071,  0.6331580759,  &
0.7173273552,  0.5051153047,  &
0.0219773273,  0.4551298419,  &
0.6522391104,  0.1404004366,  &
0.2834432286,  0.8840008822,  &
0.9982693496,  0.3208147910,  &
0.4909936892,  0.8626389120,  &
0.6385659150,  0.1409875237,  &
0.6533560260,  0.0544590113,  &
0.2330391891,  0.7690791799,  &
0.2228497601,  0.8092170292,  &
0.5124171453,  0.8957531421,  &
0.2938819462,  0.4617475146,  &
0.5484905834,  0.6847478165,  &
0.7484055385,  0.0083230872,  &
0.3996059056,  0.8569395659,  &
0.7173464604,  0.7291492944,  &
0.9637260134,  0.6635677208,  &
0.6146805143,  0.3808039972,  &
0.7916235836,  0.9352608714,  &
0.3764942940,  0.5499907041,  &
0.0899255817,  0.3180314605,  &
0.0684479405,  0.2799850020,  &
0.0751331951,  0.1518903197,  &
0.8678655467,  0.5594097941,  &
0.9640594755,  0.5140269289,  &
0.9058806063,  0.0418771979,  &
0.8249623909,  0.4896657171,  &
0.1833840222,  0.1900863747,  &
0.3579484949,  0.4562101651,  &
0.9461040090,  0.6490459351,  &
0.3764347811,  0.0866926239,  &
0.4095501785,  0.3378334528,  &
0.1023712611,  0.1347239793,  &
0.1967481268,  0.9612795918,  &
0.5831371751,  0.6116633871,  &
0.6042669468,  0.1901243032,  &
0.9501671137,  0.4397714838,  &
0.0033439104,  0.4595317320,  &
0.2782879132,  0.4083332206,  &
0.0115960808,  0.4217631525,  &
0.4146438875,  0.6628722554,  &
0.3453850655,  0.4395382749,  &
0.7898696843,  0.9105241260,  &
0.6675815324,  0.5760017714,  &
0.8103962872,  0.5802424442,  &
0.7287749784,  0.3544618173,  &
0.2250265955,  0.4304401391,  &
0.8386772627,  0.9640102594,  &
0.6861205886,  0.4159816725,  &
0.2921912789,  0.1469438729,  &
0.7477944225,  0.9797808082,  &
0.6274070407,  0.8421172411,  &
0.0135033709,  0.0875585824,  &
0.0575124850,  0.6405536057,  &
0.8481337252,  0.1582451051,  &
0.3022647185,  0.0383950998,  &
0.6107183749,  0.4637034908,  &
0.6468834072,  0.3701425652,  &
0.3317647203,  0.4981262365,  &
0.8544580682,  0.5980611165,  &
0.0974063963,  0.4057010706,  &
0.1891908128,  0.4679299252,  &
0.2166339681,  0.1007359420,  &
0.0088085181,  0.3183514844,  &
0.1926081012,  0.0421486346,  &
0.3768032284,  0.0876817144,  &
0.3541300566,  0.1436291752,  &
0.2420122924,  0.4688554572,  &
0.1450527279,  0.2707855870,  &
0.5175496261,  0.0124408305,  &
0.6534177311,  0.7795387545,  &
0.7285649130,  0.6062151184,  &
0.2552034846,  0.4293762809,  &
0.2320069887,  0.6075543758,  &
0.5206864970,  0.8603037359,  &
0.9792207664,  0.2855061150,  &
0.0179256222,  0.0115719277,  &
0.6955551702,  0.4596914717,  &
0.3254461147,  0.0790678518,  &
0.4517729862,  0.6969684308,  &
0.1684623454,  0.9764748752,  &
0.9235006931,  0.1715800629,  &
0.3030567180,  0.7454228815,  &
0.5105278530,  0.6403197668,  &
0.3403048120,  0.5163773889,  &
0.2571420905,  0.8117988700,  &
0.6245064454,  0.0464141378,  &
0.6276850920,  0.7745835381,  &
0.8246282831,  0.3964247162,  &
0.7487955472,  0.0627640906,  &
0.2666592187,  0.8439547632,  &
0.1527099262,  0.4758502590,  &
0.7990231546,  0.0153498250,  &
0.2270822098,  0.6877652998,  &
0.3545204683,  0.9943788056,  &
0.0488111636,  0.6261080809,  &
0.9416262844,  0.9796054479,  &
0.5298347679,  0.0313297821,  &
0.7441703954,  0.6659187484,  &
0.7419452238,  0.6550063082,  &
0.3806134614,  0.3472512232,  &
0.3142032664,  0.4094376512,  &
0.5383024199,  0.2272680718,  &
0.5767599638,  0.6467146501,  &
0.8277944911,  0.1470683733,  &
0.7138948626,  0.8494208505,  &
0.0267704571,  0.6337571400,  &
0.4790170061,  0.7059482085,  &
0.7993174921,  0.2869040581,  &
0.9593121627,  0.7469496798,  &
0.2102424147,  0.2429413584,  &
0.5784860653,  0.0556614377,  &
0.5184649406,  0.9989477944,  &
0.2516515030,  0.3999908467,  &
0.9100087567,  0.3750083179,  &
0.0146704781,  0.0685981569,  &
0.2110792779,  0.2414501307,  &
0.7243795871,  0.3395846224,  &
0.1892817940,  0.2897422220,  &
0.4396004944,  0.7318204391,  &
0.2160506192,  0.2144526611,  &
0.7762456042,  0.6546222775,  &
0.9748441684,  0.0499851298,  &
0.5222327308,  0.7184658082,  &
0.0067262757,  0.0725382209,  &
0.4033285038,  0.9452229888,  &
0.2637869386,  0.2884506701,  &
0.9459683441,  0.3573142341,  &
0.9386905572,  0.6982844405,  &
0.7194508919,  0.1190139351,  &
0.8503954756,  0.1362636478,  &
0.2074051237,  0.8896115445,  &
0.7999277500,  0.5855241674,  &
0.9436535844,  0.3103849024,  &
0.7524128349,  0.8904434836,  &
0.1164049110,  0.5581252250,  &
0.1174152325,  0.5543976193,  &
0.9872162560,  0.0866104210,  &
0.6966274454,  0.3924789938,  &
0.2212240689,  0.3543759115,  &
0.2309709008,  0.7730284304,  &
0.8551859336,  0.6766570765,  &
0.0544393851,  0.0518922009,  &
0.7152087182,  0.5159302971,  &
0.1118817749,  0.3892436077,  &
0.9061846568,  0.4724972835,  &
0.9936039396,  0.9848064872,  &
0.6011070987,  0.1984246131,  &
0.0966212298,  0.7328665948,  &
0.7033290544,  0.0704786798,  &
0.8505109172,  0.2570383368,  &
0.7540158403,  0.6040812399,  &
0.8395449194,  0.8567567933,  &
0.7164236130,  0.6293359112,  &
0.1035027986,  0.1071427115,  &
0.8601597458,  0.0616020068,  &
0.3513824157,  0.6931559641,  &
0.3578315272,  0.1571045985,  &
0.5969791865,  0.2273613178,  &
0.2144146510,  0.0641668800,  &
0.2237032788,  0.4287830567,  &
0.6926334438,  0.5469389479,  &
0.2153507020,  0.5130125265,  &
0.6656177216,  0.3187740187,  &
0.7381613708,  0.2068952514,  &
0.4314730923,  0.7544629692,  &
0.3926679324,  0.2101665202,  &
0.2809430851,  0.8053042985,  &
0.1190982858,  0.8116143570,  &
0.2363983872,  0.5006625441,  &
0.5095112080,  0.7764328537,  &
0.7623586338,  0.2288230609,  &
0.1253859958,  0.3345923642,  &
0.4094174407,  0.7245653208,  &
0.6154310920,  0.2645828980,  &
0.6036936422,  0.7612221747,  &
0.4296484889,  0.9088402645,  &
0.1830848260,  0.5617987168,  &
0.7376038056,  0.0851986610,  &
0.7637840384,  0.0613664584,  &
0.9218408727,  0.0882654954,  &
0.0891076975,  0.2542070705,  &
0.4795955468,  0.4656537205,  &
0.5697744195,  0.3431023494,  &
0.9508166435,  0.4238463146,  &
0.4888676405,  0.3631252917,  &
0.8876549133,  0.4798370148,  &
0.0171763418,  0.1937006650,  &
0.2304827058,  0.3824012019,  &
0.9982443390,  0.3178952088,  &
0.7328810526,  0.8875740154,  &
0.5661991130,  0.5276197091,  &
0.3646734587,  0.9604055886,  &
0.9687332069,  0.7386667766,  &
0.9780210314,  0.0632646857,  &
0.2939844012,  0.8683338336,  &
0.1995981102,  0.0983761545,  &
0.4529296973,  0.2068023661,  &
0.3197786901,  0.2213307347,  &
0.6056890902,  0.2482440977,  &
0.9952702980,  0.1371551641,  &
0.0489159640,  0.8143431334,  &
0.2031539061,  0.0015841235,  &
0.3740712432,  0.8942305585,  &
0.1312805099,  0.7333671813,  &
0.8150721658,  0.2150734167,  &
0.6342424945,  0.7219990831,  &
0.0242157960,  0.4809600476,  &
0.7923713535,  0.8449218903,  &
0.0544441868,  0.4279215006,  &
0.3590238258,  0.1838947613,  &
0.9042998083,  0.1359787007,  &
0.8185305046,  0.7367028440,  &
0.2166166137,  0.4365498142,  &
0.1304052742,  0.8369450323,  &
0.0730214308,  0.1337989823,  &
0.7791380245,  0.5614720206,  &
0.0137137320,  0.4941961303,  &
0.2071739157,  0.0672178441,  &
0.2653912300,  0.6553378032,  &
0.7363118114,  0.3739845451,  &
0.7220309977,  0.8761152103,  &
0.7075589577,  0.0554320598,  &
0.8374154679,  0.7553562768,  &
0.0758985562,  0.6895545827,  &
0.5791676232,  0.5368248070,  &
0.6991704027,  0.6585039678,  &
0.6309191431,  0.1905366712,  &
0.8567762341,  0.1079199772,  &
0.2166193836,  0.0720456179,  &
0.7966295032,  0.8679265655,  &
0.8651794432,  0.8075859125,  &
0.4996164808,  0.6275097227,  &
0.2898926034,  0.1784534303,  &
0.1405176774,  0.0463365664,  &
0.8115632690,  0.7907425691,  &
0.3216023445,  0.7707849146,  &
0.3235481003,  0.4189411154,  &
0.1931082166,  0.8274935743,  &
0.0882619890,  0.0129588923,  &
0.4247478623,  0.4892047861,  &
0.7892428110,  0.0955109552,  &
0.4532665915,  0.2608936885,  &
0.0193740626,  0.1762313888,  &
0.5705366622,  0.0163626302,  &
0.3965414313,  0.6957397664,  &
0.2170310046,  0.5523672848,  &
0.5432906083,  0.2458303893,  &
0.7069573046,  0.9505992552,  &
0.2629717184,  0.6816409087,  &
0.1229125724,  0.7712999456,  &
0.5141610233,  0.4308741846,  &
0.8618400733,  0.6191186334,  &
0.3613080728,  0.9191683679,  &
0.1890986736,  0.8779908423,  &
0.0240955950,  0.1112973071,  &
0.2436649113,  0.9416474699,  &
0.5109909487,  0.3633943160,  &
0.4729364955,  0.5346822215,  &
0.3321376417,  0.9167115170,  &
0.1399898527,  0.6761447844,  &
0.7389333462,  0.1333091219,  &
0.6044705567,  0.0385543867,  &
0.1372855790,  0.1166333258,  &
0.6825281176,  0.6723273661,  &
0.5078014554,  0.5893426596,  &
0.5971320228,  0.5692106942,  &
0.1685866281,  0.7490202849,  &
0.1808320417,  0.6986053775,  &
0.0553522425,  0.2136462765,  &
0.9241142270,  0.0697287850,  &
0.0843559755,  0.6492898082,  &
0.1430435719,  0.4928327193,  &
0.7313640670,  0.1239370661,  &
0.9756714722,  0.8776713457,  &
0.8476743442,  0.7402098106,  &
0.3305999338,  0.4109735179,  &
0.4943701371,  0.4994844309,  &
0.6585984496,  0.6223123388,  &
0.2608979650,  0.0491036664,  &
0.9298495541,  0.8261489548,  &
0.4245273467,  0.8254517848,  &
0.7447282670,  0.1719539011,  &
0.9078239575,  0.9516559389,  &
0.1632974030,  0.4775539255,  &
0.8311788758,  0.0048970701,  &
0.8669407928,  0.1529094751,  &
0.0518947378,  0.3000160796,  &
0.9887352103,  0.3976414291,  &
0.3590138691,  0.7873544507,  &
0.7176568350,  0.1772404050,  &
0.5595000081,  0.9756772611,  &
0.0534308115,  0.0095109564,  &
0.8779548823,  0.8585586388,  &
0.8695774476,  0.8693419913,  &
0.4322873881,  0.1104003185,  &
0.5641794186,  0.5596914453,  &
0.0206351782,  0.6434443157,  &
0.4577800414,  0.3840677759,  &
0.6554659834,  0.1468134911,  &
0.9766746929,  0.6093645948,  &
0.8494410814,  0.4773140224,  &
0.3898640382,  0.1938899777,  &
0.9211841671,  0.6448169917,  &
0.7268278111,  0.6118583488,  &
0.1920809991,  0.6271128661,  &
0.8630609328,  0.3467994534,  &
0.0639898582,  0.2137348756,  &
0.1126027099,  0.4404203193,  &
0.1552125528,  0.5548212062,  &
0.1716163260,  0.2057822272,  &
0.8986301181,  0.0006007530,  &
0.4676138409,  0.7349134969,  &
0.7985915905,  0.0172109290,  &
0.7890233420,  0.9816520082,  &
0.6084026570,  0.2877359843,  &
0.8531815031,  0.9672448113,  &
0.6192846742,  0.2622200222,  &
0.3405133587,  0.5488108995,  &
0.4547898097,  0.3982044458,  &
0.9620872479,  0.4280820846,  &
0.2133078882,  0.5456942828,  &
0.6513111575,  0.7363245375,  &
0.5393855063,  0.6527138347,  &
0.6176192098,  0.8260196070,  &
0.2053202824,  0.4745250410,  &
0.8161318331,  0.1260470915,  &
0.1009660742,  0.9529580566,  &
0.7767057490,  0.7101578614,  &
0.3876184916,  0.5469075264,  &
0.6911164032,  0.4201184783,  &
0.4375287701,  0.1870147564,  &
0.2311785835,  0.7590274400,  &
0.4917344077,  0.2446699065,  &
0.6566447996,  0.9219481272,  &
0.7618014276,  0.7925309715,  &
0.5430735457,  0.0590916309,  &
0.0877664395,  0.0768792973,  &
0.3402550778,  0.5472685605,  &
0.5741783132,  0.1175959759,  &
0.0632126311,  0.3602924377,  &
0.4579667122,  0.6644881003,  &
0.2613968274,  0.4333922108,  &
0.4558991424,  0.9699916809,  &
0.0690227358,  0.8093325537,  &
0.1885099923,  0.5711385350,  &
0.8582467219,  0.5245971245,  &
0.5715658647,  0.4217595398,  &
0.4082902253,  0.4169090372,  &
0.8023281725,  0.3500531115,  &
0.4458356144,  0.6986284438,  &
0.0773188392,  0.3649764963,  &
0.2077280532,  0.4151199752,  &
0.8221461674,  0.6572077923,  &
0.8368500913,  0.8746306827,  &
0.2233211202,  0.9268457046,  &
0.6846588864,  0.2285919534,  &
0.6187255515,  0.6015013300,  &
0.0831380176,  0.8151396519,  &
0.3735495080,  0.2113606572,  &
0.0730533620,  0.2147247618,  &
0.9630712268,  0.4373591155,  &
0.9088112428,  0.8415534720,  &
0.7266744862,  0.8626343975,  &
0.3735368143,  0.8814851791,  &
0.2497141836,  0.4892719431,  &
0.8677371761,  0.1110079402,  &
0.4363483973,  0.4344578928,  &
0.0897007432,  0.7864007246,  &
0.8361693558,  0.2683850320,  &
0.9598193966,  0.7896696857,  &
0.2177993552,  0.2122855282,  &
0.8616910321,  0.5272711056,  &
0.0314335619,  0.3664092523,  &
0.4075594431,  0.5718303810,  &
0.6092285395,  0.4671429043,  &
0.2780049295,  0.3060905925,  &
0.0912547371,  0.1878540355,  &
0.7756629810,  0.0098874927,  &
0.4157631489,  0.0760228858,  &
0.6228342445,  0.6935563222,  &
0.0135274163,  0.9659925722,  &
0.0642588864,  0.3191482978,  &
0.5759100610,  0.7414827968,  &
0.6917154833,  0.7194806222,  &
0.3415854955,  0.4287047447,  &
0.4959054120,  0.1463303752,  &
0.5650857980,  0.6890234118,  &
0.9921774099,  0.8078476017,  &
0.3672629667,  0.9997813415,  &
0.4118444254,  0.3508167557,  &
0.7847709767,  0.7080755388,  &
0.4403280310,  0.6713415020,  &
0.7501177113,  0.2627042123,  &
0.2460000741,  0.1365725407,  &
0.2422419463,  0.7395692038,  &
0.8089851613,  0.2663613467,  &
0.9278058408,  0.8386628624,  &
0.6778051106,  0.4602011705,  &
0.9028101221,  0.6905619683,  &
0.4246757097,  0.1431113296,  &
0.1624057917,  0.0193780837,  &
0.4560814794,  0.4192584616,  &
0.6496506823,  0.0193285241,  &
0.7961187246,  0.4341806598,  &
0.5421036991,  0.8763339726,  &
0.3158435137,  0.6629004904,  &
0.7789538382,  0.8876001217,  &
0.2425979884,  0.1895362885,  &
0.0455739835,  0.2865872762,  &
0.8029659156,  0.1346059426,  &
0.9845493321,  0.6964703905,  &
0.3675549321,  0.0774107445,  &
0.9912327450,  0.4405346921,  &
0.0882215846,  0.8902514449,  &
0.0450786220,  0.4092146871,  &
0.1733996934,  0.4420882465,  &
0.4351084415,  0.1138839844,  &
0.6062813127,  0.5372241615,  &
0.6355642738,  0.9073165829,  &
0.1278429220,  0.6128995905,  &
0.9593658401,  0.6823579598,  &
0.3183299486,  0.1772699387,  &
0.1256611760,  0.7174965003,  &
0.9357600443,  0.6851622009,  &
0.4256202586,  0.9653155509,  &
0.5183326024,  0.4616333496,  &
0.0925955958,  0.1964364369,  &
0.5877052572,  0.5375720781,  &
0.9832292461,  0.9497383026,  &
0.7648244965,  0.4130693399,  &
0.7701219335,  0.1439840754,  &
0.9921238827,  0.8043969254,  &
0.1844626588,  0.9969390676,  &
0.9323227046,  0.4577006112,  &
0.6601375376,  0.2498455083,  &
0.7286917022,  0.1100264659,  &
0.2060873402,  0.2515370578,  &
0.4392817484,  0.1812508623,  &
0.0310205629,  0.2284397138,  &
0.9703810541,  0.3278701648,  &
0.1593939200,  0.5731443218,  &
0.1724718825,  0.8655542079,  &
0.2095502179,  0.1924487449,  &
0.7032235520,  0.0046886042,  &
0.9800524219,  0.8813379298,  &
0.4386154041,  0.8010737808,  &
0.2046594007,  0.6609668254,  &
0.4744724164,  0.4131399218,  &
0.3461877631,  0.6237013958,  &
0.1185802933,  0.7821492288,  &
0.7472621970,  0.2004283931,  &
0.7088014358,  0.6405289955,  &
0.2556624178,  0.0569115346,  &
0.6166573817,  0.4924720430,  &
0.2667810399,  0.1601175303,  &
0.9679162618,  0.6971105153,  &
0.4232488879,  0.5169732117,  &
0.2765043814,  0.5027039274,  &
0.3286709938,  0.3495819955,  &
0.4074036377,  0.3724240493,  &
0.9346692698,  0.6011792738,  &
0.3010664133,  0.6997425242,  &
0.7828775330,  0.9768619276,  &
0.6652659504,  0.0794982971,  &
0.6373021316,  0.7560575982,  &
0.0659502288,  0.3755839699,  &
0.7373791945,  0.4386732387,  &
0.0319429676,  0.8422541459,  &
0.9523040863,  0.6053033810,  &
0.3475773967,  0.4858032043,  &
0.5754335160,  0.9310817105,  &
0.1208377507,  0.4362500978,  &
0.4613139972,  0.8600423903,  &
0.5956521451,  0.5931231513,  &
0.4423051529,  0.0870181022,  &
0.2401272561,  0.6463581462,  &
0.4544698864,  0.9590603434,  &
0.3451480198,  0.2490445962,  &
0.1312426495,  0.2903636655,  &
0.3708037961,  0.9631897677,  &
0.3306704874,  0.4913243954,  &
0.1176197751,  0.2196894385,  &
0.6163673692,  0.3286778371,  &
0.0244553726,  0.9028819211,  &
0.2835773295,  0.3606788714,  &
0.5261344328,  0.4216078911,  &
0.4106818850,  0.9427896614,  &
0.8290540609,  0.5039048359,  &
0.7737556406,  0.1119773809,  &
0.9153662731,  0.3071411684,  &
0.5082264996,  0.3384595633,  &
0.2894517272,  0.8899935893,  &
0.0566452299,  0.3525134328,  &
0.3806922856,  0.3421487703,  &
0.8132239162,  0.6708877629,  &
0.5848608796,  0.9749831315,  &
0.3029376084,  0.8628304568,  &
0.5253518093,  0.5150898784,  &
0.6638792837,  0.1495401144,  &
0.4949998930,  0.8624899094,  &
0.1092341251,  0.4307684736,  &
0.8872178718,  0.8645580577,  &
0.7449499368,  0.3847060385,  &
0.3246958934,  0.9292734993,  &
0.9404057285,  0.3447922769,  &
0.4357195828,  0.1943121873,  &
0.4338655973,  0.9246724536,  &
0.1177226062,  0.5628168189,  &
0.9162397161,  0.0048116784,  &
0.7928470738,  0.0721909193,  &
0.6159349204,  0.6992086213,  &
0.1100590166,  0.3201224308,  &
0.2622140113,  0.2553424180,  &
0.0632075100,  0.9859955971,  &
0.0735083537,  0.8242531486,  &
0.2538454641,  0.1831214144,  &
0.6418613875,  0.8336348318,  &
0.0085703700,  0.2810234848,  &
0.1802632251,  0.7134741573,  &
0.6253035710,  0.9194858155,  &
0.2813331570,  0.2037798882,  &
0.2688116853,  0.3135750877,  &
0.1466438497,  0.4348221976,  &
0.6142339137,  0.0180346409,  &
0.5624749894,  0.0049224589,  &
0.9659657607,  0.7454204825,  &
0.4425654551,  0.1373783048,  &
0.6284295304,  0.4624680536,  &
0.7109081120,  0.6399392555,  &
0.8857715336,  0.7621970824,  &
0.0379341003,  0.0743717845,  &
0.2585491373,  0.2949979524,  &
0.8222758137,  0.7560163192,  &
0.1575367843,  0.7438371167,  &
0.1724040319,  0.3816795774,  &
0.9745170858,  0.6661531995,  &
0.8552500244,  0.7202741897,  &
0.2734983755,  0.2038155354,  &
0.1864908750,  0.1773353935,  &
0.5581714468,  0.5518474894,  &
0.3492222038,  0.1638274013,  &
0.1629107777,  0.5594532420,  &
0.8801902636,  0.8503211311,  &
0.0283141339,  0.2185313943,  &
0.9930803756,  0.9012994311,  &
0.5547400468,  0.8064961662,  &
0.0974889944,  0.6619512561,  &
0.0520386022,  0.2058106825,  &
0.5782521788,  0.2353660933,  &
0.8314757977,  0.7323898962,  &
0.6603834950,  0.2867752460,  &
0.3661101802,  0.4094257073,  &
0.0145782655,  0.3759117700,  &
0.1743522842,  0.3912470289,  &
0.3042594135,  0.2486649833,  &
0.4100072406,  0.2526932476,  &
0.3394136532,  0.7197970164,  &
0.2333446979,  0.3075520159,  &
0.4404201108,  0.3059433758,  &
0.8022564848,  0.5186554593,  &
0.4092572467,  0.2322029845,  &
0.3714084940,  0.6720248177,  &
0.1079693595,  0.4853561824,  &
0.2443969451,  0.2352001086,  &
0.2451337785,  0.5562286368,  &
0.4673266635,  0.0240208271,  &
0.2256733644,  0.6580061233,  &
0.3994562640,  0.6740048050,  &
0.7851603494,  0.5376084295,  &
0.6276199252,  0.0424950872,  &
0.7419779281,  0.4329071440,  &
0.4148095674,  0.9317511469,  &
0.4535768779,  0.3516375616,  &
0.6107848905,  0.0820082868,  &
0.6382886610,  0.7159215844,  &
0.7938302670,  0.5142088591,  &
0.8828578239,  0.2898104090,  &
0.4540460680,  0.8534898151,  &
0.5960236101,  0.7958077939,  &
0.6020420256,  0.4537336988,  &
0.6945012344,  0.6856474766,  &
0.4058729940,  0.6797110589,  &
0.8575719455,  0.4314492268,  &
0.8366902950,  0.7818768961,  &
0.7285556507,  0.0925406856,  &
0.1310304297,  0.9550208407,  &
0.9268596635,  0.2960746639,  &
0.0456103007,  0.1391457007,  &
0.6399760163,  0.0272937563,  &
0.7622948445,  0.9880818160,  &
0.8747709563,  0.0677443972,  &
0.2039906965,  0.0609179201,  &
0.3539675155,  0.0155745159,  &
0.6515227662,  0.1467801576,  &
0.1379576586,  0.8259016773,  &
0.2549377498,  0.0184995516,  &
0.6794908827,  0.5196807402,  &
0.7298793822,  0.6476737652,  &
0.8707755470,  0.1948131024,  &
0.2669447698,  0.7095300615,  &
0.6116894937,  0.0963890068,  &
0.1605962273,  0.9315187466,  &
0.3830392152,  0.9529749798,  &
0.0679898332,  0.7143818541,  &
0.9388577550,  0.8634694976,  &
0.5422284674,  0.7155564695,  &
0.5108057760,  0.8815182213,  &
0.4812713345,  0.8106376724,  &
0.6532417049,  0.4757594199,  &
0.4848796105,  0.6823456949,  &
0.6263969811,  0.0100088730,  &
0.8234357613,  0.2708414273,  &
0.1102864281,  0.8685523476,  &
0.9726569430,  0.9075828868,  &
0.9927717764,  0.7068568927,  &
0.4874636553,  0.3149859786,  &
0.4839849150,  0.7878905085,  &
0.1256530520,  0.7830909988,  &
0.0312602073,  0.6127436833,  &
0.3515358937,  0.9849404860,  &
0.2984769017,  0.5939713218,  &
0.0782393189,  0.0121611839,  &
0.3481806532,  0.7765096368,  &
0.1065007140,  0.2866247798,  &
0.6192040455,  0.2388666680,  &
0.9585767208,  0.6815854308,  &
0.7056198993,  0.9707451926,  &
0.0708044489,  0.8378900579,  &
0.3086740193,  0.1919431248,  &
0.4007520880,  0.1265305990,  &
0.6966684017,  0.4429814471,  &
0.1997411471,  0.2891222415,  &
0.9444292999,  0.6953592702,  &
0.8762978001,  0.6083500798,  &
0.2810084827,  0.4623180900,  &
0.7051621245,  0.3743622064,  &
0.3936610964,  0.5177087921,  &
0.7232477659,  0.3751704303,  &
0.6271460218,  0.2207184536,  &
0.6333121654,  0.9270314020,  &
0.2662813965,  0.9788200913,  &
0.4873311734,  0.9330674386,  &
0.6847744938,  0.2948549986,  &
0.3000458334,  0.3837503421,  &
0.3891954049,  0.0498694909,  &
0.0140491166,  0.1435700303,  &
0.1413121008,  0.0206639193,  &
0.6057005294,  0.4962978978,  &
0.1797425991,  0.3833951829,  &
0.0367721046,  0.6467391724,  &
0.5281873190,  0.8422939829,  &
0.9566214351,  0.6936353591,  &
0.9975439738,  0.9329020649,  &
0.2203405402,  0.5604617820,  &
0.7473579821,  0.0390685037,  &
0.8149134551,  0.3477489436,  &
0.1352245507,  0.5429015440,  &
0.1412306741,  0.1591577296,  &
0.6159047177,  0.1661821309,  &
0.1388902217,  0.0927186421,  &
0.6605989171,  0.5785044695,  &
0.1467302718,  0.3588258654,  &
0.1960045695,  0.0384590132,  &
0.6141655791,  0.7837176833,  &
0.2477369915,  0.3704631571,  &
0.2771359096,  0.5746017602,  &
0.4411110138,  0.4741631142,  &
0.3817245166,  0.9675938992,  &
0.6170541521,  0.8261242692,  &
0.2622627789,  0.5113549141,  &
0.5998344832,  0.7344015234,  &
0.4191378647,  0.2873292150,  &
0.4706741470,  0.5779538266,  &
0.7689379903,  0.3903410910,  &
0.8876321835,  0.7764222561,  &
0.4239688461,  0.1044184291,  &
0.8104032115,  0.4918614428,  &
0.7055558985,  0.2148646311,  &
0.2822952320,  0.0104748850,  &
0.9251817129,  0.9724686700,  &
0.4629553664,  0.4974361796,  &
0.9810760876,  0.1406352510,  &
0.0954993038,  0.1743512625,  &
0.5395969739,  0.3336137271,  &
0.6808205548,  0.3828407973,  &
0.6566743086,  0.3107574418,  &
0.6214478873,  0.7330887195,  &
0.5881498471,  0.7274733314,  &
0.9331948850,  0.0438935097,  &
0.4645575208,  0.7728008188,  &
0.4310232406,  0.2180283174,  &
0.3131972809,  0.1979114609,  &
0.4425472826,  0.5006793287,  &
0.5210596176,  0.6139309054,  &
0.2913685556,  0.5416951118,  &
0.0653461180,  0.5329599900,  &
0.3893227182,  0.5402608876,  &
0.3192269101,  0.7343821993,  &
0.5485296187,  0.6561184234,  &
0.0138754363,  0.7417405027,  &
0.0531997346,  0.0366678429,  &
0.5427216387,  0.2590681927,  &
0.1801490075,  0.7566168806,  &
0.9352159750,  0.2263583420,  &
0.6053916544,  0.4898489515,  &
0.1317448122,  0.6594198484,  &
0.6403264951,  0.6296060296,  &
0.0441350082,  0.3785121520,  &
0.7850383631,  0.2886360955,  &
0.5677791861,  0.0557652039,  &
0.6449601628,  0.1635906479,  &
0.5253484038,  0.9865512228,  &
0.3435221765,  0.4968286703,  &
0.4039351533,  0.4406716046,  &
0.4754751056,  0.0719896536,  &
0.2068171161,  0.2654987266,  &
0.2470453479,  0.1057948601,  &
0.5957962180,  0.9571107214,  &
0.0748461615,  0.6454357057,  &
0.8308500928,  0.7408226175,  &
0.0093197103,  0.1198528526,  &
0.7878323285,  0.5087075520,  &
0.4530115751,  0.0976356192,  &
0.5064068968,  0.1420214910,  &
0.0844442721,  0.5939282748,  &
0.2991699208,  0.3031067921,  &
0.4686641433,  0.5419721424,  &
0.3642814796,  0.2875149958,  &
0.6183835828,  0.1334415853,  &
0.1767503005,  0.0407517913,  &
0.4935465445,  0.0149195614,  &
0.9636055658,  0.9260116736,  &
0.4547418756,  0.8466035613,  &
0.9755753284,  0.7572579014,  &
0.2554962369,  0.3780133465,  &
0.9098084719,  0.9036041209,  &
0.7209804913,  0.9470331159,  &
0.3340669474,  0.5650561819,  &
0.3505518020,  0.9042067200,  &
0.3114162354,  0.5093102414,  &
0.4592524123,  0.4391672777,  &
0.5725304235,  0.8064855772,  &
0.4687569535,  0.2499645015,  &
0.4321793156,  0.9271895368,  &
0.4329345597,  0.7801841919,  &
0.8968710499,  0.3557949007,  &
0.4130211404,  0.7323414349,  &
0.9061670774,  0.3274453987,  &
0.1834203520,  0.3197883339,  &
0.9444368986,  0.0224810653,  &
0.0586080706,  0.3556092126,  &
0.5413489052,  0.4032831913,  &
0.1507035239,  0.1121638727,  &
0.9580675428,  0.6371794069,  &
0.6183934890,  0.9063321467,  &
0.7203844541,  0.9075210883,  &
0.9859819687,  0.1722198695,  &
0.7848138219,  0.0748093425,  &
0.1070931391,  0.1704586681,  &
0.7229323161,  0.5858942557,  &
0.1240106858,  0.9766754885,  &
0.1350224889,  0.9868103787,  &
0.8764906198,  0.9574660721,  &
0.9195925284,  0.1585712832,  &
0.1076601508,  0.9983325484,  &
0.5723406845,  0.8857566277,  &
0.1575344266,  0.5281365899,  &
0.0157001899,  0.2641450877,  &
0.7898006562,  0.5544597073,  &
0.6458538535,  0.6317399083,  &
0.6649467484,  0.4077640026,  &
0.9568423015,  0.4599840517,  &
0.8022668943,  0.9707384378,  &
0.5834226864,  0.4566783301,  &
0.4095859953,  0.8158790228,  &
0.2867909490,  0.3545130209,  &
0.3279135981,  0.6251515087,  &
0.6261999400,  0.7983612486,  &
0.5805550702,  0.6841586031,  &
0.7573667643,  0.0731885827,  &
0.5359337001,  0.1836326576,  &
0.4670763000,  0.3235214026,  &
0.7145118718,  0.4183740332,  &
0.5159807182,  0.7659448520,  &
0.7587583306,  0.8127021619,  &
0.2939613707,  0.1803276324,  &
0.8046878571,  0.1472553064,  &
0.1601734788,  0.8234448437,  &
0.5657530668,  0.7319174688,  &
0.8450037821,  0.9104191092,  &
0.6319668159,  0.6628169687,  &
0.6355967500,  0.5460222797,  &
0.4598541271,  0.0999996647,  &
0.8478119195,  0.6302308164,  &
0.3186735924,  0.3571872923,  &
0.1939545496,  0.1480759519,  &
0.9784584624,  0.9972152091,  &
0.2654835950,  0.3570281134,  &
0.7770542272,  0.7029928228,  &
0.3930557688,  0.0573909897,  &
0.0147517317,  0.5067187073,  &
0.2822744361,  0.9503604181,  &
0.1300720495,  0.4762213000,  &
0.6969547190,  0.4921769277,  &
0.8222561018,  0.7380209865,  &
0.4279952996,  0.6356607853,  &
0.1218544391,  0.9576082458,  &
0.3559957817,  0.2490814215,  &
0.9795904368,  0.6397992399,  &
0.8523116180,  0.8712201698,  &
0.3069618828,  0.1941995748,  &
0.2689076844,  0.3601456813,  &
0.2654901824,  0.9624504277,  &
0.3266961572,  0.3120903984,  &
0.0450991955,  0.7577691640,  &
0.0896379824,  0.9997751158,  &
0.3665695334,  0.8235231881,  &
0.4858445588,  0.5490897237,  &
0.5387087565,  0.2694882531,  &
0.7407188041,  0.5811820148,  &
0.4275430395,  0.0298527540,  &
0.1372842428,  0.1073387692,  &
0.9369298661,  0.2822120702,  &
0.5221660699,  0.9864964284,  &
0.4011099521,  0.6658473816,  &
0.2419333053,  0.7617958844,  &
0.8171415031,  0.3046675985,  &
0.2324559800,  0.4369842925,  &
0.9142499875,  0.7453886645,  &
0.0368848095,  0.9619001129,  &
0.6101675904,  0.8189238407,  &
0.9612001638,  0.2701678416,  &
0.4105127290,  0.6908118615,  &
0.5011415663,  0.3667059128,  &
0.2145534403,  0.3347260170,  &
0.5047072967,  0.8762624869,  &
0.4805589598,  0.4660797090,  &
0.8106578068,  0.5390011578,  &
0.0117750997,  0.4767544249,  &
0.8226027574,  0.5359949640,  &
0.7607308649,  0.9887724631,  &
0.8276909033,  0.5932584155,  &
0.4240160107,  0.7416751676,  &
0.5662743437,  0.3059884558,  &
0.4055346493,  0.3587802195,  &
0.5467827718,  0.4928385855,  &
0.2341237357,  0.7295231567,  &
0.7980682234,  0.9143984396,  &
0.6400428512,  0.1697776858,  &
0.2493851621,  0.2245701419,  &
0.6609579788,  0.3468722386,  &
0.9184581114,  0.2433418960,  &
0.1734529117,  0.5293315622,  &
0.2228450191,  0.5130892033,  &
0.9712347662,  0.3786815569,  &
0.8204824739,  0.9837238780,  &
0.7822467276,  0.0235548715,  &
0.1420903267,  0.8854182248,  &
0.4401123350,  0.5118388569,  &
0.1671010955,  0.7323857910,  &
0.0044423056,  0.1808544959,  &
0.5350759793,  0.6144832190,  &
0.2795535335,  0.9212543806,  &
0.6152227211,  0.9894464237,  &
0.3703402693,  0.2295752264,  &
0.7271190886,  0.7900585414,  &
0.2698967478,  0.8787472345,  &
0.6796541699,  0.5201621654,  &
0.7178896163,  0.4010374309,  &
0.2252738220,  0.9988439612,  &
0.7053877758,  0.2962534083,  &
0.6000167567,  0.7359820427,  &
0.4024816827,  0.6397663079,  &
0.4943336551,  0.1375213864,  &
0.8088301153,  0.5865313350,  &
0.2401032317,  0.2437602012,  &
0.7804023392,  0.9926942402,  &
0.1679980344,  0.0106497805,  &
0.2802188977,  0.6748790531,  &
0.7959275006,  0.9630311576,  &
0.8248980586,  0.4774641301,  &
0.7838117142,  0.1403864470,  &
0.1036013683,  0.3114704490,  &
0.5804494723,  0.1864423021,  &
0.2514618879,  0.2965402163,  &
0.6608022477,  0.8110161470,  &
0.1234219310,  0.5731926625,  &
0.8342515176,  0.7908499725,  &
0.0375021506,  0.1407508725,  &
0.5594186471,  0.1303797147,  &
0.0797299740,  0.7643446380,  &
0.8310018258,  0.2025705789,  &
0.4352914522,  0.5940365362,  &
0.0873822284,  0.9041496636,  &
0.6018520258,  0.5717924681,  &
0.9521236712,  0.4488530503,  &
0.4635295904,  0.0298973414,  &
0.1305535374,  0.9253953091,  &
0.7088647972,  0.3679654194,  &
0.3753501347,  0.7171955857,  &
0.3244061757,  0.2144003238,  &
0.9640799876,  0.0135250567,  &
0.6220199741,  0.8506297026,  &
0.2879313668,  0.3133738875,  &
0.9934289216,  0.4773159592,  &
0.3749518078,  0.7089827087,  &
0.5355123226,  0.6755407442,  &
0.4401818536,  0.6703189929,  &
0.4163023484,  0.2036008193,  &
0.2192759564,  0.7618488679,  &
0.9977598781,  0.4673425290,  &
0.8408004692,  0.6668850640,  &
0.6911641864,  0.4137482125,  &
0.8966101160,  0.9532012697,  &
0.9811886693,  0.2051838289,  &
0.4371309320,  0.5868677962,  &
0.1018638691,  0.3368332477,  &
0.6687213711,  0.1942483121,  &
0.4454187400,  0.5278647444,  &
0.8408399887,  0.3703738538,  &
0.2760747547,  0.9711791485,  &
0.5890831312,  0.2677445354,  &
0.0617644839,  0.7462286702,  &
0.8697811111,  0.8163204155,  &
0.4763613414,  0.8494518156,  &
0.8394056205,  0.5206448122,  &
0.5906124335,  0.3021579778,  &
0.7866312331,  0.0783155213,  &
0.3287453512,  0.5274524583,  &
0.8217304728,  0.7254447630,  &
0.7318549031,  0.4154200866,  &
0.5932829213,  0.1211490029,  &
0.3863468624,  0.7440212319,  &
0.4951467774,  0.1381354649,  &
0.9134656682,  0.5036682425,  &
0.6837860018,  0.0085996279,  &
0.3029781789,  0.5548309417,  &
0.7422182852,  0.9553575271,  &
0.7992608765,  0.8808810823,  &
0.4804848908,  0.0290140315,  &
0.4285520411,  0.7387733879,  &
0.8432048820,  0.2590436894,  &
0.1825542114,  0.6884168470,  &
0.4177644444,  0.2777151238,  &
0.9752049719,  0.6095621293,  &
0.5586592312,  0.1354951205,  &
0.7066521106,  0.4099230627,  &
0.7530711682,  0.3352290108,  &
0.1404555968,  0.8005583283,  &
0.8675442105,  0.2067508131,  &
0.7366699507,  0.0121642882,  &
0.0071559998,  0.7870247883,  &
0.4166425182,  0.4485862981,  &
0.7774256968,  0.8922252464,  &
0.3178967965,  0.5149490520,  &
0.8477312406,  0.4254660629,  &
0.4696875037,  0.7697202133,  &
0.5577609593,  0.5262195050,  &
0.0882273364,  0.2798854582,  &
0.1530778673,  0.2878617588,  &
0.1882207029,  0.1216648905,  &
0.6732918598,  0.4802816218,  &
0.6613635735,  0.6123452175,  &
0.0907428916,  0.5881107426,  &
0.3620404321,  0.0956229115,  &
0.9394484438,  0.8282713615,  &
0.2140158379,  0.7326976906,  &
0.1199299292,  0.2395652144,  &
0.4640910428,  0.7105291276,  &
0.8378945015,  0.1736803761,  &
0.9344120060,  0.2684299815,  &
0.8986617852,  0.4021312033,  &
0.0821731246,  0.9404522088,  &
0.4789653126,  0.8823723088,  &
0.8760633376,  0.2258587845,  &
0.5278610137,  0.9685327792,  &
0.0140269754,  0.9258565391,  &
0.8898798258,  0.0928291219,  &
0.0604331659,  0.5777624947,  &
0.8190710036,  0.2437485611,  &
0.0070249991,  0.9982283660,  &
0.3248868035,  0.3343753761,  &
0.4764293449,  0.6249129115,  &
0.8618563553,  0.9135141334,  &
0.5838984776,  0.3750928853,  &
0.0738502503,  0.3877297188,  &
0.6522809031,  0.0349557893,  &
0.2288766095,  0.3335097683,  &
0.0910897914,  0.1992391970,  &
0.2523631179,  0.3601250958,  &
0.2212776088,  0.3976264481,  &
0.2778645649,  0.6308458442,  &
0.3541135842,  0.9135606908,  &
0.5234428761,  0.3913472964,  &
0.1925160129,  0.4600380606,  &
0.2002843828,  0.3776117849,  &
0.0094818994,  0.5335850840,  &
0.8783052664,  0.9420812404,  &
0.2418082260,  0.6915710321,  &
0.1792466075,  0.3111947429,  &
0.5876623282,  0.4090520437,  &
0.4581555531,  0.2971929129,  &
0.3513010318,  0.2803687686,  &
0.7308415814,  0.3879751573,  &
0.5407000915,  0.0352471115,  &
0.3255253986,  0.7156254392,  &
0.2203080927,  0.2969769058,  &
0.6550523331,  0.5768928084,  &
0.2288173332,  0.0437380684,  &
0.7179014279,  0.2070062656,  &
0.9796777893,  0.7900815782,  &
0.1738620793,  0.7613462481,  &
0.5262406399,  0.4445883256,  &
0.0174674196,  0.6646060466,  &
0.3365189870,  0.3824152475,  &
0.7565662960,  0.3546226302,  &
0.1590537500,  0.0943111361,  &
0.5159619462,  0.7896403334,  &
0.0248689693,  0.0264830546,  &
0.9701015517,  0.5113845924,  &
0.3906614466,  0.1165163692,  &
0.8737000591,  0.2001328736,  &
0.0733841309,  0.0783356758,  &
0.3464397878,  0.7411633022,  &
0.0902325860,  0.4984197691,  &
0.5803769012,  0.8968395024,  &
0.3072524242,  0.6249871571,  &
0.4944595603,  0.4118566135,  &
0.7081184039,  0.3293660340,  &
0.4242819533,  0.0385155442,  &
0.1298336437,  0.8629958047,  &
0.4230629708,  0.9569900515,  &
0.7059700932,  0.6415914850,  &
0.9588790899,  0.6818933535,  &
0.8980389744,  0.3550185011,  &
0.7374639833,  0.9131997435,  &
0.0022229680,  0.6354131350,  &
0.9879566619,  0.1084424540,  &
0.0454796101,  0.5305351650,  &
0.5092678575,  0.6323520353,  &
0.1757367677,  0.2011524420,  &
0.5660450684,  0.9957437002,  &
0.1020439247,  0.4240408980,  &
0.8537951296,  0.8562245988,  &
0.0997635019,  0.2338512851,  &
0.1590551736,  0.8696056668,  &
0.9292800838,  0.7578475742,  &
0.3494062334,  0.3582249487,  &
0.7163292403,  0.2000886388,  &
0.1185271454,  0.7814063549,  &
0.7751861943,  0.1571648178,  &
0.2925677542,  0.6559449999,  &
0.7199386262,  0.2995897769,  &
0.0626330075,  0.8404817085,  &
0.6981867078,  0.6598181242,  &
0.6338710299,  0.9653501243,  &
0.1271465843,  0.5833036365,  &
0.5404231462,  0.4339986218,  &
0.3534288262,  0.8680350290,  &
0.8868724753,  0.8371024288,  &
0.2033884878,  0.4125222018,  &
0.7813637220,  0.1425243223,  &
0.0183605239,  0.7964306700,  &
0.6997728120,  0.4637272145,  &
0.7260451223,  0.3815001122,  &
0.5226688706,  0.1915759440,  &
0.3731390590,  0.2334470324,  &
0.6139153071,  0.9247961251,  &
0.9465424049,  0.6704379698,  &
0.6591804086,  0.7098068240,  &
0.2627914577,  0.3590941178,  &
0.6460411275,  0.4684223782,  &
0.8618600521,  0.4562082302,  &
0.9286395350,  0.0271359551,  &
0.8445203212,  0.5459895693,  &
0.3258261056,  0.2146364951,  &
0.8129028583,  0.3635229371,  &
0.7965241891,  0.0608091887,  &
0.9593615316,  0.3932232069,  &
0.8724612229,  0.1960167141,  &
0.1240428029,  0.4894409498,  &
0.6593460853,  0.6511673747,  &
0.8375201310,  0.4563584541,  &
0.6819447667,  0.5125343142,  &
0.2322222774,  0.8976276953,  &
0.5603837725,  0.7371693000,  &
0.1269825243,  0.4491288814,  &
0.2328539655,  0.8415347494,  &
0.5326466493,  0.8037051444,  &
0.3139563301,  0.9065623011,  &
0.1249927632,  0.8660043525,  &
0.6288662673,  0.7371574820,  &
0.6998817946,  0.3947711826,  &
0.4030423717,  0.0482234222,  &
0.7497752775,  0.0929523946,  &
0.7514497788,  0.8186377956,  &
0.4538224318,  0.5490718375,  &
0.2230566474,  0.8476827559,  &
0.0097254754,  0.8802590034,  &
0.9317544193,  0.9002991676,  &
0.6597469359,  0.3532017706,  &
0.4871356991,  0.9149014852,  &
0.2813809854,  0.6125192283,  &
0.6078574627,  0.2008706322,  &
0.9000693727,  0.8309977991,  &
0.5297782290,  0.9460110379,  &
0.3677016045,  0.7540095693,  &
0.8793425186,  0.6200504716,  &
0.2954795644,  0.5057719570,  &
0.5373331254,  0.4516181337,  &
0.8910480823,  0.8717033058,  &
0.6822444769,  0.6304111859,  &
0.9538910882,  0.0486514821,  &
0.2127897821,  0.3201553244,  &
0.2298788054,  0.7467073252,  &
0.2030479050,  0.0540099192,  &
0.7412672239,  0.6894918570,  &
0.7496472983,  0.1527379194,  &
0.5969565481,  0.1105507823,  &
0.5494541556,  0.2919797361,  &
0.0642845544,  0.5644833837,  &
0.6042000796,  0.3695301493,  &
0.1521048706,  0.1208414345,  &
0.4904439366,  0.1205209137,  &
0.2159680688,  0.3515719562,  &
0.1040356238,  0.4776717916,  &
0.0359150403,  0.6652044904,  &
0.1034658180,  0.9464288618,  &
0.1413426815,  0.1082485845,  &
0.3698598476,  0.2575481228,  &
0.6982148022,  0.6056280180,  &
0.0349310678,  0.6114833968,  &
0.0939003981,  0.1126218284,  &
0.2789572840,  0.5021832194,  &
0.6259984224,  0.4513767448,  &
0.3762623264,  0.3287725761,  &
0.7349440625,  0.1279950583,  &
0.7756628927,  0.7187770852,  &
0.7975192211,  0.6869348848,  &
0.8406844836,  0.0840980317,  &
0.2837019528,  0.4768275274,  &
0.5628265874,  0.9341170348,  &
0.6560697970,  0.5555291810,  &
0.4614011560,  0.7028261879,  &
0.7997495023,  0.3343059349,  &
0.7020344849,  0.6525940295,  &
0.9595683246,  0.6962084402,  &
0.5100008403,  0.8391018029,  &
0.4870799413,  0.1763577912,  &
0.9273108960,  0.1581784010,  &
0.4393301528,  0.1186306148,  &
0.5855194719,  0.1645088092,  &
0.5173359999,  0.1550817959,  &
0.7152195090,  0.0102651370,  &
0.0799339203,  0.5837092875,  &
0.8833734797,  0.0694697559,  &
0.7365472902,  0.9629956473,  &
0.9358642529,  0.3473502515,  &
0.4585232513,  0.2979870116,  &
0.2622772195,  0.6640870714,  &
0.2721377691,  0.1526060076,  &
0.0421522523,  0.3228838718,  &
0.6121624928,  0.8439965531,  &
0.3989365328,  0.9386077097,  &
0.5989279903,  0.7453191331,  &
0.5432226004,  0.2588905654,  &
0.0781766683,  0.2492747097,  &
0.2972687955,  0.9877210743,  &
0.0579774621,  0.3011001541,  &
0.9287172116,  0.9465355538,  &
0.1547172568,  0.8451733548,  &
0.1949573830,  0.4621565471,  &
0.0992495956,  0.4928736749,  &
0.3134727530,  0.3552061213,  &
0.9498881444,  0.4213549923,  &
0.7228805552,  0.1149687880,  &
0.1020810857,  0.6758012589,  &
0.2463424951,  0.7130712990,  &
0.8134118686,  0.5534815680,  &
0.6390779082,  0.0100326642,  &
0.1621635713,  0.8125759843,  &
0.7396760523,  0.8466837056,  &
0.5355424299,  0.6232699123,  &
0.1076623395,  0.5985249196,  &
0.0793048781,  0.3119281899,  &
0.9055038711,  0.8613710681,  &
0.1774896712,  0.2107319894,  &
0.9393868825,  0.7619320365,  &
0.6833401454,  0.0975373966,  &
0.4392125351,  0.0189465431,  &
0.4024838184,  0.6894496331,  &
0.4740142039,  0.1268230370,  &
0.6648566815,  0.3980719495,  &
0.1656947745,  0.1992446689,  &
0.2725964674,  0.1379896256,  &
0.8248545894,  0.1810103430,  &
0.8297983273,  0.7995044576,  &
0.7122060346,  0.4767421352,  &
0.7574152457,  0.0667837277,  &
0.1794334490,  0.6912522713,  &
0.8787088694,  0.4958421415,  &
0.7689418257,  0.6786208674,  &
0.5264845126,  0.1569317375,  &
0.1935540685,  0.8942006151,  &
0.7582043210,  0.9613242297,  &
0.1374786188,  0.7019056295,  &
0.6290080023,  0.2389475616,  &
0.8503024862,  0.1772005220,  &
0.4778122315,  0.6167093179,  &
0.1146325308,  0.8915178495,  &
0.6690248598,  0.9788038354,  &
0.6238830617,  0.9979741624,  &
0.7139513418,  0.1434403543,  &
0.9645176424,  0.4060109398,  &
0.0547854706,  0.7990690011,  &
0.7802078882,  0.9199128967,  &
0.0667067564,  0.0408726978,  &
0.6156630750,  0.2741460166,  &
0.1527686475,  0.0520975969,  &
0.8812667500,  0.0674399546,  &
0.3758687622,  0.0997668056,  &
0.5023218081,  0.8240878570,  &
0.3727629058,  0.1676229020,  &
0.7568967144,  0.2374758934,  &
0.2768055716,  0.9468261716,  &
0.7585749336,  0.6521745809,  &
0.6643622104,  0.8680259934,  &
0.1596212098,  0.7743598878,  &
0.0290317409,  0.6220802870,  &
0.2933147774,  0.9679292205,  &
0.6503168946,  0.8317102695,  &
0.4798588553,  0.6299979951,  &
0.9651299804,  0.7986765972,  &
0.7046038763,  0.9565644635,  &
0.6231055238,  0.9194714372,  &
0.1815264487,  0.7535934288,  &
0.3739053850,  0.7397495187,  &
0.3276220849,  0.3420590855,  &
0.2677155725,  0.7869295458,  &
0.2844811984,  0.6126887487,  &
0.9758178924,  0.5595018276,  &
0.1524919299,  0.4651469280,  &
0.3331686304,  0.4788773436,  &
0.1326453714,  0.8753692719,  &
0.1633819345,  0.4033638328,  &
0.3642086443,  0.0181115267,  &
0.3117639723,  0.6383253103,  &
0.7949524167,  0.4742113247,  &
0.8729182195,  0.9618915858,  &
0.0332650815,  0.9561135535,  &
0.2872549683,  0.2642225905,  &
0.0729784309,  0.7984106444,  &
0.6357523006,  0.3269095479,  &
0.5900006309,  0.3322072302,  &
0.3900998519,  0.9106759244,  &
0.0547010871,  0.1613232283,  &
0.1971601606,  0.6854010253,  &
0.4998948238,  0.7416392744,  &
0.7947369911,  0.7682003446,  &
0.1426959468,  0.8763458320,  &
0.5189723242,  0.9025473081,  &
0.5531904914,  0.5517472743,  &
0.0231068661,  0.1647996542,  &
0.1838980196,  0.2743330564,  &
0.6680908912,  0.5217749670,  &
0.4428207625,  0.2842060108,  &
0.3065446219,  0.2790292899,  &
0.5598862902,  0.4893189322,  &
0.0951440972,  0.0016943354,  &
0.2377619426,  0.1504496647,  &
0.8217031046,  0.3145314780,  &
0.7958474320,  0.9657075845,  &
0.6513578521,  0.0770901332,  &
0.9020345297,  0.1511964913,  &
0.2628882648,  0.2700415498,  &
0.1375208413,  0.1018236843,  &
0.3694013337,  0.6237353081,  &
0.7219009708,  0.5769897278,  &
0.7037065877,  0.3218533244,  &
0.8709292688,  0.1565938441,  &
0.8040333287,  0.0432084117,  &
0.8502650402,  0.8453525053,  &
0.6116637363,  0.1086546879,  &
0.7994934941,  0.8545724991,  &
0.8463727023,  0.0027493320,  &
0.4698262961,  0.1055700866,  &
0.5005303451,  0.4044088458,  &
0.3387197982,  0.7102255340,  &
0.6891433400,  0.4181154148,  &
0.3323702565,  0.4616895561,  &
0.6399586542,  0.6089116381,  &
0.5018088330,  0.9212397516,  &
0.6431817072,  0.9417243498,  &
0.7273705374,  0.5820187832,  &
0.3877962569,  0.4075688609,  &
0.8190083206,  0.6136329602,  &
0.6869629182,  0.2759943558,  &
0.0258248650,  0.8067190788,  &
0.1152133529,  0.8514174231,  &
0.9518965986,  0.0098752650,  &
0.6302771280,  0.1711952721,  &
0.1678577572,  0.6560381161,  &
0.1279893649,  0.5466780238,  &
0.2582922041,  0.0912121181,  &
0.5584447019,  0.2270853594,  &
0.6957628958,  0.5183774449,  &
0.8981380605,  0.0145224696,  &
0.8440085141,  0.5234261505,  &
0.7436596023,  0.7307202493,  &
0.2849775427,  0.8775846136,  &
0.5348975431,  0.0821940434,  &
0.9008339497,  0.5858859370,  &
0.2942214564,  0.5658695489,  &
0.6283837221,  0.7787227792,  &
0.3272824569,  0.6433298949,  &
0.8232406382,  0.3673065834,  &
0.7638928876,  0.3956605825,  &
0.5538579082,  0.0932941497,  &
0.2641320857,  0.8862336621,  &
0.3650061426,  0.3827749253,  &
0.0776319104,  0.1736065394,  &
0.1744422533,  0.9592674388,  &
0.8567101722,  0.6414440293,  &
0.0514350436,  0.6449818323,  &
0.9632780032,  0.5429891992,  &
0.4342507784,  0.3374124183,  &
0.5274762257,  0.2430112954,  &
0.8083042360,  0.3831128628,  &
0.1552150454,  0.2710721447,  &
0.4316998131,  0.3677118127,  &
0.7054603357,  0.4408198871,  &
0.1743442466,  0.9591474626,  &
0.2899030656,  0.6840203390,  &
0.4432875648,  0.4416599222,  &
0.4154387950,  0.9576190512,  &
0.6276617770,  0.7016180966,  &
0.3050037954,  0.1375919693,  &
0.7913214505,  0.6361566978,  &
0.7231641044,  0.3437004806,  &
0.4342964823,  0.4832654426,  &
0.4616739622,  0.5323758450,  &
0.6753120203,  0.0356055091,  &
0.9348229100,  0.9520981568,  &
0.2750833434,  0.3300949183,  &
0.1197855661,  0.3014314420,  &
0.8619279106,  0.7073966061,  &
0.1257836138,  0.8623161639,  &
0.1731778833,  0.5020551155,  &
0.0887985275,  0.0067751061,  &
0.3458984664,  0.5781954738,  &
0.2995632373,  0.9577743607,  &
0.1829654964,  0.4070909661,  &
0.5867299224,  0.9388814174,  &
0.7615693162,  0.1688216514,  &
0.7844649798,  0.6304804879,  &
0.5805016276,  0.5968836752,  &
0.4771072113,  0.4744553067,  &
0.1743479709,  0.8538119892,  &
0.0610355406,  0.7333495043,  &
0.7308773443,  0.6153356725,  &
0.5483416342,  0.5920055342,  &
0.4538571330,  0.5742004036,  &
0.5177181800,  0.9462581570,  &
0.0611407041,  0.6240642653,  &
0.9991603686,  0.5352920330,  &
0.4375924986,  0.9140774992,  &
0.1480442991,  0.4842881467,  &
0.2299972193,  0.0937273149,  &
0.5184747072,  0.7803213177,  &
0.0301197809,  0.1457578544,  &
0.9216311658,  0.2117157981,  &
0.5561951718,  0.8744769746,  &
0.3713505222,  0.7154372687,  &
0.2784321979,  0.7474316436,  &
0.0885419986,  0.9972310380,  &
0.4204937754,  0.6469804470,  &
0.2743448766,  0.0665320602,  &
0.3703141073,  0.2222917956,  &
0.8650388109,  0.1415979637,  &
0.3815769262,  0.0624782383,  &
0.3464976446,  0.9020601079,  &
0.7156339452,  0.4943494973,  &
0.0825820006,  0.2382572533,  &
0.1861097153,  0.5530710063,  &
0.0705488886,  0.1910041530,  &
0.6701601329,  0.4563429169,  &
0.8908274202,  0.4737082762,  &
0.7687171947,  0.3266611181,  &
0.3827905802,  0.5920288782,  &
0.8716383178,  0.6366762150,  &
0.2238748276,  0.0071555690,  &
0.9660601195,  0.9168018279,  &
0.1748158032,  0.5365396288,  &
0.9943164644,  0.1114235336,  &
0.5192521792,  0.5826584136,  &
0.1443314872,  0.7997726973,  &
0.4320339807,  0.1586848439,  &
0.4685206810,  0.4377587418,  &
0.1405402331,  0.8381984306,  &
0.7656631619,  0.9268873637,  &
0.0438560191,  0.7732818961,  &
0.0558683147,  0.1472727811,  &
0.9142900096,  0.4816424185,  &
0.1237278835,  0.8268557620,  &
0.3069809923,  0.7559023430,  &
0.9578778962,  0.6149015135,  &
0.9183168926,  0.9056142493,  &
0.7227182693,  0.8066384210,  &
0.3218004126,  0.4223327611,  &
0.4536821493,  0.9045764364,  &
0.6506382460,  0.5868382254,  &
0.2231987309,  0.3722512537,  &
0.6388646760,  0.5528030279,  &
0.4436811419,  0.7584115029,  &
0.8655354331,  0.3023079099,  &
0.9021208866,  0.5675354108,  &
0.1767608614,  0.9948117703,  &
0.3955782609,  0.3089980962,  &
0.0634979072,  0.7697385511,  &
0.4137159451,  0.5334713212,  &
0.2569959850,  0.6733746126,  &
0.3549696159,  0.7675758498,  &
0.1229081761,  0.9092714605,  &
0.1379955297,  0.9121337433,  &
0.5361045116,  0.0310877136,  &
0.7809063607,  0.7715741369,  &
0.5271124423,  0.2168227338,  &
0.9642823904,  0.5720941580,  &
0.7841660208,  0.7757657721,  &
0.5082210222,  0.9226633243,  &
0.1508899252,  0.4894215301,  &
0.8830853609,  0.4107383611,  &
0.5057016028,  0.2623506128,  &
0.4993181807,  0.6629238787,  &
0.5712881780,  0.4587424783,  &
0.0393002695,  0.0981449300,  &
0.4229740431,  0.7098900803,  &
0.8693890753,  0.1725861289,  &
0.7496671375,  0.8039882235,  &
0.1256231798,  0.7858402808,  &
0.8369525792,  0.6297503080,  &
0.9112264054,  0.3707441790,  &
0.2227530485,  0.1241710651,  &
0.0178020933,  0.0552499392,  &
0.0580532784,  0.2272829889,  &
0.8039977195,  0.8206664284,  &
0.8072056263,  0.3508945889,  &
0.8058824032,  0.1651977432,  &
0.3867268065,  0.9676728527,  &
0.3313380914,  0.7027712746,  &
0.7390646069,  0.9220089099,  &
0.8434922288,  0.5955413553,  &
0.9996809262,  0.5659308117,  &
0.7417601325,  0.9755886500,  &
0.0569333857,  0.7278631640,  &
0.6242251474,  0.7783653293,  &
0.0634011975,  0.4127606274,  &
0.2008274539,  0.4550936503,  &
0.7091750972,  0.4656828829,  &
0.9405184647,  0.4331143813,  &
0.5679717225,  0.2149818606,  &
0.8029344414,  0.9115143902,  &
0.8184614268,  0.4262447658,  &
0.6632146720,  0.1973209237,  &
0.3656564443,  0.3698425126,  &
0.7418748760,  0.4187556185,  &
0.3293770166,  0.6721359303,  &
0.6818654460,  0.7238383017,  &
0.2408476393,  0.0746831561,  &
0.8628772929,  0.5545850639,  &
0.7047108152,  0.2144002413,  &
0.2565577087,  0.9173508376,  &
0.0665367372,  0.6144302238,  &
0.1009059407,  0.1130285035,  &
0.6018391645,  0.5575439857,  &
0.5653839650,  0.5537066627,  &
0.8970579459,  0.9367762015,  &
0.6347757188,  0.9748532748,  &
0.5872712850,  0.8782838341,  &
0.0533549364,  0.1902375944,  &
0.7718361507,  0.1868077701,  &
0.5842031047,  0.3697414112,  &
0.9137522444,  0.3658105088,  &
0.4324092548,  0.2488203167,  &
0.3712321928,  0.6634242543,  &
0.3416759068,  0.7901229065,  &
0.6510406060,  0.8470676534,  &
0.6074896448,  0.0280746348,  &
0.2993356870,  0.6559659238,  &
0.9224651936,  0.6816987346,  &
0.1066709059,  0.5965323825,  &
0.5907472567,  0.8141528766,  &
0.4697903997,  0.0129965017,  &
0.4176871893,  0.8307932080,  &
0.4838977573,  0.0928226038,  &
0.9391673438,  0.8995791104,  &
0.9243991296,  0.8178572349,  &
0.7905929575,  0.5481099712,  &
0.2537810743,  0.1579228738,  &
0.4994642844,  0.2064836261,  &
0.7240625332,  0.1679361183,  &
0.2826950631,  0.2366676639,  &
0.0911574771,  0.2924371559,  &
0.9431054589,  0.0133924259,  &
0.5840626166,  0.6678990400,  &
0.3857264716,  0.0991033640,  &
0.3549940332,  0.2622805894,  &
0.0647975156,  0.8547790392,  &
0.2105307780,  0.4412164564,  &
0.5859091618,  0.9844436048,  &
0.4251944937,  0.2694830660,  &
0.9293853820,  0.8987605476,  &
0.8092068446,  0.2860448735,  &
0.5901660224,  0.3357448635,  &
0.1870927985,  0.0249275030,  &
0.1135848514,  0.9893497160,  &
0.7722225693,  0.4082188927,  &
0.8516929623,  0.7250989850,  &
0.3074252797,  0.8980564267,  &
0.7608848611,  0.6550095880,  &
0.7042204011,  0.6221109600,  &
0.0081018242,  0.2432750517,  &
0.1555069269,  0.4940386818,  &
0.2675308057,  0.8911054430,  &
0.0301398724,  0.3609451073,  &
0.9110644127,  0.4661396579,  &
0.9636705636,  0.2431354966,  &
0.4593991301,  0.5442135841,  &
0.2251382293,  0.5411255961,  &
0.8655575350,  0.1305124877,  &
0.6104371387,  0.3767781902,  &
0.7671262263,  0.4928954326,  &
0.3729646561,  0.7278269072,  &
0.9603471567,  0.4763395574,  &
0.7177577504,  0.8752808793,  &
0.2562301619,  0.2388189083,  &
0.2339602850,  0.4507862832,  &
0.3763595836,  0.6170341117,  &
0.4615166246,  0.6270994012,  &
0.7321914654,  0.6507982529,  &
0.5446748513,  0.5223418031,  &
0.9504502172,  0.8721745870,  &
0.6402216296,  0.1114275994,  &
0.0076782971,  0.3710885173,  &
0.8784854237,  0.8217117791,  &
0.9791595257,  0.3822174867,  &
0.0741156521,  0.9579066712,  &
0.8048118801,  0.7923651412,  &
0.9798946926,  0.6889594712,  &
0.3794263192,  0.5288145562,  &
0.3536152539,  0.5107082101,  &
0.2548488307,  0.4599271540,  &
0.7173838108,  0.9737133315,  &
0.2382772263,  0.7079019649,  &
0.7984870668,  0.9421590477,  &
0.5564942587,  0.0516428058,  &
0.6915288951,  0.3865826181,  &
0.4041148684,  0.4815557108,  &
0.1511966989,  0.8348729622,  &
0.0429396786,  0.3948925571,  &
0.9791954763,  0.3161242497,  &
0.9164371339,  0.6293629476,  &
0.1243022970,  0.6966734492,  &
0.3047040410,  0.9675678241,  &
0.1380207356,  0.5242035473,  &
0.5490414997,  0.5275293349,  &
0.3897630552,  0.8852218874,  &
0.9167902152,  0.3259115168,  &
0.4413952438,  0.9951099717,  &
0.2275254350,  0.2684364050,  &
0.9376353725,  0.9990058273,  &
0.9857399214,  0.4870002910,  &
0.6316138319,  0.4914632599,  &
0.5089968983,  0.5756898431,  &
0.2872961731,  0.3142901040,  &
0.5169837897,  0.8450330478,  &
0.3086719991,  0.7812400526,  &
0.8596398682,  0.3869309665,  &
0.1143466738,  0.2486794600,  &
0.2417003513,  0.9593588320,  &
0.6261065819,  0.2069968052,  &
0.9057259677,  0.5408251256,  &
0.3972154482,  0.1187158705,  &
0.7277667472,  0.0329469991,  &
0.7420512907,  0.3969628302,  &
0.7743776882,  0.1853332524,  &
0.8718897836,  0.4633708361,  &
0.2282619989,  0.9599055450,  &
0.8958312528,  0.4734050890,  &
0.3265916814,  0.5894387110,  &
0.1846002931,  0.3884621628,  &
0.8178644562,  0.9272879328,  &
0.1452930206,  0.7773147459,  &
0.1198388186,  0.7342454065,  &
0.4366427361,  0.9134634713,  &
0.1809474407,  0.2194456695,  &
0.6695369009,  0.2872472389,  &
0.3829680632,  0.3110712894,  &
0.4672345488,  0.1020037495,  &
0.2407640401,  0.1235205343,  &
0.2863976255,  0.3831602536,  &
0.0185892706,  0.8859702884,  &
0.7580585791,  0.0254290841,  &
0.8642462780,  0.7041933572,  &
0.5765713136,  0.9477773760,  &
0.2494683028,  0.2846527913,  &
0.3650139870,  0.1898112503,  &
0.1965589856,  0.4547900004,  &
0.9691583323,  0.9638179709,  &
0.6070240074,  0.5038710228,  &
0.7170848553,  0.2893242065,  &
0.3823646683,  0.9796482845,  &
0.0972996937,  0.7201681370,  &
0.4281199006,  0.5528443562,  &
0.0340884177,  0.3417316565,  &
0.9140825911,  0.3190340357,  &
0.1626943903,  0.0789086295,  &
0.3076917004,  0.8986138600,  &
0.4729668088,  0.8320790713,  &
0.2098013997,  0.7206479901,  &
0.7632461832,  0.1572639405,  &
0.2816195973,  0.4348327699,  &
0.1394599004,  0.1049883998,  &
0.0775209721,  0.6360409125,  &
0.5045353120,  0.8833165091,  &
0.7822671527,  0.4366880135,  &
0.0135187627,  0.1084424846,  &
0.2521561455,  0.7469267492,  &
0.7447942631,  0.5360937687,  &
0.9115768861,  0.3931357462,  &
0.6366356587,  0.0675558009,  &
0.3515822080,  0.1203022198,  &
0.4721844274,  0.5901275599,  &
0.0349943327,  0.5674373337,  &
0.6928041783,  0.0036776229,  &
0.6673534349,  0.9057977956,  &
0.5741468050,  0.7876903263,  &
0.0285464247,  0.3441891871,  &
0.2079077718,  0.3226011801,  &
0.7214681544,  0.9542662103,  &
0.7470587082,  0.6838495106,  &
0.3378467368,  0.4610131717,  &
0.1622385738,  0.0731703581,  &
0.9986296558,  0.4665511241,  &
0.6270715972,  0.8392722209,  &
0.5761490454,  0.0739618492,  &
0.0246403976,  0.2034905447,  &
0.7045666487,  0.6328605625,  &
0.9585599254,  0.7169410402,  &
0.0952613948,  0.5536691681,  &
0.5389550825,  0.1160845135,  &
0.4244940095,  0.0689308415,  &
0.2363489196,  0.3456315546,  &
0.6780219456,  0.3843970536,  &
0.8552856431,  0.2538528736,  &
0.9565085638,  0.6950673958,  &
0.4677728411,  0.0278190166,  &
0.6122810871,  0.7224999018,  &
0.5353194948,  0.0485653486,  &
0.7452967635,  0.0851403779,  &
0.0179851647,  0.0412884620,  &
0.7892988730,  0.2410199892,  &
0.5592056527,  0.5954715643/)
end subroutine set_random_array
end module constant_random
