
!> A program that runs unit tests on the theta_grid module.
!!
!! Current tests:
!!   1. A given geometry is provided in Miller, EFIT and CHEASE form. We test 
!!       to see that theta_grid gets the same coefficients in all three cases.
!!
!!
!! This is free software released under the MIT license
!!   Written by: Edmund Highcock (edmundhighcock@users.sourceforge.net)
program test_theta_grid
  use unit_tests
  use theta_grid, only: init_theta_grid, finish_theta_grid
  use theta_grid, only: initialized, theta
  use theta_grid, only: bmag, grho, gbdrift, cvdrift, gds2, gds21
  use egrid
  !use general_f0, only: init_general_f0
  use mp, only: init_mp, finish_mp, proc0
  use file_utils, only: init_file_utils, finish_file_utils
  use species, only: init_species, nspec, spec
  use constants, only: pi
  !use fields, only: init_fields
  !use fields_arrays, only: phi
  !use dist_fn, only: init_dist_fn
  !use dist_fn_arrays, only: g
  use kt_grids, only: naky, ntheta0, init_kt_grids
  use gs2_layouts, only: init_gs2_layouts, g_lo, ie_idx
  implicit none
  real :: eps
  logical :: dummy
  real, dimension(33, 3, 10) :: rslt
  real, dimension(33, 10) :: mill_rslt
  real, dimension(33) :: theta_rslt


  ! General config
  eps = 1.0e-7

  if (precision(eps).lt. 11) eps = eps * 1000.0
  !if (precision(eps).lt. 11) write (*,*) 'low precision'

  ! Set up depenencies
  call init_mp
  if (proc0) call init_file_utils(dummy, .true., .true., .false., 'local')
  !call init_species
  !call init_general_f0



  call announce_module_test('theta_grid')

  !call announce_test('init_theta_grid')

  !call process_test(theta_grid_unit_test_init_theta_grid(sizes, energy_results, eps), &
    !'init_theta_grid')
  !call init_theta_grid(dummy, dummy)

  !call init_dist_fn
  call init_theta_grid
  !write (*,*) 'size', size(bmag)

  mill_rslt = miller_result()

  rslt = 0.
  call get_results(1)
!
  !call finish_theta_grid
  if (proc0) call finish_file_utils
  !write(*,*) 'MILLER', rslt(:,1,:)
  
  !write (*,*) 'Finished local'

  !initialized = .false.

  if (proc0) call init_file_utils(dummy, .true., .true., .false., 'chease')
  call get_results(2)
  if (proc0) call finish_file_utils

  !initialized = .false.

  !theta_rslt = - theta_rslt

  if (proc0) call init_file_utils(dummy, .true., .true., .false., 'efit')
  call get_results(3)
  if (proc0) call finish_file_utils


  call announce_test(' that Miller has not changed')
  !rslt(:,1,1) = rslt(:, 1, 1) * 0.9901928539149342 !* 0.9934 ! Adjust for different normalisation in
  ! Miller

  call process_test( &
    !test_results(rslt(:,1,:), miller_result(), 4.9e-3, 3.0e-1), & ! JRB
    test_results(rslt(:,1,:), miller_result(), 2e-2, 3.0e-1), & ! JRB
    ' that Miller has not changed')

  call announce_test(' that Miller and CHEASE give the same result')
  !rslt(:,1,1) = rslt(:, 1, 1) * 0.9901928539149342 !* 0.9934 ! Adjust for different normalisation in
  ! Miller

  call process_test( &
    test_results(rslt(:,1,:), rslt(:,2,:), 4.9e-1, 3.0e-1), &
    ' that Miller and CHEASE give the same result')

  call announce_test(' that CHEASE and EFIT give the same result')
  !rslt(:,1,1) = rslt(:, 1, 1) * 0.9901928539149342 !* 0.9934 ! Adjust for different normalisation in
  ! Miller

  call process_test( &
    test_results(rslt(:,2,:), rslt(:,3,:), 15.0e-2, 1.0e-1), &
    ' that CHEASE and EFIT give the same result')

  call close_module_test('theta_grid')
  call finish_mp

contains
  function test_results(rslt1, rslt2, epsin, bmagerror)
    real, dimension(:,:) :: rslt1, rslt2
    logical :: test_results
    real :: epsin, bmagerror
    test_results = .true.
    call announce_check('bmag')
    call process_check(test_results, &
      agrees_with(rslt1(:,1), rslt2(:,1), bmagerror), 'bmag')
    call announce_check('grho')
    call process_check(test_results, &
      agrees_with(rslt1(:,2), rslt2(:,2), bmagerror), 'grho')
    call announce_check('gbdrift')
    call process_check(test_results, &
      agrees_with(rslt1(:,3), rslt2(:,3), epsin), 'gbdrift')
    call announce_check('cvdrift')
    call process_check(test_results, &
      agrees_with(rslt1(:,4), rslt2(:,4), epsin), 'cvdrift')
    !call announce_check('theta')
    !call process_check(test_results, &
      !agrees_with(rslt1(:,7), rslt2(:,7), epsin), 'theta')

  end function test_results
  subroutine get_results(i)
    integer, intent(in) :: i
    call init_theta_grid
    if (i .eq. 1) theta_rslt = mill_rslt(:,7)
    !write (*,*) 'agwith', agrees_with(theta, theta_rslt, 0.1) 
    !theta_rslt = 1.0
    rslt(:,i,1) = spl_fit(bmag)
    rslt(:,i,2) = spl_fit(grho)
    rslt(:,i,3) = spl_fit(gbdrift)
    !write (*,*) 'gbdrift', gbdrift, 'rslt', rslt(:,i,3)
    rslt(:,i,4) = spl_fit(cvdrift)
    rslt(:,i,5) = spl_fit(gds2)
    rslt(:,i,6) = spl_fit(gds21)
    !rslt(:,i,7) = spl_fit(theta)
    !rslt(:,i,2) = bmag
    call finish_theta_grid
  end subroutine get_results

  function spl_fit(var)
    use splines
    type(spline) :: spl
    real, dimension(:), intent(in) :: var
    real, dimension(33) :: spl_fit
    integer :: i
    !write (*,*) 'Size of theta = ', size(theta)
    !write (*,*) 'Size of var = ', size(var)
    !write (*,*) 'Size of theta_rslt = ', size(theta_rslt)
    call new_spline(size(var), theta, var, spl)
    do i = 1,33
      spl_fit(i) = splint(theta_rslt(i), spl)
    end do
    call delete_spline(spl)
  end function spl_fit

  function miller_result()
    real, dimension (33,10) :: miller_result

miller_result = &
reshape([&
!Bmag
0.99089195669961561, &
0.98942279468906869, &
0.98684466997900444, &
0.98306976749613695, &
0.97815532312669795, &
0.97228456784953232, &
0.96553287558366041, &
0.95004443815229889, &
0.93734564724532365, &
0.92433881967091402, &
0.91575976325069641, &
0.89947875430618174, &
0.88513196091740154, &
0.87363045295444264, &
0.86535175332313341, &
0.86065307917813638, &
0.85959130006393869, &
0.86065307917813638, &
0.86535175332313341, &
0.87363045295444264, &
0.88513196091740154, &
0.89947875430618163, &
0.91575976325069641, &
0.92433881967091402, &
0.93734564724532365, &
0.95004443815229878, &
0.96553287558366041, &
0.97228456784953221, &
0.97815532312669795, &
0.98306976749613684, &
0.98684466997900433, &
0.98942279468906846, &
0.99089195669961561, &
!GRHO
0.78194364857531617, &
0.77832858064883004, &
0.77239091960146677, &
0.76388652388725031, &
0.75345122246492768, &
0.74192761205684854, &
0.73032397559647344, &
0.71359711788929991, &
0.71572651490522632, &
0.74017779399696915, &
0.77233334648474017, &
0.87609363925663741, &
1.0190532645296606, &
1.1683730425021284, &
1.2925299868093911, &
1.3683206985364944, &
1.3867020103594792, &
1.3683206985364962, &
1.2925299868093898, &
1.1683730425021273, &
1.0190532645296606, &
0.87609363925663741, &
0.77233334648473961, &
0.74017779399696904, &
0.71572651490522610, &
0.71359711788929991, &
0.73032397559647333, &
0.74192761205684865, &
0.75345122246492768, &
0.76388652388725042, &
0.77239091960146677, &
0.77832858064882959, &
0.78194364857531617, &
!GBDRIFT
-0.74692616977064563, &
-0.68471054154411493, &
-0.64286731440946743, &
-0.60010534813325367, &
-0.55560656218146498, &
-0.50934948055438667, &
-0.46006222402483304, &
-0.35171395875557071, &
-0.26282692143046466, &
-0.17249147745406659, &
-0.11569570210824337, &
-1.7345443169696790E-002, &
6.5535965385687275E-002, &
0.13857711521102248, &
0.19795083177286413, &
0.23455372323836146, &
0.24307692414634946, &
0.23455372323836243, &
0.19795083177286349, &
0.13857711521102173, &
6.5535965385687345E-002, &
-1.7345443169696863E-002, &
-0.11569570210824399, &
-0.17249147745406701, &
-0.26282692143046593, &
-0.35171395875556977, &
-0.46006222402483243, &
-0.50934948055438700, &
-0.55560656218146487, &
-0.60010534813325367, &
-0.64286731440946732, &
-0.68471054154411226, &
-0.74692616977064563, &
!CVDRIFT
-0.67233390031802509, &
-0.60993340412129926, &
-0.56773345760706240, &
-0.52442039633900139, &
-0.47918530514588986, &
-0.43201826476882360, &
-0.38164426195685203, &
-0.27062800688029653, &
-0.17937396273553474, &
-8.6507516166451331E-002, &
-2.8026057311146664E-002, &
7.3532107250088255E-002, &
0.15935466030464668, &
0.23491550521375948, &
0.29619809471765229, &
0.33393315054841688, &
0.34277010930862473, &
0.33393315054841788, &
0.29619809471765157, &
0.23491550521375876, &
0.15935466030464676, &
7.3532107250088213E-002, &
-2.8026057311147282E-002, &
-8.6507516166451803E-002, &
-0.17937396273553616, &
-0.27062800688029581, &
-0.38164426195685147, &
-0.43201826476882388, &
-0.47918530514588970, &
-0.52442039633900139, &
-0.56773345760706240, &
-0.60993340412129660, &
-0.67233390031802509, &
!GDS2
2.2844286875572437, &
2.1940868964555800, &
2.1400738183321408, &
2.0903990723543493, &
2.0432234005188508, &
1.9971655720676817, &
1.9483291974824897, &
1.8290989482651094, &
1.7079627986158925, &
1.5540092370681540, &
1.4375317628243083, &
1.1969611222959029, &
0.96573321499597653, &
0.74462112301248828, &
0.54721137106385587, &
0.41548057387026516, &
0.38338503879055214, &
0.41548057387026149, &
0.54721137106385787, &
0.74462112301249017, &
0.96573321499597642, &
1.1969611222959031, &
1.4375317628243092, &
1.5540092370681549, &
1.7079627986158950, &
1.8290989482651085, &
1.9483291974824901, &
1.9971655720676842, &
2.0432234005188534, &
2.0903990723543520, &
2.1400738183321417, &
2.1940868964555760, &
2.2844286875572437, &
!GDS21
0.22300232499645659, &
0.20572777676496640, &
0.19212259338409451, &
0.17675525804824976, &
0.15957410926441798, &
0.14064768168330891, &
0.11952092300783278, &
7.0205299108978436E-002, &
2.7124495797599759E-002, &
-1.9982478829153941E-002, &
-5.2563123929448792E-002, &
-0.11519215997417707, &
-0.16147196442075476, &
-0.17295831862841629, &
-0.13999267442296814, &
-6.8029472167302429E-002, &
0.0000000000000000, &
6.8029472167298793E-002, &
0.13999267442296884, &
0.17295831862841629, &
0.16147196442075476, &
0.11519215997417712, &
5.2563123929448341E-002, &
1.9982478829153588E-002, &
-2.7124495797600481E-002, &
-7.0205299108978172E-002, &
-0.11952092300783279, &
-0.14064768168330946, &
-0.15957410926441845, &
-0.17675525804825015, &
-0.19212259338409468, &
-0.20572777676496556, &
-0.22300232499645659, &
!Theta
-3.1415926535897931, -2.8827148489924079, -2.7120640703968331, &
-2.5432795318489498, -2.3763612333487485, -2.2148097694458473, &
-2.0566196070473417, -1.7546520118826869, -1.5421544960032674, &
-1.3420559295667975, -1.2153904787223748, -0.97710640350058209, &
-0.75477234536564630, -0.54608294340766139, -0.34442491789431751, &
-0.14683228611620341, 0.0000000000000000, 0.14683228611619459, &
0.34442491789432061, 0.54608294340766295, 0.75477234536564630, &
0.97710640350058231, 1.2153904787223768, 1.3420559295667989, &
1.5421544960032698, 1.7546520118826845, 2.0566196070473404, &
2.2148097694458486, 2.3763612333487485, 2.5432795318489498, &
2.7120640703968326, 2.8827148489923973, 3.1415926535897931, & 
!NULL
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000, &
0.0000000000000000  &
], (/33,10/))
end function miller_result

end program test_theta_grid
