
! DO NOT EDIT THIS FILE
! This file is automatically generated by generate_diagnostics_create_and_write

!> A module which contains two high level interfaces for writing 
!! to the netcdf file, one for variables which are local to all
!! processors, and one for variables which may be distributed in 
!! the same manner as the fields.
module diagnostics_create_and_write

  implicit none

  private

  !> Create and/or write the given variable depending on the values
  !! of the flags gnostics%create and gnostics%wryte
  public :: create_and_write_variable

  !> Create and/or write the given variable depending on the values
  !! of the flags gnostics%create and gnostics%wryte
  !! This version will not attempt to read the variable during a
  !! replay, useful for constants such as input parameters, 
  !! normalisations
  public :: create_and_write_variable_noread

  !> These are a set of subroutines for writing variables which 
  !! have the dimensions kx and ky (for example, fields, moments or 
  !! fluxes) which may be distributed, ie. different kx,ky combinations
  !! may be on different processors. The locality is determined through
  !! the function field_k_local.
  public :: create_and_write_distributed_fieldlike_variable

  interface create_and_write_variable
     module procedure create_and_write_variable_real_0
     module procedure create_and_write_variable_real_1
     module procedure create_and_write_variable_real_2
     module procedure create_and_write_variable_real_3
     module procedure create_and_write_variable_real_4
     module procedure create_and_write_variable_integer_0
     module procedure create_and_write_variable_integer_1
     module procedure create_and_write_variable_integer_2
     module procedure create_and_write_variable_integer_3
     module procedure create_and_write_variable_integer_4
     module procedure create_and_write_variable_character_0
     module procedure create_and_write_variable_character_1
     module procedure create_and_write_variable_character_2
     module procedure create_and_write_variable_character_3
     module procedure create_and_write_variable_character_4
     module procedure create_and_write_variable_double_precision_0
     module procedure create_and_write_variable_double_precision_1
     module procedure create_and_write_variable_double_precision_2
     module procedure create_and_write_variable_double_precision_3
     module procedure create_and_write_variable_double_precision_4
     module procedure create_and_write_variable_complex_0
     module procedure create_and_write_variable_complex_1
     module procedure create_and_write_variable_complex_2
     module procedure create_and_write_variable_complex_3
     module procedure create_and_write_variable_complex_4
     module procedure create_and_write_variable_complex_16_0
     module procedure create_and_write_variable_complex_16_1
     module procedure create_and_write_variable_complex_16_2
     module procedure create_and_write_variable_complex_16_3
     module procedure create_and_write_variable_complex_16_4
  end interface create_and_write_variable

  interface create_and_write_variable_noread
     module procedure create_and_write_variable_real_0_nr
     module procedure create_and_write_variable_real_1_nr
     module procedure create_and_write_variable_real_2_nr
     module procedure create_and_write_variable_real_3_nr
     module procedure create_and_write_variable_real_4_nr
     module procedure create_and_write_variable_integer_0_nr
     module procedure create_and_write_variable_integer_1_nr
     module procedure create_and_write_variable_integer_2_nr
     module procedure create_and_write_variable_integer_3_nr
     module procedure create_and_write_variable_integer_4_nr
     module procedure create_and_write_variable_character_0_nr
     module procedure create_and_write_variable_character_1_nr
     module procedure create_and_write_variable_character_2_nr
     module procedure create_and_write_variable_character_3_nr
     module procedure create_and_write_variable_character_4_nr
     module procedure create_and_write_variable_double_precision_0_nr
     module procedure create_and_write_variable_double_precision_1_nr
     module procedure create_and_write_variable_double_precision_2_nr
     module procedure create_and_write_variable_double_precision_3_nr
     module procedure create_and_write_variable_double_precision_4_nr
     module procedure create_and_write_variable_complex_0_nr
     module procedure create_and_write_variable_complex_1_nr
     module procedure create_and_write_variable_complex_2_nr
     module procedure create_and_write_variable_complex_3_nr
     module procedure create_and_write_variable_complex_4_nr
     module procedure create_and_write_variable_complex_16_0_nr
     module procedure create_and_write_variable_complex_16_1_nr
     module procedure create_and_write_variable_complex_16_2_nr
     module procedure create_and_write_variable_complex_16_3_nr
     module procedure create_and_write_variable_complex_16_4_nr
  end interface create_and_write_variable_noread

  interface create_and_write_distributed_fieldlike_variable
     module procedure create_and_write_dstrb_fieldlike_variable_real_2
     module procedure create_and_write_dstrb_fieldlike_variable_real_3
     module procedure create_and_write_dstrb_fieldlike_variable_real_4
     module procedure create_and_write_dstrb_fieldlike_variable_integer_2
     module procedure create_and_write_dstrb_fieldlike_variable_integer_3
     module procedure create_and_write_dstrb_fieldlike_variable_integer_4
     module procedure create_and_write_dstrb_fieldlike_variable_character_2
     module procedure create_and_write_dstrb_fieldlike_variable_character_3
     module procedure create_and_write_dstrb_fieldlike_variable_character_4
     module procedure create_and_write_dstrb_fieldlike_variable_double_precision_2
     module procedure create_and_write_dstrb_fieldlike_variable_double_precision_3
     module procedure create_and_write_dstrb_fieldlike_variable_double_precision_4
     module procedure create_and_write_dstrb_fieldlike_variable_complex_2
     module procedure create_and_write_dstrb_fieldlike_variable_complex_3
     module procedure create_and_write_dstrb_fieldlike_variable_complex_4
     module procedure create_and_write_dstrb_fieldlike_variable_complex_16_2
     module procedure create_and_write_dstrb_fieldlike_variable_complex_16_3
     module procedure create_and_write_dstrb_fieldlike_variable_complex_16_4
  end interface create_and_write_distributed_fieldlike_variable

contains

  subroutine create_and_write_variable_real_0(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    real, intent(inout) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_real_0

  subroutine create_and_write_variable_real_1(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    real, intent(inout), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_real_1

  subroutine create_and_write_variable_real_2(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    real, intent(inout), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_real_2

  subroutine create_and_write_variable_real_3(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    real, intent(inout), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_real_3

  subroutine create_and_write_variable_real_4(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    real, intent(inout), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_real_4

  subroutine create_and_write_variable_integer_0(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    integer, intent(inout) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_integer_0

  subroutine create_and_write_variable_integer_1(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    integer, intent(inout), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_integer_1

  subroutine create_and_write_variable_integer_2(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    integer, intent(inout), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_integer_2

  subroutine create_and_write_variable_integer_3(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    integer, intent(inout), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_integer_3

  subroutine create_and_write_variable_integer_4(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    integer, intent(inout), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_integer_4

  subroutine create_and_write_variable_character_0(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character, intent(inout) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_character_0

  subroutine create_and_write_variable_character_1(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character, intent(inout), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_character_1

  subroutine create_and_write_variable_character_2(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character, intent(inout), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_character_2

  subroutine create_and_write_variable_character_3(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character, intent(inout), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_character_3

  subroutine create_and_write_variable_character_4(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character, intent(inout), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_character_4

  subroutine create_and_write_variable_double_precision_0(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    double precision, intent(inout) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_double_precision_0

  subroutine create_and_write_variable_double_precision_1(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    double precision, intent(inout), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_double_precision_1

  subroutine create_and_write_variable_double_precision_2(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    double precision, intent(inout), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_double_precision_2

  subroutine create_and_write_variable_double_precision_3(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    double precision, intent(inout), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_double_precision_3

  subroutine create_and_write_variable_double_precision_4(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    double precision, intent(inout), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_double_precision_4

  subroutine create_and_write_variable_complex_0(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex, intent(inout) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_0

  subroutine create_and_write_variable_complex_1(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex, intent(inout), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_1

  subroutine create_and_write_variable_complex_2(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex, intent(inout), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_2

  subroutine create_and_write_variable_complex_3(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex, intent(inout), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_3

  subroutine create_and_write_variable_complex_4(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex, intent(inout), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_4

  subroutine create_and_write_variable_complex_16_0(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex*16, intent(inout) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_16_0

  subroutine create_and_write_variable_complex_16_1(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex*16, intent(inout), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_16_1

  subroutine create_and_write_variable_complex_16_2(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex*16, intent(inout), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_16_2

  subroutine create_and_write_variable_complex_16_3(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex*16, intent(inout), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_16_3

  subroutine create_and_write_variable_complex_16_4(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex*16, intent(inout), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_16_4


  subroutine create_and_write_variable_real_0_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    real, intent(in) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_real_0_nr

  subroutine create_and_write_variable_real_1_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    real, intent(in), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_real_1_nr

  subroutine create_and_write_variable_real_2_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    real, intent(in), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_real_2_nr

  subroutine create_and_write_variable_real_3_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    real, intent(in), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_real_3_nr

  subroutine create_and_write_variable_real_4_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    real, intent(in), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_real_4_nr

  subroutine create_and_write_variable_integer_0_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    integer, intent(in) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_integer_0_nr

  subroutine create_and_write_variable_integer_1_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    integer, intent(in), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_integer_1_nr

  subroutine create_and_write_variable_integer_2_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    integer, intent(in), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_integer_2_nr

  subroutine create_and_write_variable_integer_3_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    integer, intent(in), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_integer_3_nr

  subroutine create_and_write_variable_integer_4_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    integer, intent(in), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_integer_4_nr

  subroutine create_and_write_variable_character_0_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character, intent(in) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_character_0_nr

  subroutine create_and_write_variable_character_1_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character, intent(in), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_character_1_nr

  subroutine create_and_write_variable_character_2_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character, intent(in), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_character_2_nr

  subroutine create_and_write_variable_character_3_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character, intent(in), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_character_3_nr

  subroutine create_and_write_variable_character_4_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character, intent(in), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_character_4_nr

  subroutine create_and_write_variable_double_precision_0_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    double precision, intent(in) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_double_precision_0_nr

  subroutine create_and_write_variable_double_precision_1_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    double precision, intent(in), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_double_precision_1_nr

  subroutine create_and_write_variable_double_precision_2_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    double precision, intent(in), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_double_precision_2_nr

  subroutine create_and_write_variable_double_precision_3_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    double precision, intent(in), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_double_precision_3_nr

  subroutine create_and_write_variable_double_precision_4_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    double precision, intent(in), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_double_precision_4_nr

  subroutine create_and_write_variable_complex_0_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex, intent(in) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_0_nr

  subroutine create_and_write_variable_complex_1_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex, intent(in), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_1_nr

  subroutine create_and_write_variable_complex_2_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex, intent(in), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_2_nr

  subroutine create_and_write_variable_complex_3_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex, intent(in), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_3_nr

  subroutine create_and_write_variable_complex_4_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex, intent(in), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_4_nr

  subroutine create_and_write_variable_complex_16_0_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex*16, intent(in) :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_16_0_nr

  subroutine create_and_write_variable_complex_16_1_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex*16, intent(in), dimension(:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_16_1_nr

  subroutine create_and_write_variable_complex_16_2_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex*16, intent(in), dimension(:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_16_2_nr

  subroutine create_and_write_variable_complex_16_3_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex*16, intent(in), dimension(:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_16_3_nr

  subroutine create_and_write_variable_complex_16_4_nr(gnostics, variable_type, variable_name, dimension_list, variable_description, variable_units, val)
    use simpledataio, only: create_variable
    use simpledataio_write, only: write_variable
    use simpledataio_read, only: read_variable
    use diagnostics_config, only: diagnostics_type
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    complex*16, intent(in), dimension(:,:,:,:)  :: val
 
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
    end if


    

    if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)

  end subroutine create_and_write_variable_complex_16_4_nr


  subroutine create_and_write_dstrb_fieldlike_variable_real_2(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    real, intent(inout), dimension(:,:)  :: val
    real :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 2 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 2 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_real_2

  subroutine create_and_write_dstrb_fieldlike_variable_real_3(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    real, intent(inout), dimension(:,:,:)  :: val
    real :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 3 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 3 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_real_3

  subroutine create_and_write_dstrb_fieldlike_variable_real_4(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    real, intent(inout), dimension(:,:,:,:)  :: val
    real :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 4 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 4 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_real_4

  subroutine create_and_write_dstrb_fieldlike_variable_integer_2(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    integer, intent(inout), dimension(:,:)  :: val
    integer :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 2 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 2 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_integer_2

  subroutine create_and_write_dstrb_fieldlike_variable_integer_3(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    integer, intent(inout), dimension(:,:,:)  :: val
    integer :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 3 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 3 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_integer_3

  subroutine create_and_write_dstrb_fieldlike_variable_integer_4(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    integer, intent(inout), dimension(:,:,:,:)  :: val
    integer :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 4 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 4 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_integer_4

  subroutine create_and_write_dstrb_fieldlike_variable_character_2(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    character, intent(inout), dimension(:,:)  :: val
    character :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 2 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 2 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_character_2

  subroutine create_and_write_dstrb_fieldlike_variable_character_3(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    character, intent(inout), dimension(:,:,:)  :: val
    character :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 3 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 3 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_character_3

  subroutine create_and_write_dstrb_fieldlike_variable_character_4(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    character, intent(inout), dimension(:,:,:,:)  :: val
    character :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 4 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 4 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_character_4

  subroutine create_and_write_dstrb_fieldlike_variable_double_precision_2(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    double precision, intent(inout), dimension(:,:)  :: val
    double precision :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 2 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 2 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_double_precision_2

  subroutine create_and_write_dstrb_fieldlike_variable_double_precision_3(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    double precision, intent(inout), dimension(:,:,:)  :: val
    double precision :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 3 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 3 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_double_precision_3

  subroutine create_and_write_dstrb_fieldlike_variable_double_precision_4(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    double precision, intent(inout), dimension(:,:,:,:)  :: val
    double precision :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 4 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 4 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_double_precision_4

  subroutine create_and_write_dstrb_fieldlike_variable_complex_2(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    complex, intent(inout), dimension(:,:)  :: val
    complex :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 2 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 2 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_complex_2

  subroutine create_and_write_dstrb_fieldlike_variable_complex_3(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    complex, intent(inout), dimension(:,:,:)  :: val
    complex :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 3 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 3 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_complex_3

  subroutine create_and_write_dstrb_fieldlike_variable_complex_4(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    complex, intent(inout), dimension(:,:,:,:)  :: val
    complex :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 4 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 4 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_complex_4

  subroutine create_and_write_dstrb_fieldlike_variable_complex_16_2(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    complex*16, intent(inout), dimension(:,:)  :: val
    complex*16 :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 2 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 2 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_complex_16_2

  subroutine create_and_write_dstrb_fieldlike_variable_complex_16_3(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    complex*16, intent(inout), dimension(:,:,:)  :: val
    complex*16 :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 3 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 3 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_complex_16_3

  subroutine create_and_write_dstrb_fieldlike_variable_complex_16_4(gnostics, variable_type, variable_name, dimension_list, &
    variable_description, variable_units, val)
    use simpledataio, only: create_variable, set_start, set_count
    use simpledataio, only: set_independent, set_collective
    use simpledataio_write, only: write_variable, write_variable_with_offset
    use simpledataio_read, only: read_variable, read_variable_with_offset
    use diagnostics_config, only: diagnostics_type
    use diagnostics_dimensions, only: dim_string
    use mp, only: mp_abort,barrier
    use file_utils, only: error_unit
    use fields_parallelization, only: field_k_local
    use kt_grids, only: naky, ntheta0
    type(diagnostics_type), intent(in) :: gnostics
    integer, intent(in) :: variable_type
    character(*), intent(in) :: variable_name
    character(*), intent(in) :: dimension_list
    character(*), intent(in) :: variable_description
    character(*), intent(in) :: variable_units
    character(len=len(dimension_list)), dimension(5) :: dimension_names
    character(len=len(dimension_list)) :: buffer
    integer :: xdim, idim, i, count, dimlistlength
    integer :: id, it, ik
    integer :: i1 !, i2, i3
    complex*16, intent(inout), dimension(:,:,:,:)  :: val
    complex*16 :: dummy
   
    !return 
    ! Check the dimension list contains kx,ky
!<DD>This may need changing if we change the string used to identify kx and ky.
    xdim = index(dimension_list, trim(dim_string([gnostics%dims%kx,gnostics%dims%ky])))

    if (xdim .eq. 0) then
       write(error_unit(), *) "The function create_and_write_dstrb_field_like_variable should &
            & only be called for arrays whose dimension list contains kx,ky in that order"
       call mp_abort("")
    end if

    ! Split the dimension list into an array of dimension names
    idim = 0
    count = 1
    buffer = ''
    dimlistlength = len(trim(dimension_list))
    do i = 1,dimlistlength
      !write (*,*) 'dimension_list', dimension_list, buffer, i, 'dimension_names', dimension_names
      if (dimension_list(i:i) .eq. "," .or. (i .eq. dimlistlength)) then
        if (i .eq. dimlistlength) then
          buffer(count:count) = dimension_list(i:i)
          count = count + 1
        end if
        idim = idim + 1
        dimension_names(idim) = trim(buffer)
        if (trim(dimension_names(idim)) .eq. trim(dim_string(gnostics%dims%kx))) xdim = idim
        buffer = ''
        count = 1
      else
        buffer(count:count) = dimension_list(i:i)
        count = count + 1
      end if
    end do
    !write (*,*) 'dimension_names', dimension_names(1:idim)
 
    !write (*,*) 'starting create_variable', variable_name, trim(dimension_list)
    if (gnostics%create) then 
       call create_variable(gnostics%sfile, variable_type, variable_name, trim(dimension_list), variable_description, variable_units)
       if (gnostics%distributed) then
       end if
    end if
    !write (*,*) 'Finished create variable', variable_name


    if (gnostics%wryte .or. gnostics%reed) then
       if (.not.  gnostics%distributed) then
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, val)
          if (gnostics%reed) call read_variable(gnostics%sfile, variable_name, val)

       else
          ! For some reason every process has to make at least
          ! one write to a variable with an infinite dimension.
          ! Here we make some dummy writes to satisfy that
!<DD>This will need changing if we allow multi-character dimension names
          !write (*,*) 'Starting dummy writes'
          do id = 1,idim
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), 1)
          end do
          if (gnostics%wryte) call write_variable(gnostics%sfile, variable_name, dummy)
          do id = 1,idim
             !! Reset the starts and counts
             if (trim(dimension_names(id)) .eq. trim(dim_string(gnostics%dims%time))) cycle
             call set_count(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
             !call set_start(gnostics%sfile, variable_name, trim(dimension_names(id)), -1)
          end do
          call barrier
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), 1)
          call set_count(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), 1)
          call set_independent(gnostics%sfile, variable_name)
          !write (*,*) 'Starting loop'
          do ik = 1,naky
             do it = 1,ntheta0
                if (field_k_local(it,ik)) then
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%kx)), it)
                   call set_start(gnostics%sfile, variable_name, trim(dim_string(gnostics%dims%ky)), ik)
                   ! Now we treat cases where kx and ky are not the two most
                   ! slowly varying indices
                   if (xdim < 4 - 1) then
                      call set_count(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), 1)
                      ! This loop will normally be over species
                      do i1 = 1,size(val, xdim+2)
                         call set_start(gnostics%sfile, variable_name, trim(dimension_names(xdim+2)), i1)
                         if (xdim < 4 - 2) then
                            call mp_abort("Case with two dimensions to the right of kx and ky not implemented", .true.)
                            !<DD>Should this be an mp_abort?
                            
                         else
                            if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                            if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                         end if
                      end do 
                   else
                      if (gnostics%wryte) call write_variable_with_offset(gnostics%sfile, variable_name, val)
                      if (gnostics%reed) call read_variable_with_offset(gnostics%sfile, variable_name, val)
                   end if
                end if
             end do
          end do
          call set_collective(gnostics%sfile, variable_name)
       end if
    end if

  end subroutine create_and_write_dstrb_fieldlike_variable_complex_16_4


end module diagnostics_create_and_write

