#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['registerMap',
 'registerMap.base',
 'registerMap.base.tests',
 'registerMap.constraints',
 'registerMap.constraints.tests',
 'registerMap.export',
 'registerMap.export.base',
 'registerMap.export.base.tests',
 'registerMap.export.c',
 'registerMap.export.c.elements',
 'registerMap.export.c.elements.tests',
 'registerMap.export.c.output',
 'registerMap.export.c.output.tests',
 'registerMap.export.c.tests',
 'registerMap.export.commonCppC',
 'registerMap.export.commonCppC.output',
 'registerMap.export.commonCppC.output.tests',
 'registerMap.export.cpp',
 'registerMap.export.cpp.elements',
 'registerMap.export.cpp.elements.tests',
 'registerMap.export.cpp.output',
 'registerMap.export.cpp.output.tests',
 'registerMap.export.cpp.tests',
 'registerMap.export.io',
 'registerMap.export.io.yaml',
 'registerMap.export.io.yaml.parameters',
 'registerMap.export.io.yaml.parameters.tests',
 'registerMap.export.io.yaml.tests',
 'registerMap.export.tests',
 'registerMap.structure',
 'registerMap.structure.bitmap',
 'registerMap.structure.bitmap.tests',
 'registerMap.structure.bitrange',
 'registerMap.structure.bitrange.tests',
 'registerMap.structure.elements',
 'registerMap.structure.elements.base',
 'registerMap.structure.elements.base.tests',
 'registerMap.structure.elements.field',
 'registerMap.structure.elements.field.tests',
 'registerMap.structure.elements.field.tests.parameters',
 'registerMap.structure.elements.module',
 'registerMap.structure.elements.module.tests',
 'registerMap.structure.elements.register',
 'registerMap.structure.elements.register.tests',
 'registerMap.structure.elements.register.tests.commonTests',
 'registerMap.structure.elements.tests',
 'registerMap.structure.interval',
 'registerMap.structure.interval.tests',
 'registerMap.structure.memory',
 'registerMap.structure.memory.tests',
 'registerMap.structure.set',
 'registerMap.structure.set.tests',
 'registerMap.structure.set.tests.elementSet',
 'registerMap.structure.set.tests.fieldSet',
 'registerMap.tests',
 'registerMap.utility',
 'registerMap.utility.observer',
 'registerMap.utility.observer.tests',
 'registerMap.utility.tests']

package_data = \
{'': ['*'],
 'registerMap.export.c.output': ['templates/*',
                                 'templates/idiomatic/*',
                                 'templates/macro/*'],
 'registerMap.export.cpp.output': ['templates/*',
                                   'templates/idiomatic/*',
                                   'templates/macro/*'],
 'registerMap.export.io.yaml.parameters.tests': ['data/*'],
 'registerMap.export.io.yaml.tests': ['data/*']}

install_requires = \
['jinja2', 'pyyaml']

extras_require = \
{'dev': ['nose', 'nose-cov', 'nosehtmloutput-2']}

entry_points = \
{'console_scripts': ['export-map = registerMap.exporter:entry']}

setup(name='registerMap',
      version='0.5.0',
      description='A Python 3 framework for creating and maintaining register maps for integrated circuit design and embedded',
      author='Russell Smiley',
      author_email='im.russell.smiley@gmail.com',
      url='https://gitlab.com/registerMap/registerMap',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.6',
     )
