#!/bin/bash -l

#SBATCH -J spruce_mapping
#SBATCH -t 1-20:00:00
#SBATCH -A b2015284
#SBATCH -p core -n 4
#SBATCH --mail-user jun.chen@ebc.uu.se
#SBATCH --mail-type=ALL

module load bioinfo-tools
module load BioPerl
module load bwa
module load samtools/1.3
module load vcftools
ulimit -c unlimited

echo "Sync files to $SNIC_TMP"
mkdir $SNIC_TMP/data
mkdir $SNIC_TMP/ref
mkdir $SNIC_TMP/script
mkdir $SNIC_TMP/out

FOLD=$1
OUT=$2
rsync -ta $FOLD/* $SNIC_TMP/data
rsync -t ref/* $SNIC_TMP/ref
rsync -t script/* $SNIC_TMP/script

cd $SNIC_TMP
echo "Running script"
perl script/exomeCapture-pipeline-multicores.pl -in data/ -out out/ -ref ref/picea_abies.master-rna-scaff.nov2012_sorted.fa -ex ref/probes_RG_0802-diploid_scaffolds.fa -threads 4 -nct 1 -mem 24g
cd -
echo "Sync results"
rsync -ta $SNIC_TMP/out/* $OUT
