image.scale <- function(z, zlim, col = heat.colors(12),
breaks, horiz=TRUE, ylim=NULL, xlim=NULL, ...){
 if(!missing(breaks)){
  if(length(breaks) != (length(col)+1)){stop("must have one more break than colour")}
 }
 if(missing(breaks) & !missing(zlim)){
  breaks <- seq(zlim[1], zlim[2], length.out=(length(col)+1)) 
 }
 if(missing(breaks) & missing(zlim)){
  zlim <- range(z, na.rm=TRUE)
  zlim[2] <- zlim[2]+c(zlim[2]-zlim[1])*(1E-3)#adds a bit to the range in both directions
  zlim[1] <- zlim[1]-c(zlim[2]-zlim[1])*(1E-3)
  breaks <- seq(zlim[1], zlim[2], length.out=(length(col)+1))
 }
 poly <- vector(mode="list", length(col))
 for(i in seq(poly)){
  poly[[i]] <- c(breaks[i], breaks[i+1], breaks[i+1], breaks[i])
 }
 xaxt <- ifelse(horiz, "s", "n")
 yaxt <- ifelse(horiz, "n", "s")
 if(horiz){YLIM<-c(0,1); XLIM<-range(breaks)}
 if(!horiz){YLIM<-range(breaks); XLIM<-c(0,1)}
 if(missing(xlim)) xlim=XLIM
 if(missing(ylim)) ylim=YLIM
 plot(1,1,t="n",ylim=ylim, xlim=xlim, xaxt=xaxt, yaxt=yaxt, xaxs="i", yaxs="i", ...)  
 for(i in seq(poly)){
  if(horiz){
   polygon(poly[[i]], c(0,0,1,1), col=col[i], border=NA)
  }
  if(!horiz){
   polygon(c(0,0,1,1), poly[[i]], col=col[i], border=NA)
  }
 }
}

get_DAF=function(x,size=10){
	n=length(x)
	DAF=numeric(n)
	for(i in 1:n){
		prob=as.numeric(unlist(strsplit(as.character(x[i]),':')))
		DAF[i]=sum(sample(c(0,1),size=10,prob=prob,rep=T))
	}
	return(DAF)
}

get_3D_SFS=function(x){
	size.vector=apply(x,2,max)
	sfs<-numeric((size.vector[1]+1)*(size.vector[2]+1)*(size.vector[3]+1))
	# i*j*k
	index=1
	for(i in 0:size.vector[1]){
		for(j in 0:size.vector[2]){
			for(k in 0:size.vector[3]){
				sfs[index]<-sum(x[,1]==i & x[,2]==j & x[,3]==k)
				index=index+1
			}
		}
	}
	return(sfs)
}

get_pairwise_sfs=function(x,size=c(10,10,10)){
	n=ncol(x)
	if(n!=length(size)){stop("size vector length does not equal the column number of matrix") }
	res=list()
	index=1
	for(i in 1:(n-1)){
		size_i=size[i]
		for(j in (i+1):n){
			size_j=size[j]
			my_sfs2d=matrix(numeric((size_i+1)*(size_j+1)),nrow=size_j+1)
			for(l in 0:size_i){
				for(k in 0:size_j){
					my_sfs2d[(k+1),(l+1)]=sum(x[,i]==l & x[,j]==k)	
				}
			}
			my_sfs2d<-as.data.frame(my_sfs2d)
			names(my_sfs2d)<-paste('d',i-1,'_',0:size_j,sep='')
			row.names(my_sfs2d) <- paste('d',j-1,'_',0:size_j,sep='')
			res[[index]]<-my_sfs2d
			index=index+1
		}
	}
	return(res)
}

ans_resid=function(data,obs,fold=F,mask_mono=T){
	n=nrow(obs)
	if(is.null(n)){
		n=1
	}
	data<-unlist(data)
	obs<-unlist(obs)
	#obs<-obs[-1]
	#obs<-obs[-length(obs)]
	#data<-data[-1]
	#data<-data[-length(data)]
	if(fold){
		
	}else{
		if(mask_mono){
			obs[1]<-0 # cannot fit the first
			data[1]<-0
		}
	}
	obs<-obs/sum(obs)
	data<-data/sum(data)
	residual<-1.5*(get_p1(data)-get_p1(obs))/data^(1/6)
	# residual<-c(0,residual,0)
	if(fold){
	}else{
		if(mask_mono){residual[1]<-0}
	}
	return(matrix(residual,nrow=n))
}

get_p1=function(x){
	return(x^(2/3)-x^(-1/3)/9)
}

trans_mat=function(x, l=11,j=11,k=11){
	res<-list()
	step=j*k
	for(i in 1:l){
		res[[i]]<-matrix(x[seq((i-1)*step+1,step*i)],nrow=j,byrow=T)
	}
	return(res)
}

cal_tajimas_D=function(x){
	n=10
	pi=0
	a1=0
	a2=0
	for(i in 1:(n-1)){
		pi=pi+i*(n-i)*x[i]
		a1=a1+1/i
		a2=a2+1/i^2
	}
	pi=pi/choose(n,2)
	s=sum(x)
	theta=s/a1
	b1=(n+1)/(3*(n-1))
	b2=2*(n^2 + n + 3)/(9*n*(n-1))
	c1 = b1-1/a1
	c2 = b2 - (n+2)/(a1*n) + a2/a1^2
	e1 = c1/a1
	e2 = c2/(a1^2+a2)
	D=(pi-theta)/sqrt(e1*s + e2*s*(s-1))
	return(D)
}

eval_2d_sfs=function(model, obs,fold=F, maf=F,breaks=NULL,xlab='Pop0',ylab='Pop1',mask_mono=T,mask_fixation=F,max_res=NULL,max.freq=0.5,...){
	### set mask_fixation = T for 2 population simulation, but F for 2D fit in 3 pops
	model<-as.matrix(model)
	obs<-as.matrix(obs)
	if(mask_mono){obs[1,1]<-0}
	if(mask_fixation){
		n=nrow(obs)
		m=ncol(obs)
		obs[n,m]<-0 ## for 2 pops
		model[n,m]<-0
	}
	#
	obs<-obs/sum(obs)
	model<-model/sum(model) # slightly differ
	if(maf){
		obs<-get_maf(obs)
		model<-get_maf(model)
	}else if(fold){
		obs<-fold_sfs(obs)
		model<-fold_sfs(model)
	}
	n=nrow(obs)
	m=ncol(obs)
	
	resid<-ans_resid(model,obs,fold=fold,mask_mono=mask_mono)
	# resid[c(1,n*m)]<-NA ##
	
	x.p0<-apply(obs,2,sum) ## x observed marginal
	x.p1<-apply(obs,1,sum)
	y.p0<-apply(model,2,sum)  ## y model marginal
	y.p1<-apply(model,1,sum)
	# x.p0[c(1,m)]<-NA
	# y.p0[c(1,m)]<-NA
	# x.p1[c(1,n)]<-NA
	# y.p1[c(1,n)]<-NA
	
	require(RColorBrewer)
#	mypalette<-brewer.pal(10,"Spectral")
	quartz(h=10,w=10)
	
	pal.1=colorRampPalette(c("black", "white", "blue"), space="rgb")
	max_v=c(log10(model[c(-1,-m*n)]), log10(obs[c(-1,-m*n)]))
	min_v=c(log10(model[c(-1,-m*n)]), log10(obs[c(-1,-m*n)]))
	max_v=max(max_v[!is.infinite(max_v)],na.rm=T)
	min_v=min(min_v[!is.infinite(min_v)],na.rm=T)
	
	
	if(is.null(breaks)){
		breaks=seq(min_v,max_v,length.out=10)
		myPalette=brewer.pal(length(breaks)-1,"Spectral")
	}else{
		myPalette=colorRampPalette(brewer.pal(11,"Spectral"))(length(breaks)-1)
	}
	
	#par(mfrow=c(2,2),mar=c(4,4,2,2))
	layout(matrix(c(1,3,2,4,5,6),nrow=2,byrow=T),widths=c(10,3,10),heights=c(10,10))
	par(mar=c(4,4,3,2))
	image(0:(n-1),0:(m-1),log10(t(obs)),col=myPalette,breaks=breaks, main='Observed',xlab=xlab,ylab=ylab, ...)
	image(0:(n-1),0:(m-1),log10(t(model)),col=myPalette,breaks=breaks,main='Model',xlab=xlab,ylab=ylab, ...)
	par(mar=c(4,1,3,4))
	image.scale(log10(obs),col=myPalette,breaks=breaks,horiz=F,yaxt='n',xlab=expression(log[10]),ylab='')
	axis(4,at=breaks, las=2, lab=round(breaks,2))
	
	par(mar=c(4,4,3,2))
	inf.sites<-which(is.infinite(resid))
	if(length(inf.sites)>0){
		warning(paste('sites ', inf.sites,' in residual matrix are infinite and turn into 0 !'))
		resid[inf.sites]<-0
	}
	
	if(is.null(max_res)){
		max_res<-max(abs(resid),na.rm=T)
	}
	breaks_res=seq(-max_res,max_res,length.out=100)
	image(0:(n-1),0:(m-1),t(resid),col=pal.1(length(breaks_res)-1),breaks=breaks_res,main='Residual',xlab=xlab,ylab=ylab,...)
	par(mar=c(4,1,3,4))
	image.scale(resid,col=pal.1(length(breaks_res)-1),breaks=breaks_res,horiz=F,yaxt='n',xlab='',ylab='')
	axis(4,at=c(breaks_res[seq(1,length(breaks_res),10)],breaks_res[length(breaks_res)]), las=2, lab=round(c(breaks_res[seq(1,length(breaks_res),10)],breaks_res[length(breaks_res)]),2))
	par(mar=c(4,4,3,2))
	plot(0:(m-1),x.p0,col=4,type='o',xlab='Number of alleles',ylab='Freq',main='Marginal SFS',ylim=c(0,max.freq),...)
	# axis(3,at=0:(m-1),lab=(m-1):0)
	points(0:(m-1),y.p0,col=2,type='o')
	points((n-1):0,x.p1,col=4,type='o',lty=2,pch=17)
	points((n-1):0,y.p1,col=2,type='o',lty=2,pch=17)
	legend('topleft',lty=c(1,1,2,2),col=c(4,2,4,2),pch=c(1,1,17,17),legend=c(xlab,paste(xlab,'-fitted',sep=''),ylab,paste(ylab,'-fitted',sep='')))
	return(resid)
}

get_maf=function(mat){
	x<-apply(apply(mat,1,rev),1,rev)+mat
	x.rowR<-apply(x,1,rev)
	x.rowR[upper.tri(x.rowR,diag=T)]<-0
	return(t(apply(x.rowR,2,rev)))
}

fold_sfs<-function(mat){
	n=nrow(mat)
	m=ncol(mat)
	
	row.mid=floor(n/2)
	col.mid=floor(m/2)
	upper.left.mat=mat[1:row.mid, 1:col.mid] # new mat
	upper.right.mat=mat[1:row.mid, m:(m-col.mid+1)] ## reversed 
	lower.left.mat=mat[n:(n-row.mid+1), 1:col.mid] # reversed
	lower.right.mat = mat[n:(n-row.mid+1), m:(m-col.mid+1)] ## reversed by n and m
	res<-upper.left.mat+upper.right.mat+lower.left.mat+lower.right.mat
	if(is.integer(median(1:n))){
		res<-rbind(res,mat[row.mid+1,1:col.mid])
	}
	if(is.integer(median(1:m))){
		if(is.integer(median(1:n))){
			res<-cbind(res,mat[1:(row.mid+1),col.mid+1])
		}else{
			res<-cbind(res,mat[1:row.mid,col.mid+1])
		}
	}
	return(res)
}



get_2d_from_3d=function(mat){
	## cannot estimate [0,0,0] and [10,10,10] two cells
	mat[1]<-0
	mat[length(mat)]<-0
	x<-trans_mat(mat)
	## x[[1]] = [0, j, k];  x[[2]] = [1, j, k]
	num.pop1=length(x)
	num.pop2=nrow(x[[1]])
	num.pop3=ncol(x[[1]])
	obs2_3=matrix(numeric(num.pop2*num.pop3),nrow=num.pop3) ## pop2_1
	for(i in 1:num.pop1){
		obs2_3=obs2_3+x[[i]]
	}
	obs1_2=matrix(numeric(num.pop1*num.pop3),nrow=num.pop2) ## pop1_0
	tmp=lapply(x,rowSums)
	for(i in 1:num.pop1){
		obs1_2[,i]=tmp[[i]]
	}	
	obs1_3=matrix(numeric(num.pop1*num.pop3),nrow=num.pop2) ## pop2_0
	tmp=lapply(x,colSums)
	for(i in 1:num.pop1){
		obs1_3[,i]=tmp[[i]]
	}
	rownames(obs1_2)<-paste('d1_',0:(num.pop2-1),sep='')
	colnames(obs1_2)<-paste('d0_',0:(num.pop1-1),sep='')
	
	rownames(obs1_3)<-paste('d2_',0:(num.pop3-1),sep='')
	colnames(obs1_3)<-paste('d0_',0:(num.pop1-1),sep='')
	
	rownames(obs2_3)<-paste('d2_',0:(num.pop3-1),sep='')
	colnames(obs2_3)<-paste('d1_',0:(num.pop2-1),sep='')
	
	result<-list()
	result[[1]]<-obs1_2
	result[[2]]<-obs1_3
	result[[3]]<-obs2_3
	return(result)
}

calc_hdFst_separate=function(x){ # c(RC1, RC2, AC1, AC2)
	n1=10
	n2=10
	p1=x[1]/n1
	p2=x[2]/n2
	numerator=(p1-p2)^2-p1*(1-p1)/(n1-1)-p2*(1-p2)/(n2-1)
	denominator=p1*(1-p2)+p2*(1-p1)
	return(cbind(numerator,denominator))
}

calc_hdFst_separate_from_2dSFS=function(mat){
	n1=10
	n2=10
	numerator=matrix(numeric((n1+1)*(n2+1)),nrow=nrow(mat))
	denominator=matrix(numeric((n1+1)*(n2+1)),nrow=nrow(mat))
	for(i in 0:n1){
		for(j in 0:n2){
			if((i==0 & j==0) | (i==n1 & j==n2)){
				next
			}else{
				p1=i/n1
				p2=j/n2
				numerator[(i+1),(j+1)]=(p1-p2)^2-p1*(1-p1)/(n1-1)-p2*(1-p2)/(n2-1)
				denominator[(i+1),(j+1)]=p1*(1-p2)+p2*(1-p1)	
				numerator[(i+1),(j+1)]=numerator[(i+1),(j+1)]*mat[(i+1),(j+1)]
				denominator[(i+1),(j+1)]=denominator[(i+1),(j+1)]*mat[(i+1),(j+1)]
			}
		}
	}
	return(sum(numerator)/sum(denominator))
}


plot_demo=function(data, Ne, extend=F, ...){
	g.time=25
	BOT1=100
	for(i in 1:nrow(data)){
		Na1=Ne[i]*BOT1*0.5
		Na2=Ne[i]*BOT1*0.5*0.5
	
		lines(seq(10,data$TB1[i]*g.time,length=100),rep(Ne[i],100),...)
		lines(rep(data$TB1[i]*g.time,10),seq(Ne[i],Ne[i]*BOT1,length=10),...)
		lines(seq(data$TB1[i]*g.time,data$TMG10[i]*g.time,length=100),rep(Ne[i]*BOT1,100),...)
		lines(rep(data$TMG10[i]*g.time,10),seq(Ne[i]*BOT1,Na1,length=10),...)
		lines(seq(data$TMG10[i]*g.time,data$TMG20[i]*g.time,length=100),rep(Na1,100),...)
		lines(rep(data$TMG20[i]*g.time,10),seq(Na1, Na2, length=10),...)
		if(extend){
			lines(seq(data$TMG20[i]*g.time,1e10,length=100),rep(Na2,100), ...)
		}
	}
}

find_minor_allele=function(x, n.pop=3,num.alleles=4){
	size=num.alleles*n.pop
	num.A=sum(x[seq(1,size,num.alleles)])
	num.T=sum(x[seq(2,size,num.alleles)])
	num.G=sum(x[seq(3,size,num.alleles)])
	num.C=sum(x[seq(4,size,num.alleles)])
	freq=c(num.A, num.T, num.G, num.C)
	allele.order=order(freq,decreasing=T)
	minor.allele.index=allele.order[2]
	
	if(freq[allele.order[1]]==freq[allele.order[2]]){
		minor.allele.index=minor.allele.index+0.5 ## to indicate we cannot decide which is the minor/major alleles
	}
	if(sum(freq>0)>2){
		return(NA) # more than two alleles
	}else{
		return(minor.allele.index)
	}
}


subsample_maf=function(x,size=10){
	size=sum(x[1:4])
	minor.allele.counts=x[5]
	return(sum(sample(c(0,1),size=10,prob=c(size-minor.allele.counts, minor.allele.counts),rep=T)))
}

get_jointMAF_SFS=function(x,size=c(10,10,10),amb.index){## amb.index vector mean if the maf=0.5 and cannot decide for major allele, so we give 0.5 weight for minor and major alleles
	n=ncol(x)
	if(n!=length(size)){stop("size vector length does not equal the column number of matrix") }
	res=list()
	index=1
	
	amb.alleles=x[amb.index,]
	x=x[!amb.index,]
	
	for(i in 1:(n-1)){ ## 
		size_i=size[i]
		for(j in (i+1):n){  ## 
			size_j=size[j]
			my_sfs2d=matrix(numeric((size_i+1)*(size_j+1)),nrow=size_j+1)
			for(l in 0:size_i){   ## for i
				for(k in 0:size_j){ # for j
					my_sfs2d[(k+1),(l+1)] = my_sfs2d[(k+1),(l+1)] + sum(x[,i]==l & x[,j]==k)	+ sum(amb.alleles[,i]==l & amb.alleles[,j]==k)*0.5 # add 0.5 weight to minor alleles
					my_sfs2d[(size_j-k+1),(size_i-l+1)] = my_sfs2d[(size_j-k+1),(size_i-l+1)]  + sum(amb.alleles[,i]==l & amb.alleles[,j]==k)*0.5 # add 0.5 to major alleles
				}
			}
			my_sfs2d<-as.data.frame(my_sfs2d)
			names(my_sfs2d)<-paste('d',i-1,'_',0:size_j,sep='')
			row.names(my_sfs2d) <- paste('d',j-1,'_',0:size_j,sep='')
			res[[index]]<-my_sfs2d
			index=index+1
		}
	}
	return(res)
}

