#!/bin/bash -l

#SBATCH -J spruce_merge_gvcf
#SBATCH -t 1-20:00:00
#SBATCH -A b2015284
#SBATCH -p core -n 3

ulimit -c unlimited # for java

INF=$1
OUTF=$2
POST=$3
SEED=$RANDOM
#make directory
mkdir $SNIC_TMP/junchen_${SEED}_data
mkdir $SNIC_TMP/junchen_${SEED}_ref
mkdir $SNIC_TMP/junchen_${SEED}_script
mkdir $SNIC_TMP/junchen_${SEED}_output
# copy files
echo "sync files to $SINC_TMP"
rsync -ta --include="*/" --include='*.vcf*' --exclude='*' $INF $SNIC_TMP/junchen_${SEED}_data
rsync -t merge_ref/probes_RG_0802-diploid_scaffolds* $SNIC_TMP/junchen_${SEED}_ref
rsync -t script/* $SNIC_TMP/junchen_${SEED}_script
cd $SNIC_TMP

echo "Run pipeline"
perl junchen_${SEED}_script/merge-gvcf-multicores.pl -i junchen_${SEED}_data  -o junchen_${SEED}_output  -ref junchen_${SEED}_ref/probes_RG_0802-diploid_scaffolds.fa -p $POST -m 24g -t 1

cd -
echo "Sync results to $OUTF"
#rsync -t $SNIC_TMP/junchen_${SEED}_data/*.idx $OUTF
rsync -t $SNIC_TMP/junchen_${SEED}_output/* $OUTF
