#!/bin/bash
#SBATCH -J genotype_gvcf
#SBATCH -A b2015284
#SBATCH -p core -n 6
#SBATCH -t 3-20:00:00
#SBATCH --mail-user jun.chen@ebc.uu.se
#SBATCH --mail-type=ALL

module load bioinfo-tools
#module load BioPerl/1.6.924_Perl5.18.4
#module load GATK/3.4-46

Threads=6
JavaMem=40G
JavaThreadMem=6G
GatkJar=/sw/apps/bioinfo/GATK/3.5.0/GenomeAnalysisTK.jar
Ref=ref/probes_RG_0802-diploid_scaffolds.fa
folder=$1
outfile=$2
file=${folder}/*.g.vcf.gz
call="java -Xmx${JavaMem} -jar $GatkJar -nt $Threads -T GenotypeGVCFs -R $Ref"

for i in $file; do
    call+=" -V $i"
done
call+=" -stand_emit_conf 10.0 -stand_call_conf 20.0 -o $outfile "
#call+=" -stand_emit_conf 10.0 -stand_call_conf 20.0 -allSites -o $outfile "
echo "$call "
eval $call

