#!/bin/bash
#SBATCH -A b2015284
#SBATCH -J spruce_exome_vcf_ApplyRecalibration
#SBATCH -p core -n 3
#SBATCH -t 3-00:00:00
#SBATCH --mail-user jun.chen@ebc.uu.se
#SBATCH --mail-type=ALL

module load bioinfo-tools
module load GATK
module load bioinfo-tools R
##Run from /proj/b2010042/nobackup/linkage-map/diploid-evaluation/PopGen_Recalibration/
# sync 
IN=$1
idx=${IN}.tbi
vcf=$(basename "$IN")
echo "Sync files"
rsync -ta /proj/b2015284/nobackup/private/exomeCapture/ref/probes_RG_0802-diploid_scaffolds.*  $SNIC_TMP
rsync -ta /proj/b2015284/nobackup/private/exomeCapture/spruce_exomeCapture_allPlates_RG0802_diploid_scaffolds_Cluster3_QD_MQ_BQRS_MQRS_RPRS.* $SNIC_TMP
rsync -ta $IN $SNIC_TMP
rsync -ta $idx $SNIC_TMP

cd $SNIC_TMP
echo "run GATK"
java -Xmx20g -jar /sw/apps/bioinfo/GATK/3.5.0/GenomeAnalysisTK.jar \
   -T ApplyRecalibration \
   -nt 3 \
   -R probes_RG_0802-diploid_scaffolds.fa \
   -input $vcf \
   --ts_filter_level 99.0 \
   -tranchesFile spruce_exomeCapture_allPlates_RG0802_diploid_scaffolds_Cluster3_QD_MQ_BQRS_MQRS_RPRS.tranches \
   -recalFile spruce_exomeCapture_allPlates_RG0802_diploid_scaffolds_Cluster3_QD_MQ_BQRS_MQRS_RPRS.recal \
   -mode SNP \
   -o spruce_exomeCapture_allPlates_RG0802_diploid_scaffolds_VarRecalibrate.vcf.gz
echo "completed"
echo "sync results back to folder"
cd -
rsync -ta $SNIC_TMP/spruce_exomeCapture_allPlates_RG0802_diploid_scaffolds_VarRecalibrate.vcf.* .   
