
#ifndef __SLIC_CUDA__
#define __SLIC_CUDA__

#include <stdio.h>
#include <assert.h>
#include <math.h>
#include <cfloat>

#include "cuda.cuh"

#define DLIMIT FLT_MAX
#define i(a, b, c) ((c) * shape.y * shape.x + (b) * shape.x + (a))
#define max(a,b)  ({ __typeof__ (a) _a = (a); __typeof__ (b) _b = (b); _a > _b ? _a : _b; })


struct SLICClusterCenter
{
    float f, x, y, z;
};

// Function defines
void slicSupervoxels(const float *h_src, int *h_dest, const float compactness, \
                     const int3 im_shape, const int3 sp_shape, \
                     const int3 window, const float3 spacing, \
                     float min_size_ratio=0.5, float max_size_ratio=3, \
                     unsigned short max_iter=5, bool enforce_connectivity=true,
                     int gpu=-1);

#endif __SLIC_CUDA__
