9.2 Live Loops

# Live Loops

Ok, so this section of the tutorial is the real gem. If you only read
one section, it should be this one. If you read the previous section
on Live Coding Fundamentals, `live_loop` is a simple way of doing
exactly that but without having to write so much.

If you didn't read the previous section, `live_loop` is the best way to
jam with Sonic Pi.

Let's play. Write the following in a new workspace:

```
live_loop :foo do
  play 60
  sleep 1
end
```

Now press the Run button. You hear a basic beep every beat. Nothing
fun there. However, don't press Stop just yet. Change the `60` to `65`
and press Run again.

Woah! It changed *automatically* without missing a beat. This is live coding.

Why not change it to be more bass like? Just update your code whilst it's playing:

```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8
  sleep 8
end
```

Then hit Run.

Let's make the cutoff move around:

```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Hit Run again.

Add some drums:

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Change the note from `e1` to `c1`:

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Now stop listening to me and play around yourself! Have fun!
