7.1 Controlling Running Synths

# Controlling Running Synths

So far we've only concerned ourselves with triggering new sounds and
FX. However, Sonic Pi gives us the ability to manipulate and control
currently running sounds. We do this by using a variable to capture a
reference to a synth:

```
s = play 60, release: 5
```

Here, we have a run-local variable `s` which represents the synth
playing note 60. Note that this is *run-local* - you can't access it
from other runs like functions.

Once we have `s`, we can start controlling it via the `control`
function:

```
s = play 60, release: 5
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

The thing to notice is that we're not triggering 4 different synths here
- we're just triggering one synth and then change the pitch 3 times
afterwards, while it's playing.

We can pass any of the standard parameters to `control`, so you can
control things like `amp:`, `cutoff:` or `pan:`.

## Non-controllable Parameters

Some of the parameters can't be controlled once the synth has
started. This is the case for all the ADSR envelope parameters. You can
find out which parameters are controllable by looking at their
documentation in the help system. If the documentation says *Can not be
changed once set*, you know it's not possible to control the parameters
after the synth has started.
