3.6 External Samples

# External Samples

Whilst the built-in samples can get you up and started quickly, you
might wish to experiment with other recorded sounds in your music. Sonic
Pi totally supports this. First though, let's have a quick discussion on
the portability of your piece.

## Portability

When you compose your piece purely with built-in synths and samples, the
code is all you need to faithfully reproduce your music. Think about
that for a moment - that's amazing! A simple piece of text you can email
around or stick in a [Gist](https://gist.github.com) represents
everything you need to reproduce your sounds. That makes it *really easy
to share* with your friends as they just need to get hold of the code.

However, if you start using your own pre-recorded samples, you lose this
portability. This is because to reproduce your music other people not
only need your code, they need your samples too. This limits the ability
for others to manipulate, mash-up and experiment with your work. Of
course this shouldn't stop you from using your own samples, it's just
something to consider.

<!-- ## Freesound Support -->

<!-- One way to get the ability to experiment with new sounds whilst keeping -->
<!-- code portability is to use the [Freesound](http:freesound.org) -->
<!-- support. http://freesound.org is a website which allows people to upload -->
<!-- and share their samples. Each sample uploaded gets a special number -->
<!-- (kind of like a phone number) which you can use to dial up that sample -->
<!-- from Sonic Pi. The only drawback is that you need to have internet -->
<!-- access for it to work. -->

<!-- If you currently have internet access, try it for yourself: -->

<!-- ``` -->
<!-- freesound 24787 -->
<!-- ``` -->

<!-- The first time you do this you'll hear a standard `:elec_beep` as a -->
<!-- placeholder for the sound. Y -->


## Local Samples

So how do you play any arbitrary WAV or AIFF file on your computer?
All you need to do is pass the path of that file to `sample`:

```
sample "/Users/sam/Desktop/my-sound.wav"
```

Sonic Pi will automatically load and play the sample. You can also pass
all the standard params you're used to passing `sample`:

```
sample "/Users/sam/Desktop/my-sound.wav", rate: 0.5, amp: 0.3
```
