11.1 Basic API

# Grundfunktionen der Minecraft-Pi-API

Folgende Aktionen kannst Du mit der API von Sonic Pi aus in Minecraft
Pi auslösen:

* Anzeige von Chat-Nachrichten
* die Spielerposition setzen
* die Spielerposition auslesen
* den Typ eines Minecraft-Blocks an einer Koordinate setzen
* den Typ eines Minecraft-Blocks an einer Koordinate auslesen


Schauen wir uns diese der Reihe nach an.

## Anzeige von Chat-Nachrichten

Ich zeige Dir mal, wie einfach es ist, von Sonic Pi aus die Kontrolle
über Minecraft Pi zu übernehmen. Starte also zunächst Sonic Pi und
Minecraft Pi und betrete eine Minecraft-Welt, in der Du herumlaufen
kannst.

Jetzt schreibe folgenden Code in einem leeren Arbeitsbereich von
Sonic Pi :

```
mc_message "Hallo, hier ist Sonic Pi"
```

Führe den Code aus und Du wirst die Nachricht im Minecraft-Fenster
aufblitzen sehen. Gratuliere, das ist Dein erster Minecraft-Code!
War doch gar nicht schwer, oder?

## Die Spielerposition setzen

Und jetzt zaubern wir ein wenig. Teleportiere Dich einfach, wohin
Du willst! Probiere das hier aus:

```
mc_teleport 50, 50, 50
```

Nach Klick auf *Ausführen* - Paff! - bist Du sofort an einem anderen
Ort in Deiner Minecraft-Welt. Vermutlich irgendwie hoch oben in der Luft
und Du bist aufs Land oder Wasser herunter gefallen. Was bedeuten
diese Zahlen: `50, 50, 50`? Das sind die Koordinaten der Zielposition
für den Teleport. Probiere jetzt in Deinem Code ein paar Koordinaten
aus, damit Du weißt, wie sie funktionieren. Koordinaten sind für
Minecraft-Programme sehr sehr wichtig.

## Koordinaten

Stelle Dir eine alte Piraten-Schatzkarte vor - beim großen `X` ist der
Schatz vergraben. Die genaue Position des `X` lässt sich mit zwei
Zahlen beschreiben - wie weit ist das Kreuz horizontal vom Papierrand
entfernt und wie weit vertikal. Angenommen, es ist `10cm` vom linken
Rand und `8cm` vom unteren Rand entfernt. Diese beiden Zahlen `10`
und `8` sind Koordinaten. Auch andere vergrabene Schätze auf der Karte
lassen sich mit ihrem jeweiligen Koordinaten-Zahlenpaar genau
beschreiben. Etwa die große Goldkiste bei `2` von links und `9`
von unten...

In Minecraft Pi reichen zwei Zahlen nicht mehr aus. Wir brauchen auch
eine Höhenangabe und damit besteht eine Koordinate in Minecraft aus
drei Zahlen:

* Wie weit von rechts nach links innerhalb der Welt - `x`
* Wie weit von vorn nach hinten innerhalb der Welt - `z`
* Wie hoch vom Boden aus innerhalb der Welt - `y`

Diese Minecraft-Koordinaten schreiben wir dann in der Reihenfolge
`x`, `y`, `z` auf.

## Wo befindest Du Dich?

Spielen wir also ein wenig mit den Koordinaten herum. Bewege Dich
in Minecraft Pi an einen schönen Ort und wechsele dann zu Sonic Pi.
Nun führe folgenden Code aus:

```
puts mc_location
```

Drücke *Ausführen* und im Log erscheinen die Koordinaten, an denen Du
Dich in Minecraft befindest. Merke sie Dir, bewege Dich in Minecraft
ein wenig weiter und führe den Code noch einmal aus. Hast Du gesehen,
wie sich die Koordinaten geändert haben? Probiere das noch ein bisschen
aus, damit Du ein Gefühl dafür bekommst, wie sich die Koordinaten
mit Deiner Bewegung in der Minecraft-Welt verändern. Wenn Du erst einmal
verstanden hast, wie Koordinaten funktionieren, wird das Programmieren
mit der Minecraft-Pi-API ganz einfach.

## Lass uns etwas bauen!

Jetzt weißt Du, wie Du Deine Position auslesen und Dich an beliebige
Stellen teleportieren kannst. Als nächstes können wir mit Code Dinge in
Minecraft bauen. Zum Beispiel ein Block aus Glas an Koordinate
`40, 50, 60`, das geht ganz einfach:

```
mc_set_block :glass, 40, 50, 60
```

Haha, das war ja wirklich ganz einfach. Nach getaner Arbeit springst
Du schnell in die Nähe und schaust Dir das Ergebnis an:

```
mc_teleport 35, 50, 60
```

Dreh Dich ein wenig und Du wirst Deinen Glasblock sehen! Ändern wir kurz
das Material und machen einen Block aus Diamant daraus:

```
mc_set_block :diamond, 40, 50, 60
```

Wenn Du in die richtige Richtung schaust, konntest Du eben sogar
dabei zusehen, wie sich der Block verändert. Hier geschieht etwas
aufregendes...

## Blöcke ansehen

Du kannst Minecraft Pi auch fragen, welcher Typ Block sich an einer
Koordinate befindet. Der folgende Code tut dies für den Diamantblock,
den Du gerade gebaut hast:

```
puts mc_get_block 40, 50, 60
```

Yay! Es ist `:diamond`. Ändere das Material des Blocks wieder zu Glas
und lese den Typ noch einmal aus - meldet der Code jetzt `:glass`
zurück? Ich bin sicher, dass er das tut. :-)

## Mögliche Materialtypen in Minecraft

Bevor Du jetzt mit Code durch Minecraft Pi tobst, hier noch eine
praktische Liste aller Material-Typen für Minecraft-Blöcke:

        :air
        :stone
        :grass
        :dirt
        :cobblestone
        :wood_plank
        :sapling
        :bedrock
        :water_flowing
        :water
        :water_stationary
        :lava_flowing
        :lava
        :lava_stationary
        :sand
        :gravel
        :gold_ore
        :iron_ore
        :coal_ore
        :wood
        :leaves
        :glass
        :lapis
        :lapis_lazuli_block
        :sandstone
        :bed
        :cobweb
        :grass_tall
        :flower_yellow
        :flower_cyan
        :mushroom_brown
        :mushroom_red
        :gold_block
        :gold
        :iron_block
        :iron
        :stone_slab_double
        :stone_slab
        :brick
        :brick_block
        :tnt
        :bookshelf
        :moss_stone
        :obsidian
        :torch
        :fire
        :stairs_wood
        :chest
        :diamond_ore
        :diamond_block
        :diamond
        :crafting_table
        :farmland
        :furnace_inactive
        :furnace_active
        :door_wood
        :ladder
        :stairs_cobblestone
        :door_iron
        :redstone_ore
        :snow
        :ice
        :snow_block
        :cactus
        :clay
        :sugar_cane
        :fence
        :glowstone_block
        :bedrock_invisible
        :stone_brick
        :glass_pane
        :melon
        :fence_gate
        :glowing_obsidian
        :nether_reactor_core
