9.2 Live-Loops

# Live-Loops

Ok, dieses Kapitel des Tutorials ist ein Juwel. Wenn Du nur einen 
Abschnitt lesen würdest, sollte es dieser sein. Mit `live_loop` kannst
Du genau das, was Du im letzten Abschnitt gelernt hast, viel einfacher
und mit weniger Code tun. Falls Du den letzten Abschnitt nicht gelesen
hast: `live_loop` ist der beste Weg, mit Sonic Pi zu jammen.

Also los. Schreibe folgendes in einen neuen Arbeitsbereich:

```
live_loop :foo do
  play 60
  sleep 1
end
```

Jetzt klicke den `Ausführen`-Button. Du hörst zu jeder Schlagzeit ein
einfaches Piepen. Kein besonderer Spaß. Drücke aber noch nicht den
`Stopp`-Button. Ändere die `60` in `65` und drücke wieder `Ausführen`.

Whoa! Es hat sich *automatisch* verändert, ohne einen Takt auszulassen. 
Das ist Live-Coding. Warum es jetzt nicht ein wenig bassiger machen? 
Verändere Deinen Code, während er abläuft:

```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8
  sleep 8
end
```

Dann drücke `Ausführen`.

Lass uns den Cut-Off ein wenig bewegen:

```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Drücke wieder `Ausführen`.

Füge ein Schlagzeug hinzu:

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Ändere den Ton von `e1` nach `c1`:

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Und jetzt hör auf, mir zuzuhören. Spiele selbst herum, viel Spaß!
