2.3 Synths wechseln

# Synths wechseln

Bis jetzt hatten wir viel Spaß mit Tönen und Samples. Aber 
wahrscheinlich wird Dir langsam langweilig, immer denselben Klang zu 
hören. Ist das alles, was Sonic Pi anzubieten hat? Besteht das
Live-Coding nicht aus mehr als Pieptönen? Aber klar doch, und in diesem 
Abschnitt sehen wir uns die spannenden Sounds an, die Sonic Pi
mitbringt.

## Synths

Sonic Pi bringt eine Palette an Instrumenten mit, die Synths heissen, 
eine *Kurzform für Synthesizer*. Samples sind vorher aufgenommene 
Klänge; demgegenüber erzeugen Synths neue Klänge, je nachdem, 
wie Du sie anlegst (wie das geht, werden wir später sehen). Die Synths
von Sonic Pi sind sehr wirkungsvoll und ausdrucksstark und man kann
damit tolle Sachen machen. Als erstes lernen wir, wie man einen Synth 
auswählt, den man benutzen möchte.

## Brilliante Sägen und Prophets[^5]

Einen spaßigen Sound ergibt die *Sägezahn-Welle* - probieren wir es mal 
aus:

```
use_synth :saw
play 38
sleep 0.25
play 50
sleep 0.25
play 62
```

Nehmen wir einen anderen Klang - den *Prophet*:

```
use_synth :prophet
play 38
sleep 0.25
play 50
sleep 0.25
play 62
```

Wie wäre es damit, beide Sounds zu verbinden? Zuerst nacheinander:

```
use_synth :saw
play 38
sleep 0.25
play 50
sleep 0.25
use_synth :prophet
play 57
sleep 0.25
```

Nun gleichzeitig:

```
use_synth :tb303
play 38
sleep 0.25
use_synth :dsaw
play 50
sleep 0.25
use_synth :prophet
play 57
sleep 0.25
```

Hast Du bemerkt, dass das `use_synth`-Kommando nur die nachfolgenden 
`play`-Kommandos beeinflusst? Stell es Dir als einen *großen Schalter* 
vor - neue Aufrufe von `play` werden immer den Synth benutzen, 
auf den der Schalter gerade zeigt. Du kannst diesen Schalter mit
`use_synth` auf einen anderen Synth umschalten.

## Synths entdecken

Du kannst herausfinden, welche Synths Sonic Pi für Dich bereitstellt, 
indem Du im Menü auf der linken Seite Synths anklickst (gleich über 
Fx). Es gibt über 20 Stück. Das sind einige meiner Lieblings-Synths:

* `:prophet`
* `:dsaw`
* `:fm`
* `:tb303`
* `:pulse`

Spiel mal ein bisschen herum, indem Du *in Deinem Stück die Synths 
wechselst*. Kombiniere unterschiedliche Synths oder setze sie für 
unterschiedliche Stellen in Deinem Stück ein.

[^5]: Der Name "Sägezahn" (engl. saw) kommt von der Wellenform, die
    dieser Synthesizer produziert. Wenn man sich diesen Klang mit einem
    Oszilloskop anzeigen lässt, sieht er aus wie die Zähne einer Säge.
    Der Name "Prophet" kommt von einem Synthesizer, der Ende der 70er
    Jahre vom amerikanischen Hersteller Sequential Circuits hergestellt
    wurde.
