2.2 Synth-Parameter

# Synth-Parameter: Amp and Pan

Mit Sonic Pi kannst Du nicht nur Noten und Samples abspielen.
Ebenso kannst Du die Klänge mit Parametern gestalten und beeinflussen.
Wir werden viele davon in diesem Tutorial behandeln, für jeden
Parameter gibt es ausführliche Informationen in der Hilfe. Zwei
der nützlichsten sehen wir uns gleich mal an: *Amplitude* und *Pan*.
Aber vorher lass mich kurz erklären, was Parameter eigentlich sind.

## Parameter

Die Synths von Sonic Pi lassen sich über verschiedene Parameter
verändern. Parameter sind Regler, die `play` oder `sample` 
übergeben werden; sie verändern und steuern die Art, wie sich die 
Klänge anhören. Jeder Synth hat seine eigenen Parameter, um den Klang 
fein einzustellen. Es gibt auch Parameter, die für viele 
Klänge gleich sind, z.B. `amp:` und Hüllkurven-Parameter (die wir an 
anderer Stelle besprechen).

Parameter bestehen aus zwei Teilen: Ihrem Namen (der Name des 
Reglers) und ihrem Wert (den Wert, auf den Du den Regler
setzten möchtest). Zum Beispiel könntest Du einen 
Parameter mit dem Namen `cheese:` haben, dem Du den Wert `1` geben 
möchtest.

Parameter werden den Aufrufen von `play` und `sample` mit einem Komma 
`,` übergeben, dem der Name des Parameters folgt, etwa `amp:` (vergiss 
den Doppelpunkt nicht `:`), dann eine Leerstelle und schließlich der 
Wert des Parameters. Zum Beispiel:

```
play 50, cheese: 1
```

(Den Parameter `cheese:` gibt es in Wirklichkeit gar nicht, wir nehmen 
ihn hier nur als Beispiel).

Du kannst mehrere Parameter hintereinanderschreiben, indem Du sie mit 
weiteren Kommata abtrennst:

```
play 50, cheese: 1, beans: 0.5
```

Die Reihenfolge der Parameter spielt keine Rolle, so dass die folgende
Zeile dasselbe tun würde wie die vorherige:

```
play 50, beans: 0.5, cheese: 1
```

Parameter, die vom Synth nicht erkannt werden, werden einfach links 
liegen gelassen (so wie `cheese` und `beans`, welches ja wirklich 
lachhafte Namen für einen Parameter wären!).

Wenn Du aus Versehen zweimal denselben Parameter benutzt, gewinnt der 
letzte. Im folgenden Beispiel wird `beans` den Wert 2 bekommen und 
nicht 0.5:

```
play 50, beans: 0.5, cheese: 3, eggs: 0.1, beans: 2
```

Viele Dinge in Sonic Pi lassen sich über Parameter steuern; nimm Dir 
ein bisschen Zeit zu lernen, wie Du sie einsetzten kannst, und Du bist 
startklar. Jetzt spielen wir mal mit unserem ersten Parameter: `amp:`.

## Amplitude

Die Amplitude ist die Weise, wie sich der Computer die Lautstärke eines 
Klangs vorstellt. Eine *hohe Amplitude ergibt einen lauteren Klang* und 
eine *niedrige Amplitude ergibt einen leiseren Klang*. So wie Sonic Pi 
Zahlen dazu benutzt, um Zeit und Töne darzustellen, so benutzt es 
Zahlen auch dazu, um die Lautstärke abzubilden. Eine Amplitude von 0 
bedeutet Stille (Du wirst nichts hören), eine Amplitude von 1 steht für
normale Lautstärke. Du kannst die Amplitude aufdrehen auf 2, 
10, 100. Aber Vorsicht: Wenn die Amplitude aller gemeinsamen Klänge zu 
hoch wird, setzt Sonic Pi einen sogenannten Kompressor ein,
damit die Klänge nicht zu laut für Dein Ohr werden. Oft klingt das dann 
matschig und schräg. Verwende also lieber niedrigere Amplituden, das 
heißt zwischen 0 und 0.5, um die Kompression zu verhindern.

## Amp verwenden

Um die Amplitude eines Klangs zu ändern, setze den Parameter `amp:` 
ein. Mit 0.5 lässt Du zum Beispiel den Klang mit halber Amplitude
spielen:

```
play 60, amp: 0.5
```

Und für die doppelte Amplitude:

```
play 60, amp: 2
```

Der Parameter `amp:` beeinflusst nur den Aufruf von `play`, mit dem er 
unmittelbar zusammenhängt. Das heißt, in dem folgenden Beispiel wird 
der erste Aufruf von `play` mit halber Lautstärke gespielt und der 
zweite wieder mit der Standardlautstärke (1) [^4]:

```
play 60, amp: 0.5
sleep 0.5
play 65
```

Natürlich kannst Du für jeden Aufruf von `play` andere Werte für `amp:` 
festlegen:

```
play 50, amp: 0.1
sleep 0.25
play 55, amp: 0.2
sleep 0.25
play 57, amp: 0.4
sleep 0.25
play 62, amp: 1
```

## Panning

Ein weiterer interessanter Parameter ist `pan:`. Er gibt an, aus welcher 
Richtung der Klang kommt, wenn wir in Stereo hören. Der Wert -1 schiebt
den Klang ganz nach links, 0 steht für die Mitte und 1 lässt den Klang
nur aus dem rechten Lautsprecher kommen. Natürlich kannst Du jeden Wert
zwischen -1 und 1 verwenden, um Deine Klänge im Stereofeld zu
positionieren.

Spiel einen Klang, der nur aus linken Lautsprecher kommt:

```
play 60, pan: -1
```

Jetzt aus dem rechten Lautsprecher:

```
play 60, pan: 1
```

Nun lass den Klang aus der Mitte herauskommen (die Standardposition):

```
play 60, pan: 0
```

Jetzt leg' los und arbeite mit der Amplitude und dem Panning von Deinen 
Klängen.

[^4]: In Programmiersprachen nennt man einen Standardwert einen
    `Default`. Genauer gesagt ist ein `Default`-Wert der Wert, der
    automatisch gesetzt wird, also die `Voreinstellung` im Programm.
