
% dgs-gui.m
% 
% Written by Daniel Buscombe, various times in 2012 - 2014
% while at
% School of Marine Science and Engineering, University of Plymouth, UK
% then
% Grand Canyon Monitoring and Research Center, U.G. Geological Survey, Flagstaff, AZ 
% please contact:
% dbuscombe@usgs.gov
% for lastest code version please visit:
% https://github.com/dbuscombe-usgs
% see also (project blog):
% http://dbuscombe-usgs.github.com/
%====================================
%   This function is part of 'dgs-gui' software
%   This software is in the public domain because it contains materials that originally came 
%   from the United States Geological Survey, an agency of the United States Department of Interior. 
%   For more information, see the official USGS copyright policy at 
%   http://www.usgs.gov/visual-id/credit_usgs.html#copyright
%====================================

% clear all variables and close figures
clc; clear all; close all
addpath(genpath([pwd,filesep,'subfunctions'])) % add subfbations folder to path
warning off all
%========================================================
%========================================================
%==================== MAIN WINDOWS ======================
%========================================================
%========================================================

if ~isdir('outputs')
    mkdir('outputs')
    mkdir(['outputs',filesep,'prints'])
    mkdir(['outputs',filesep,'data'])
    %mkdir(['outputs',filesep,'session'])
end

% sessionID=now; % matlab time which becomes session's unique identifier
% % create and open log file and write header
% fid=fopen([pwd,filesep,'outputs',filesep,'session',filesep,'session',datestr(sessionID,30),'.txt'],'w');
% fprintf(fid,'%s\n',['%session began at ',datestr(sessionID,31)]);
% fprintf(fid,'%s\n','%------------------------');

screencol=rand(1,3);

% main figure window
h0 = figure('Color',screencol,'HitTest','off', ...
    'Doublebuffer','on','MenuBar','none', ...
    'Name','      Digital Grain Size GUI [Version 5.2 (June 2014)].', ...
    'NumberTitle','off','PaperType','a4letter', ...
    'units','normalized', ...
    'Position',[0.05 0.05 0.75 0.75], ...
    'RendererMode','manual','Tag','main_fig');

set(h0,'toolbar','figure'); % adds usual matlab tools
hToolbar = findall(h0,'tag','FigureToolBar'); %get handle for toolbar
hButtons = findall(hToolbar); % get handle for button
set(hButtons(2:7),'Visible','off') % remove unneccessary buttons

% added n attempt to prevent gui window sliding off into another
% screen in multi screen arranegements, or worse, being spliced!
movegui(h0,'center')

h1 = uicontrol('Parent',h0,'units','normalized', ...
    'Position',[.67 .03 .5 .02],'fontname','Times', ...
    'fontsize',12, 'horizontalalignment','left', ...
    'BackgroundColor',screencol,...
    'ForegroundColor',[1 1 1],'style','text', ...
    'string',{'DGS GUI v5.2. Dan Buscombe, USGS, June 2014'}, ...
    'tag','instructions');

% image view top left window - main window
ax = axes('Parent',h0,'Box','on', ...
    'CameraUpVector',[0 1 0],'CameraUpVectorMode','manual', ...
    'Color',[1 1 1],'FontName','Times', ...
    'FontSize',12, 'Layer','top', ...
    'YLimMode','manual','XLimMode','manual','YTickMode','manual','YTickMode','manual',...
    'YTickLabelMode','manual','YTickLabelMode','manual',...
    'NextPlot','add','Position',[0.01 0.28 0.66 0.68],...
    'Tag','im_axes1','XColor',[1 1 1], 'YColor',[1 1 1], ...
    'YDir','normal', 'YLimMode','manual','ZColor',[1 1 1]);
%set(findobj(gcf,'type','axes'),'hittest','off')

% assign space for image
set(get(ax,'title'),'string',' ')
h2 = image('Parent',ax,'CData',[], ...
    'CDataMapping','scaled','Tag','current_image');
axis equal


ax2 = axes('Parent',h0, 'Box','on', ...
    'CameraUpVector',[0 1 0],'CameraUpVectorMode','manual', ...
    'Color',[1 1 1],'FontName','Times', ...
    'FontSize',12,'Layer','top', 'NextPlot','add', ...
    'Position',[0.7 0.28 0.25 0.25],...
    'Tag','plot_axes', 'XColor',[1 1 1], ...
    'YColor',[1 1 1], 'YDir','reverse', ...
    'YLimMode','manual','ZColor',[1 1 1]);

ax3 = axes('Parent',h0, 'Box','on', ...
    'CameraUpVector',[0 1 0],'CameraUpVectorMode','manual', ...
    'Color',[1 1 1],'FontName','Times', ...
    'FontSize',12, 'Layer','top', ...
    'NextPlot','add', 'Position',[0.7 0.6 0.25 0.25],...
    'Tag','auto_axes', 'XColor',[1 1 1], ...
    'YColor',[1 1 1], 'YDir','reverse', ...
    'YLimMode','manual', 'ZColor',[1 1 1]);

set(get(ax3,'title'),'string',' ')
h3a = image('Parent',ax3, 'CData',[], ...
    'CDataMapping','scaled','Tag','auto_image');
axis equal


%========================================================
%========================================================
%==================== MENUS =============================
%========================================================
%========================================================

hm1 = uimenu('Parent',h0, ...             % File menu
    'Label','File','Tag','file_menu');

hm1a = uimenu('Parent',hm1, ...
    'Callback','dgs_gui_fileload','Label','Load images', ...
    'Tag','menu_load_files');   % option 1: load images

hm1b = uimenu('Parent',hm1,'Callback','dgs_quit', ...
    'Label','Quit','Separator','on', ...
    'Tag','menu_quit'); % option 3: quit

% add 'help' option to toolbar, next to 'file'
hm1c = uimenu('Parent',h0, ...             % Help menu
    'Label','Help', 'Tag','help_menu');
hm1d = uimenu('Parent',hm1c,  'Callback','dgs_Help', ...
    'Label','How to Use This Program', ...
    'Tag','menu_help');  % callback funtion

% add 'about' option to toolbar, next to 'file'
hm1e = uimenu('Parent',h0, ...             % About menu
    'Label','About', 'Tag','about');
hm1f = uimenu('Parent',hm1e, ...
    'Callback','dgs_About',  'Label','About', ...
    'Tag','menu_about'); % callbac function


%========================================================
%========================================================
%============ BUTTONS ===================================
%========================================================
%========================================================

hp1a = uipanel('Title','Swap Images','FontSize',10,...
    'BackgroundColor','white',...
    'Position',[.68 .9 .3 .08]); % make panel for uicontrol

hp1b = uicontrol('Parent',hp1a, ...			% swop images region
    'Callback','dgs_gui_swopsimages', ...
    'units','normalized','Position',[.05 .1 .9 .8],'string',' ', ...
    'userdata',[],'style','popup','Tag','PickImage');


hp2 = uipanel('Title','Tools','FontSize',10,'BackgroundColor','white',...
    'Position',[.01 .06 .62 .16]); % make panel for uicontrol

hp2a = uicontrol('Parent',hp2, ...			%
    'Callback',[],'units','normalized', ...
    'Position',[.01 .5 .2 .3], ...
    'fontname','Times','string','Set Resolution (mm/pixel)', ...
    'style','text','tag','text_res');

hp2b = uicontrol('Parent',hp2, ...			%
    'Callback','set_resolution','units','normalized', ...
    'Position',[.01 .1 .2 .3],'fontname','Times', ...
    'string','1', 'style','edit','tag','res');

hp2d = uicontrol('Parent',hp2, ...			%
    'Callback','roi_this','units','normalized', ...
    'Position',[.23 .1 .11 .7],'fontname','Times', ...
    'style','pushbutton','string','draw ROI','tag','roi');

hp2e = uicontrol('Parent',hp2, ...			%
    'Callback','roi_whole','units','normalized', ...
    'Position',[.35 .1 .11 .7],'fontname','Times', ...
    'style','pushbutton','string','ROI whole','tag','roi_whole');

hp2f = uicontrol('Parent',hp2, ...
    'Callback','do_flatten','units','normalized', ...
    'Position',[.49 .5 .11 .3],'fontname','Times', ...
    'string','Flatten','style','pushbutton', ...
    'value',1,'tag','flatten');

hp2g = uicontrol('Parent',hp2, ...
    'Callback','un_flatten','units','normalized', ...
    'Position',[.49 .1 .11 .3], 'fontname','Times', ...
    'string','Unflatten','style','pushbutton', ...
    'value',1,'tag','unflatten');

hp2h = uicontrol('Parent',hp2, ...
    'Callback','do_filter','units','normalized', ...
    'Position',[.6 .5 .11 .3],'fontname','Times', ...
    'string','Filter','style','pushbutton', ...
    'value',1,'tag','filter');

hp2i = uicontrol('Parent',hp2, ...
    'Callback','un_filter','units','normalized', ...
    'Position',[.6 .1 .11 .3], 'fontname','Times', ...
    'string','Unfilter','style','pushbutton', ...
    'value',1,'tag','unfilter');

hp2j = uicontrol('Parent',hp2, ...			%
    'Callback',[],'units','normalized', ...
    'Position',[.72 .6 .27 .2], ...
    'fontname','Times','string','Filter Options', ...
    'style','text','tag','text_filtoptions');

hp2k = uicontrol('Parent',hp2, ...			%
    'Callback',[],'units','normalized', ...
    'Position',[.72 .4 .27 .2], ...
    'fontname','Times','string','Boost          Cutoff          Order', ...
    'style','text','tag','text_filtoptions2');

hp2l = uicontrol('Parent',hp2, ...			%
    'Callback','set_resolution','units','normalized', ...
    'Position',[.72 .1 .1 .3],'fontname','Times', ...
    'string','2', 'style','edit','tag','filtoption1');

hp2m = uicontrol('Parent',hp2, ...			%
    'Callback','set_resolution','units','normalized', ...
    'Position',[.79 .1 .1 .3],'fontname','Times', ...
    'string','0.25', 'style','edit','tag','filtoption2');

hp2n = uicontrol('Parent',hp2, ...			%
    'Callback','set_resolution','units','normalized', ...
    'Position',[.89 .1 .1 .3],'fontname','Times', ...
    'string','2', 'style','edit','tag','filtoption3');


hp3 = uipanel('Title','Calculate Size Distribution','FontSize',10,'BackgroundColor','white',...
    'Position',[.65 .06 .15 .16]); % make panel for uicontrol

hp3a = uicontrol('Parent',hp3, ...			%
    'Callback','calc_psd','units','normalized', ...
    'Position',[.02 .1 .45 .7],'fontname','Times', ...
    'string','This Image', 'style','pushbutton','tag','calc_psd');

hp3b = uicontrol('Parent',hp3, ...			%
    'Callback','calc_psd_all','units','normalized', ...
    'Position',[.5 .1 .45 .7],'fontname','Times', ...
    'string','All Images', 'style','pushbutton','tag','calc_psd_all');

hp4 = uipanel('Title','Save results','FontSize',10,'BackgroundColor','white',...
    'Position',[.81 .06 .15 .16]); % make panel for uicontrol

hp4a = uicontrol('Parent',hp4, ...			%
    'Callback','save_psd','units','normalized', ...
    'Position',[.02 .1 .45 .7],'fontname','Times', ...
    'string','Save Data', 'style','pushbutton','tag','save_psd');

hp3b = uicontrol('Parent',hp4, ...			%
    'Callback','save_fig','units','normalized', ...
    'Position',[.5 .1 .45 .7],'fontname','Times', ...
    'string','Save Graphs', 'style','pushbutton','tag','save_fig');

dgs_gui_fileload
