---
layout: page
title: Curriculum vitae
header: Vitae
---

## Daniel D. Buscombe

### Contact

USGS Grand Canyon Monitoring and Research Center,
2255 N. Gemini Drive, Flagstaff, AZ 86001 
 Email: dbuscombe@usgs.gov; Tel: 928-552-7216;
Homepage: <http://dbuscombe-usgs.github.com>

### Education
	
- Ph.D. in Coastal Geomorphology/Oceanography, 
  University of Plymouth ([PU](http://www.plymouth.ac.uk)), 
  Coastal Processes Research Group ([CPRG](http://www.coastalprocesses.org)), received August 2008
- B.Sc. (Hons) in Physical Geography, 
  Lancaster University ([LU](http://www.lancs.ac.uk)), 
  minors in Environmental Science and Biological Science, received May 2003

### Experience
- 2012--present, Research Geologist, U.S. Geological Survey 
  ([USGS](http://www.gcmrc.gov/)), 
  Grand Canyon Monitoring and Research Center, Flagstaff, AZ, USA.
- 2009--12, Post-doctoral Research Fellow, School of Marine Science and Engineering, University of Plymouth, UK
  ([UoP](http://www.coastalprocesses.org/)), 
  Turbulence, Sediment Stratification and Altered Resuspension under Waves,
- 2009--10, Computer Programming Contractor, Marine Biology & Ecology Research Centre, University of Plymouth, UK.
  ([UoP](http://www1.plymouth.ac.uk/research/mberc/Pages/default.aspx)), 
   Deep-sea image perspective transformations and GUI development work,
- 2008--09, Post-doctoral Research Scholar, University of California Santa Cruz & U.S. Geological Survey
  ([USGS](http://walrus.wr.usgs.gov/)), 
  Santa Cruz Seafloor Observatory Project
- 2008, Research Assistant, School of Geography, University of Plymouth, UK
  ([UoP](http://bardex2008.blogspot.com/)), 
  BARDEX (Barrier Dynamics Experiment), an EU Hydralab III-funded laboratory wave flume project,
- 2007--2008, Research Assistant, School of Earth, Ocean & Environmental Science, University of Plymouth, UK
  ([UoP](http://www.research.plymouth.ac.uk/whissp/index.html)), 
  WHISSP (Wave Hub Impacts on Seabed and Shoreline Processes), an EU-funded project studying the effects of marine renewable energy devices on the shoreline.,
- 2004--08, Graduate Research Assistant, School of Geography, University of Plymouth, UK


## Publications

### Morphodynamics and Sedimentology of Beaches
- **Buscombe, D.**, and Masselink, G., 2006, 
  Concepts in Gravel Beach Dynamics. Earth Science Reviews 79, 33-52.  [pdf](/docs/BuscombeMasselink_ESR2006.pdf)
- Masselink, G., **Buscombe, D.**, Austin, M.J, O'Hare, T., Russell, P., 2008, 
  Sediment Trend Models Fail to Reproduce Small Scale Sediment Transport Patterns 
  on an Intertidal Beach. Sedimentology 55, 667-687. [pdf](/docs/MasselinkEtAl2008_Sedimentology.pdf)
- **Buscombe, D.**, 2003, The Short-Term Morphodynamic Response of a Ridge-and-Runnel System on a Macrotidal Beach: B.Sc. thesis, Lancaster University, UK, 92 p.
- **Buscombe, D.**, 2008, Morphodynamics, Sediment Dynamics and Sedimentation of a Gravel Beach: Ph.D. dissertation, University of Plymouth, UK, 346 p., [pdf](/docs/Buscombe_thesis_june2008.pdf)
- Austin, M.J., and **Buscombe, D.**, 2008, 
  Morphological Change and Sediment Dynamics of the Beach Step on a Macrotidal Gravel Beach. 
  Marine Geology 249, 167-183.  [pdf](/docs/AustinBuscombe_MarGeol2008.pdf)
- Masselink, G., and **Buscombe, D.**, 2008, 
  Shifting gravel: A case study of Slapton Sands. Geography Review 22 (1), 27-31.  [pdf](/docs/shifting-gravel-coasts-GR.pdf)
- Williams, J., Masselink, G., **Buscombe, D.**, Turner, I., Matias, A., Ferreira, O., Meltje, N., Bradbury, A., Albers, T., and Pan, S., 2009,
  BARDEX (Barrier Dynamics Experiment): Taking the Beach into the Laboratory. Journal of Coastal Research SI 56, 158-162. [pdf](/docs/WilliamsEtAl2009.pdf)
- Williams, J.J., **Buscombe, D.**, Masselink, G., Turner, I., and Swinkels, C., 2012, Barrier Dynamics Experiment (BARDEX): Aims, Design and Procedures. Coastal Engineering 63, 3-12. doi:10.1016/j.coastaleng.2011.12.009, [pdf](/docs/WilliamsEtAl_CoastEng2012.pdf)

### Granular Simulations and Automated Measurements of Grain Size from Images	

- **Buscombe, D.**, 2008, Estimation of Grain Size Distributions and Associated Parameters from Digital Images of Sediment. Sedimentary Geology 210, 1-10. [pdf](/docs/Buscombe2008_SedGeol.pdf)
- **Buscombe, D.**, and Masselink, G., 2009, Grain Size Information from the Statistical Properties of Digital Images of Sediment. Sedimentology 56, 421-438. [pdf](/docs/BuscombeMasselink_Sedimentology2009.pdf)
- Warrick, J.A., Rubin, D.M., Ruggiero, P., Harney, J., Draut, A.E., and **Buscombe, D.**, 2009, Cobble Cam: Grain-size Measurements of Sand to Boulder from Digital Photographs and Autocorrelation Analyses. Earth Surface Processes and Landforms 34, 1811-1821.[pdf](/docs/WarrickEtAl_ESPL2009.pdf)
- **Buscombe, D.**, Rubin, D.M., and Warrick, J.A., 2010, Universal Approximation of Grain Size from Images of Non-Cohesive Sediment. Journal of Geophysical Research - Earth Surface 115, F02015, doi:10.1029/2009JF001477 [pdf](/docs/BuscombeEtAl_JGR2010.pdf)
- **Buscombe, D.**, and Rubin, D.M., 2012, Advances in the Simulation and Automated Measurement of Well-Sorted Granular Material, Part 1: Simulations. Journal of Geophysical Research - Earth Surface 117, F02001. doi:10.1029/2011JF001974.[pdf](/docs/BuscombeRubin2012_part1_2011JF001974.pdf)
- **Buscombe, D.**, and Rubin, D.M., 2012, Advances in the Simulation and Automated Measurement of Well-Sorted Granular Material, Part 2: Direct Measures of Particle Properties. Journal of Geophysical Research - Earth Surface 117, F02002. doi:10.1029/2011JF001975. [pdf](/docs/BuscombeRubin2012_part2_2011JF001975.pdf)
- **Buscombe, D.**, 2013, Transferable Wavelet Method for Grain Size-Distribution from Images of Sediment Surfaces and Thin Sections, and Other Natural Granular Patterns. Sedimentology, 60: 1709–1732. doi: 10.1111/sed.12049 [pdf](/docs/Buscombe2013_Sedimentology_sed12049.pdf)

### Sediment transport and hydrodynamics	
- **Buscombe, D.**, and Conley, D.C., 2012, Effective Shear Stress of Graded Sediment. Water Resources Research, 48, W05506, doi:10.1029/2010WR010341 [pdf](/docs/BuscombeConley2012_2010WR010341.pdf)
- Lacy, J.R., Rubin, D.M. and **Buscombe, D.**, 2012, Currents, Drag and Sediment Transport Induced by a Tsunami. Journal of Geophysical Research - Oceans, 117, C09028, doi:10.1029/2012JC007954 [pdf](/docs/LacyEtAl_JGR2012_2012JC007954.pdf)
- Puleo, J., Blenkinsopp, C., Conley, D., Masselink, G., Turner, I., Russell, P., **Buscombe, D.**, Howe, D., Lanckriet, T., McCall, R., and Poate, T., 2013, A Comprehensive Field Study of Swash-Zone Processes, Part 1: Experimental Design with Examples of Hydrodynamic and Sediment Transport Measurements. Journal of Waterway, Port, Coastal, and Ocean Engineering, 140, 29–42. 10.1061/(ASCE)WW.1943-5460.0000210. [pdf](/docs/PuleoEtAl2013_JWPCOEng.pdf)
- **Buscombe, D.**, Rubin, D.M., Lacy, J.R., Storlazzi, C., Hatcher, G., Chezar, H., Wyland, R., and Sherwood, C., 2014, Autonomous bed-sediment imaging-systems for revealing temporal variability of grain size. Limnology and Oceanography: Methods, 12, 390 - 406. [pdf](/docs/390-406_0121_Buscombe_LOM2014.pdf)

### Sediment optics and acoustics	
- **Buscombe, D.**, Grams, P.E., Kaplinski, M.A., 2014, Characterizing riverbed sediment using high-frequency acoustics 1: Spectral properties of scattering. Journal of Geophysical Research - Earth Surface 119, doi:10.1002/2014JF003189.[pdf](/docs/Buscombe_et_al-2014-Journal_of_Geophysical_Research-_Earth_Surface_part1.pdf)
- **Buscombe, D.**, Grams, P.E., Kaplinski, M.A., 2014, Characterizing riverbed sediment using high-frequency acoustics 2: Scattering signatures of Colorado River bed sediment in Marble and Grand Canyons. Journal of Geophysical Research - Earth Surface 119, doi:10.1002/2014JF003191.[pdf](/docs/Buscombe_et_al-2014-Journal_of_Geophysical_Research-_Earth_Surface_part2.pdf)
- Davies, E.J., **Buscombe, D.**, Graham, G.W., Nimmo-Smith, W.A.M., 2015, Evaluating Unsupervised Methods to Size and Classify Suspended Particles using Digital in-line Holography. Journal of Atmospheric and Oceanographic Technology 32, 1241 - 1256.[pdf](/docs/DaviesEtAl2015_jtech.pdf) 
- **Buscombe, D.**, Grams, P.E., Smith, S., 2015, Automated riverbed sediment classification using low-cost sidescan sonar. Journal of Hydraulic Engineering, accepted June 2015.
- **Buscombe, D.**, Conley, D.C., and Nimmo-Smith, W.A.M., in prep., Sorting in the Surf Zone on an Energetic Sand Beach Revealed by Acoustic and Holographic Measurements of Suspended Sediment. Intended for Marine Geology.

### Computational geosciences	
- **Buscombe, D.**, submitted, Spatially explicit spectral analysis of point clouds and geospatial data. Computers and Geosciences


### Selected Conference Proceedings
- **Buscombe, D.**, Austin, M.J., and Masselink, G., 2007, Field observations of step dynamics on a macrotidal gravel beach. In Kraus, N., and Rosati, J., (Eds) Proceedings of Coastal Sediments 2007 (Volume 1), ASCE, USA. [pdf](/docs/BuscombeEtAL_CSeds07.pdf)
- **Buscombe, D.**, Masselink, G., and Rubin, D.M., 2008, Granular Properties from Digital Images of Sediment: Implications for Coastal Sediment Transport Modelling. International Conference on Coastal Engineering (ICCE), Hamburg, 2008 [pdf](/docs/BuscombeEtAl2008_CoastalEngineering.pdf)
- **Buscombe, D.**, and Conley, D.C., 2012, Schmidt number of sand suspensions under oscillating-grid turbulence. International Conference on Coastal Engineering, Santander, July 2012.[pdf](/docs/Buscombe_Conley_ICCE_2012.pdf)
- Conley, D.C., **Buscombe, D.**, and Nimmo-Smith, A., 2012, Use of digital holographic cameras to examine the measurement and understanding of sediment suspension in the nearshore. International Conference on Coastal Engineering, Santander, July 2012.[pdf](/docs/ConleyEtAl_ICCE_2012.pdf)


### Selected Presentations
- Coastal Sediments 2007, New Orleans, Field observations of step dynamics on a macrotidal gravel beach. [pdf](/docs/DBuscombe_CoastalSediments07_final.pdf)
- AGU Fall Meeting, San Francisco, CA, Dec 2007, The relationship between sediment properties and sedimentation patterns on a macrotidal gravel beach over a semi lunar tidal cycle. [pdf](/docs/Buscombe_AGU2007.pdf)
- AGU Fall Meeting, San Francisco, CA, Dec 2008, The relative importance of cross- and along-shore sediment transport in planform and profile adjustments of a gravel barrier beach: Slapton, Devon, UK. [pdf](/docs/AGUPres_2008.pdf)
- International Conference on Coastal Engineering (ICCE), Hamburg, 2008, Granular Properties from Digital Images of Sediment: Implications for Coastal Sediment Transport Modelling. [pdf](/docs/ICCE2008_final.pdf)
- 9th Federal Interagency Sedimentation Conference, Las Vegas June 2010,  An automated and 'universal' method for measuring mean grain size from a digital image of sediment. [pdf](/docs/10A_Buscombe_06_30_10.pdf)
- Ocean Sciences, Portland, OR, Feb 2010, Fractional resuspension and sediment flux on a wave-dominated, non-cohesive inner continental shelf: Santa Cruz, California. [pdf](/docs/OceanScience2010.pdf)
- European Geophysical Union Annual Meeting, 2010, The effect of grain size distribution on fluid-sediment feedback. [pdf](/docs/EGU_Pres_2010.pdf)
- Particles in Europe, Villefranche-sur-Mer, France, 2010, Hourly Measurements of Grain-Size from the Inner Continental Shelf Seabed Using a Fully-Automated, Hydraulically-Controlled Underwater Video Microscope [pdf](/docs/Buscombe_PiE_lr.pdf)
- European Geophysical Union Annual Meeting, 2011, Formula for motion threshold per grain size for graded sediments in steady flows. [pdf](/docs/EGU2011_poster.pdf)
- AGU Fall Meeting, San Francisco, CA, Dec 2011, How do you tell how big something is without direct measurement? Estimating grain size using an image’s spectrum. [pdf](/docs/AGUpres_2011.pdf)
- Ocean Sciences, Salt Lake City, UT, Feb 2012, Co-variation of intertidal morphology, bedforms and grain size on a macrotidal sand beach: Praa Sands, UK. [pdf](/docs/Buscombe_OceanSciences2012.pdf)
- International Conference on Coastal Engineering, Santander, Spain, July 2012, Use of digital holographic cameras to examine the measurement and understanding of sediment suspension in the nearshore. [pdf](/docs/Conley_etal_ICCE2012.pdf)
- International Conference on Coastal Engineering, Santander, Spain, July 2012, Schmidt number of sand suspensions under oscillating-grid turbulence. [pdf](/docs/BUSCOMBE_ICCE_oscillGrid.pdf)
- American Geophysical Union Fall Meeting, San Francisco, Dec 2013, Acoustic Scattering by an Heterogeneous River Bed: Relationship to Bathymetry and Implications for Sediment Classification using Multibeam Echosounder Data. [pdf](/docs/Buscombe_etal_agufall_2013_lowres.pdf)
- American Geophysical Union Fall Meeting, San Francisco, Dec 2013, Evaluating Unsupervised Methods to Size and Classify Suspended Particles Using Digital Holography. American Geophysical Union Fall Meeting, San Francisco, Dec 2013 (poster). [pdf](/docs/Buscombe_aguposter2013_lowres.pdf)
- American Geophysical Union Fall Meeting, San Francisco, Dec 2014, Topographic and acoustic estimates of grain-scale roughness from high-resolution multibeam echo-sounder: Examples from the Colorado River in Marble Canyon. [pdf](/docs/buscombe_agu2014_lr.pdf)


### Technical Reports

- **Buscombe, D.**, and Scott, T.M., 2008, Coastal Geomorphology of North Cornwall: St Ives to Trevose Head. Internal report for Wave Hub Impacts on Seabed and Shoreline Processes, University of Plymouth. 170p. [pdf](/docs/whissp_deskstudy_mar08_lowres_lr.pdf)
- **Buscombe, D.**, Williams, J. J., and Masselink, G., 2008, BARDEX (Barrier Dynamics Experiment): experimental procedure, technical information and data report. Technical report for the European Union Hydralab III, 219p. 


### Membership in Professional Societies

- American Geophysical Union (AGU), member since 2007
- British Society for Geomorphology,  member since 2006
- Challenger Society for Marine Science,  member since 2008
- Coastal Zone Network (COZONE),  member since 2005
- International Association of Sedimentologists (IAS),  member since 2007

### Reviewer

I have served as a reviewer for the following journals:

Arctic; Continental Shelf Research; Earth Surface Processes and Landforms; Geo-Marine Letters; Geophysical Research Letters; Journal of Geophysical Research - Planets; Journal of Hydraulic Engineering; Journal of Mountain Science; Journal of Sedimentary Research; Marine Geology; Sedimentology; Sedimentary Geology; Water Resources Research.

![center](/figs/cv.JPG) 



